/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.bfd.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnSingleReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_model.QAsnBfdInfo;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnDeleteBfdReq;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnDeleteBfdRsp;
import com.huawei.vmf.adapter.bfd.translation.asn.QAsnBfdInfoTranslator;
import com.huawei.vmf.adapter.bfd.util.BfdKeyParser;
import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.service.ICompositeService;
import com.huawei.vmf.adapter.framework.task.AbstractConfigQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.transaction.NestingContext;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.bfd.model.BfdAllSession;
import com.huawei.vmf.adapter.fservice.bfd.model.BfdCfgSession;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import java.util.Arrays;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class DeleteBfdTask
extends AbstractConfigQTask<QAsnDeleteBfdReq, QAsnDeleteBfdRsp> {
    public DeleteBfdTask() {
        super(EOperationType.DELETE);
        this.addMoCompositeService(BfdCfgSession.class, (ICompositeService)new DefaultCompositeService(BfdCfgSession.class));
    }

    protected void executeTask(QAsnDeleteBfdReq req, QAsnDeleteBfdRsp rsp, Task task) {
        AsnTranslationContext asnTranslationContext = new AsnTranslationContext();
        Context context = new Context();
        asnTranslationContext.setTransactionContext(context);
        rsp.oResult = new QAsnSingleReturn();
        rsp.oResult.isSuccess = true;
        boolean totalRes = true;
        for (Object bfdKey : req.lstBfdKey) {
            QAsnUniResID fdn = (QAsnUniResID)bfdKey;
            QAsnBfdInfo asnBfd = new QAsnBfdInfo();
            this.initBfdInfo(asnBfd);
            BfdKeyParser parser = new BfdKeyParser();
            String strfdn = StringUtil.globalString((byte[])fdn.strFDN);
            parser.deserialize(strfdn);
            asnBfd.bfdFdn = fdn;
            asnBfd.neID = fdn.neID;
            asnBfd.strName = parser.getBfdName().getBytes();
            asnBfd.poOperResult = new QAsnSingleReturn();
            asnBfd.poOperResult.isSuccess = true;
            asnBfd.poOperResult.retCode = 0;
            try {
                if (!CollectionUtils.isEmpty(this.loadBfdCfgSessionByKey(context, fdn))) {
                    DefaultMOService deployService = new DefaultMOService();
                    BfdCfgSession bfdSession = new BfdCfgSession();
                    bfdSession.setDevID(Integer.valueOf(fdn.neID));
                    NestingContext megContext = new NestingContext(fdn.neID, false);
                    bfdSession.setSessName(parser.getBfdName());
                    megContext.addChangeRecord(BfdCfgSession.class).addDelete((Object)bfdSession);
                    megContext.addFeatureMoType(FeatureName.BFD, BfdCfgSession.class);
                    deployService.addDeployJob(megContext);
                    deployService.deploy();
                    ErrorInfo error = deployService.getErrorInfo((VmfMO)bfdSession);
                    if (0 != error.getErrorCode()) {
                        totalRes = false;
                        asnBfd.poOperResult.isSuccess = false;
                        asnBfd.poOperResult.retCode = error.getErrorCode();
                        asnBfd.poOperResult.reason = null != error.getErrorMessage() ? error.getErrorMessage().getBytes() : "".getBytes();
                    } else {
                        IMOChangeRecord record = asnTranslationContext.getTransactionContext().addDBChangeRecord(BfdCfgSession.class);
                        record.addDelete((Object)bfdSession);
                        DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, context).merge(false, new Class[]{BfdCfgSession.class});
                    }
                }
                if (0 == asnBfd.poOperResult.retCode && !CollectionUtils.isEmpty(this.loadBfdAllSessionByKey(context, fdn))) {
                    BfdAllSession bfdSession = new BfdAllSession();
                    bfdSession.setDevID(Integer.valueOf(fdn.neID));
                    bfdSession.setSessName(parser.getBfdName());
                    IMOChangeRecord record = asnTranslationContext.getTransactionContext().addDBChangeRecord(BfdAllSession.class);
                    record.addDelete((Object)bfdSession);
                    DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, context).merge(false, new Class[]{BfdAllSession.class});
                }
            }
            catch (VMFException e) {
                totalRes = false;
                asnBfd.poOperResult.isSuccess = false;
                asnBfd.poOperResult.retCode = e.getErrorCode();
                asnBfd.poOperResult.reason = null != e.getErrorMessage() ? e.getErrorMessage().getBytes() : "".getBytes();
            }
            rsp.lstBfdInfo.add((Object)asnBfd);
        }
        if (totalRes) {
            rsp.oResult.isSuccess = totalRes;
            rsp.oResult.retCode = 0;
        } else {
            rsp.oResult.isSuccess = false;
            rsp.oResult.retCode = 1107499878;
        }
    }

    private void initBfdInfo(QAsnBfdInfo asnBfd) {
        asnBfd.iAdminStatus = -1;
        asnBfd.iBfdDeployStatus = -1;
        asnBfd.iDetectMult = -1;
        asnBfd.iLocalID = -1;
        asnBfd.iMinRxInterval = -1;
        asnBfd.iMinTxInterval = -1;
        asnBfd.iRemoteID = -1;
        asnBfd.isCommit = false;
        asnBfd.iServiceType = -1;
        asnBfd.iSessionStatus = -1;
        asnBfd.iSessionType = -1;
        asnBfd.isProcessIf = -1;
        asnBfd.isProcessPst = false;
        asnBfd.iTosExp = -1;
        asnBfd.iWtr = -1;
        asnBfd.poAutoNegotiate = -1;
        asnBfd.poSessionID = -1;
        asnBfd.strDescription = "".getBytes();
    }

    private Collection<BfdCfgSession> loadBfdCfgSessionByKey(Context context, QAsnUniResID resKey) throws VMFException {
        BfdCfgSession session = new BfdCfgSession();
        session.setDevID(Integer.valueOf(resKey.neID));
        BfdKeyParser parser = new BfdKeyParser();
        String strfdn = StringUtil.globalString((byte[])resKey.strFDN);
        parser.deserialize(strfdn);
        session.setSessName(parser.getBfdName());
        String[] fieldNames = new String[]{"devID", "sessName"};
        Collection seList = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, context).queryByFields(BfdCfgSession.class, fieldNames, Arrays.asList(session), false);
        return seList;
    }

    private Collection<BfdAllSession> loadBfdAllSessionByKey(Context context, QAsnUniResID resKey) throws VMFException {
        BfdAllSession session = new BfdAllSession();
        session.setDevID(Integer.valueOf(resKey.neID));
        BfdKeyParser parser = new BfdKeyParser();
        String strfdn = StringUtil.globalString((byte[])resKey.strFDN);
        parser.deserialize(strfdn);
        session.setSessName(parser.getBfdName());
        String[] fieldNames = new String[]{"devID", "sessName"};
        Collection seList = DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, context).queryByFields(BfdAllSession.class, fieldNames, Arrays.asList(session), false);
        return seList;
    }

    protected void encode(QAsnDeleteBfdRsp rsp, IAsnTranslationContext context) {
    }

    protected Integer getAsnBestEffort(QAsnDeleteBfdReq req) {
        return null;
    }

    protected byte[] getAsnTaskFlag(QAsnDeleteBfdReq req) {
        return req.poTaskFlag;
    }

    private QAsnBfdInfo translateBfdCfgSession(BfdCfgSession bfdCfgSession, IAsnTranslationContext context) {
        try {
            QAsnBfdInfoTranslator translator = new QAsnBfdInfoTranslator();
            QAsnBfdInfo asn = new QAsnBfdInfo();
            translator.encode(bfdCfgSession, asn, context);
            return asn;
        }
        catch (VMFException e) {
            this.getLogger().error("mo(BfdCfgSession) translate to asn(QAsnBfdInfo) failed", (Throwable)e);
            return null;
        }
    }

    protected void decode(QAsnDeleteBfdReq req, Task task, IAsnTranslationContext asnTranslatorContext) {
    }
}

