/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.bfd.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnSingleReturn;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_model.QAsnBfdInfo;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnCreateBfdReq;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnCreateBfdRsp;
import com.huawei.vmf.adapter.bfd.translation.asn.QAsnBfdInfoTranslator;
import com.huawei.vmf.adapter.common.exception.ErrorInfo;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.DefaultCompositeService;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.service.OperResult;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslatorUtil;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.bfd.model.BfdAllSession;
import com.huawei.vmf.adapter.fservice.bfd.model.BfdCfgSession;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class CreateBfdTask
extends AbstractQTask<QAsnCreateBfdReq, QAsnCreateBfdRsp> {
    protected void executeTask(QAsnCreateBfdReq req, QAsnCreateBfdRsp rsp, Task task) {
        rsp.oResult.retCode = 0;
        IAsnTranslationContext bfdContext = this.getContext(req);
        ArrayList<QAsnBfdInfo> lstBfdInfoAsn = new ArrayList<QAsnBfdInfo>();
        for (Object obj : req.lstBfdDetailInfo) {
            QAsnBfdInfo bfdDetailInfo = (QAsnBfdInfo)obj;
            lstBfdInfoAsn.add(bfdDetailInfo);
        }
        this.createBfdtoDev(lstBfdInfoAsn, bfdContext);
        if (lstBfdInfoAsn.size() > 0) {
            Context context = bfdContext.getTransactionContext();
            IMOChangeRecord bfdCfgSessionRecord = context.getChangeRecord(BfdCfgSession.class);
            OperResult operResult = context.getOperResult();
            int ret = operResult.hasFailed() ? 1107499878 : 0;
            rsp.oResult.retCode = ret;
            Set bfdCfgSessions = bfdCfgSessionRecord.getAllChanges();
            boolean totalRes = true;
            for (BfdCfgSession bfdSee : bfdCfgSessions) {
                Context dbContext = new Context();
                ErrorInfo errorInfo = operResult.getMoOperResult((VmfMO)bfdSee);
                QAsnBfdInfo asnBfd = this.translateBfdCfgSession(bfdSee, bfdContext);
                if (null == asnBfd) {
                    totalRes = false;
                    continue;
                }
                if (!AsnTranslatorUtil.getQAsnSingleReturn((VmfMO)bfdSee, (IAsnTranslationContext)bfdContext).isSuccess) {
                    totalRes = false;
                    if (null == asnBfd.poOperResult) {
                        asnBfd.poOperResult = new QAsnSingleReturn();
                    }
                    if (null != errorInfo) {
                        asnBfd.poOperResult.isSuccess = false;
                        asnBfd.poOperResult.retCode = errorInfo.getErrorCode();
                        asnBfd.poOperResult.reason = null != errorInfo.getErrorMessage() ? errorInfo.getErrorMessage().getBytes() : null;
                    }
                }
                try {
                    Thread.sleep(Long.valueOf("3000"));
                }
                catch (InterruptedException e) {
                    this.getLogger().error("wait sleep before perform device error. , delayTime=s.");
                }
                Collection<BfdAllSession> instances = this.queryBfdSessionFromDev(asnBfd);
                HashSet<BfdAllSession> instancesInDB = new HashSet<BfdAllSession>();
                if (!CollectionUtils.isEmpty(instances)) {
                    BfdAllSession instanceInDB = new BfdAllSession();
                    BfdAllSession bfdSessionInfo = instances.iterator().next();
                    if (null != bfdSessionInfo && null != bfdSessionInfo.getLocalDiscr()) {
                        asnBfd.iLocalID = bfdSessionInfo.getLocalDiscr();
                        instanceInDB.setLocalDiscr(bfdSessionInfo.getLocalDiscr());
                        this.getLogger().error("createbfd queryBfdLocalIDFromDev LocalID\uff1a" + bfdSessionInfo.getLocalDiscr() + " sessionname\uff1a" + bfdSee.getSessName());
                    }
                    if (null != bfdSessionInfo && null != bfdSessionInfo.getRemoteDiscr()) {
                        asnBfd.iRemoteID = bfdSessionInfo.getRemoteDiscr();
                        instanceInDB.setRemoteDiscr(bfdSessionInfo.getRemoteDiscr());
                        this.getLogger().error("createbfd queryBfdRemoteIDFromDev RemoteID\uff1a" + bfdSessionInfo.getRemoteDiscr() + " sessionname\uff1a" + bfdSee.getSessName());
                    }
                    instanceInDB.setDevID(Integer.valueOf(asnBfd.neID));
                    instanceInDB.setSessName(AsnUtil.strValue((byte[])asnBfd.strName));
                    instanceInDB.setVrID(Integer.valueOf(0));
                    instanceInDB.setCreateType(Integer.valueOf(1));
                    instancesInDB.add(instanceInDB);
                }
                Iterator i$ = lstBfdInfoAsn.iterator();
                while (i$.hasNext()) {
                    String qstrSessNameforrsp;
                    QAsnBfdInfo obj;
                    QAsnBfdInfo bfdDetailInfoofreq = obj = (QAsnBfdInfo)i$.next();
                    int qNeIDofreq = bfdDetailInfoofreq.neID;
                    int qNeIDforrsp = asnBfd.neID;
                    String qstrSessNameofreq = StringUtil.globalString((byte[])bfdDetailInfoofreq.strName);
                    if (!qstrSessNameofreq.equals(qstrSessNameforrsp = StringUtil.globalString((byte[])asnBfd.strName)) || qNeIDofreq != qNeIDforrsp) continue;
                    asnBfd.iSessionType = bfdDetailInfoofreq.iSessionType;
                }
                rsp.lstBfdDetailInfo.add((Object)asnBfd);
                if (null == asnBfd.poOperResult || !asnBfd.poOperResult.isSuccess || CollectionUtils.isEmpty(instancesInDB)) continue;
                try {
                    dbContext.addDBChangeRecord(BfdAllSession.class).addCreate(instancesInDB);
                    DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, dbContext).merge(false, new Class[]{BfdAllSession.class});
                }
                catch (VMFException e) {
                    this.getLogger().error("add BfdAllSession in DB failed", (Throwable)e);
                }
            }
            rsp.oResult.isSuccess = totalRes;
        }
    }

    private Collection<BfdAllSession> queryBfdSessionFromDev(QAsnBfdInfo asnBfd) {
        BfdAllSession mo = new BfdAllSession();
        mo.setDevID(Integer.valueOf(asnBfd.neID));
        mo.setSessName(AsnUtil.strValue((byte[])asnBfd.strName));
        DefaultMOService pollService = new DefaultMOService();
        QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(mo.getDevID().intValue());
        queryContext.addQueryAttributes(FeatureName.BFD, (VmfMO)mo, null);
        pollService.addQueryJob(queryContext);
        try {
            pollService.poll();
            String[] fieldNames = new String[]{"localDiscr", "remoteDiscr"};
            Context ctx = new Context();
            IMOChangeRecord record = ctx.addChangeRecord(BfdAllSession.class);
            record.addModify((Object)mo, Arrays.asList(fieldNames));
            DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, ctx).merge(false, new Class[]{BfdAllSession.class});
        }
        catch (Exception e) {
            this.getLogger().error("query bfd sessionstatus[" + mo.getDevID() + "] failed", (Throwable)e);
            asnBfd.poOperResult.isSuccess = false;
            return null;
        }
        return queryContext.getQueryResult(BfdAllSession.class);
    }

    private void createBfdtoDev(ArrayList lstBfdInfoAsn, IAsnTranslationContext context) {
        if (lstBfdInfoAsn == null || lstBfdInfoAsn.size() <= 0) {
            return;
        }
        QAsnBfdInfoTranslator translator = new QAsnBfdInfoTranslator();
        try {
            translator.decode(lstBfdInfoAsn, context);
        }
        catch (VMFException e) {
            this.getLogger().error("tranlator Bfd failed", (Throwable)e);
            return;
        }
        DefaultCompositeService createService = new DefaultCompositeService(BfdCfgSession.class);
        createService.create(context.getTransactionContext());
    }

    private QAsnBfdInfo translateBfdCfgSession(BfdCfgSession bfdCfgSession, IAsnTranslationContext context) {
        try {
            QAsnBfdInfoTranslator translator = new QAsnBfdInfoTranslator();
            QAsnBfdInfo asn = new QAsnBfdInfo();
            translator.encode(bfdCfgSession, asn, context);
            return asn;
        }
        catch (VMFException e) {
            this.getLogger().error("mo(BfdCfgSession) translate to asn(QAsnBfdInfo) failed", (Throwable)e);
            return null;
        }
    }

    private IAsnTranslationContext getContext(QAsnCreateBfdReq req) {
        AsnTranslationContext asnTranslationContext = new AsnTranslationContext();
        asnTranslationContext.setOperType(EOperationType.CREATE);
        Context context = new Context();
        asnTranslationContext.setTransactionContext(context);
        if (null != req.poTaskFlag) {
            context.setTaskFlag(StringUtil.globalString((byte[])req.poTaskFlag));
        }
        return asnTranslationContext;
    }
}

