/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.bfd.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnBfdRefreshSessionReq;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnBfdRefreshSessionRsp;
import com.huawei.vmf.adapter.bfd.translation.asn.QAsnBfdInfoTranslator;
import com.huawei.vmf.adapter.bfd.util.BfdKeyParser;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.AsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.bfd.model.BfdCfgSession;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

public class BfdRefreshSessionTask
extends AbstractQTask<QAsnBfdRefreshSessionReq, QAsnBfdRefreshSessionRsp> {
    protected void executeTask(QAsnBfdRefreshSessionReq req, QAsnBfdRefreshSessionRsp rsp, Task task) {
        rsp.oResult = new QAsnErrInfoReturn();
        rsp.oResult.result = 0;
        HashSet<BfdCfgSession> results = new HashSet<BfdCfgSession>();
        for (Object obj : req.lstBfdFdn) {
            QAsnUniResID uniResID = (QAsnUniResID)obj;
            Collection<BfdCfgSession> instances = this.queryBfdSessionFromDev(uniResID, rsp.oResult);
            results.addAll(instances);
        }
        QAsnBfdInfoTranslator translator = new QAsnBfdInfoTranslator();
        AsnTranslationContext context = new AsnTranslationContext();
        Collection asns = null;
        try {
            asns = translator.encode(results, (IAsnTranslationContext)context);
        }
        catch (VMFException e) {
            this.getLogger().error("tranlator bfdcfgsession failed", (Throwable)e);
            rsp.oResult.result = 1107499878;
            return;
        }
        rsp.lstBfdInfo.addAll(asns);
    }

    private Collection<BfdCfgSession> queryBfdSessionFromDev(QAsnUniResID uniResID, QAsnErrInfoReturn oResult) {
        BfdKeyParser parser = new BfdKeyParser();
        parser.deserialize(AsnUtil.strValue((byte[])uniResID.strFDN));
        BfdCfgSession mo = new BfdCfgSession();
        mo.setDevID(Integer.valueOf(parser.getDevID()));
        mo.setSessName(parser.getBfdName());
        DefaultMOService pollService = new DefaultMOService();
        QuerySchemaTranslatorContext queryContext = new QuerySchemaTranslatorContext(mo.getDevID().intValue());
        oResult.result = 0;
        queryContext.addQueryAttributes(FeatureName.BFD, (VmfMO)mo, null);
        pollService.addQueryJob(queryContext);
        try {
            pollService.poll();
            String[] fieldNames = new String[]{"adminDown", "sessState"};
            Context ctx = new Context();
            IMOChangeRecord record = ctx.addChangeRecord(BfdCfgSession.class);
            record.addModify((Object)mo, Arrays.asList(fieldNames));
            DaoFactory.getInstance().getDefaultDao(DaoFactory.VMF_DB, ctx).merge(false, new Class[]{BfdCfgSession.class});
        }
        catch (Exception e) {
            this.getLogger().error("query bfd sessionstatus[" + mo.getDevID() + "] failed", (Throwable)e);
            oResult.result = 1107499878;
            return null;
        }
        return queryContext.getQueryResult(BfdCfgSession.class);
    }
}

