/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.bfd.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnAssignBFDLocalIDReq;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnAssignBFDLocalIDRsp;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnBFDAssignedPair;
import com.huawei.network.qasn.m_q_ip_bfd_vrrp_op.QAsnBFDAssignedPairList;
import com.huawei.network.qasn.m_q_ip_common_model.QAsnAssignNeIDNumPair;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.fservice.bfd.model.BfdCfgSession;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.util.CollectionUtils;

public class AssignBFDLocalIDTask
extends AbstractQTask<QAsnAssignBFDLocalIDReq, QAsnAssignBFDLocalIDRsp> {
    private static final int MAX_LOCALID = 16384;

    protected void executeTask(QAsnAssignBFDLocalIDReq req, QAsnAssignBFDLocalIDRsp rsp, Task task) {
        if (!CollectionUtils.isEmpty((Collection)req.lstAssignBFDIDNumPair)) {
            QAsnBFDAssignedPairList lstReturn = new QAsnBFDAssignedPairList();
            boolean isSuccAssign = true;
            int j = req.lstAssignBFDIDNumPair.size();
            for (int i = 0; i < j; ++i) {
                QAsnAssignNeIDNumPair asiReq = (QAsnAssignNeIDNumPair)req.lstAssignBFDIDNumPair.get(i);
                QAsnBFDAssignedPair asiRet = this.asignBFDID(asiReq);
                if (null == asiRet) {
                    isSuccAssign = false;
                    continue;
                }
                asiRet.result = 0;
                lstReturn.add((Object)asiRet);
            }
            rsp.lstAssignedBFDID = lstReturn;
            rsp.result = isSuccAssign ? 0 : 1107499878;
        }
    }

    private QAsnBFDAssignedPair asignBFDID(QAsnAssignNeIDNumPair asiReq) {
        QAsnBFDAssignedPair asiRet = new QAsnBFDAssignedPair();
        asiRet.neID = asiReq.neID;
        Collection<BfdCfgSession> bfdCfgLst = this.queryBfdInfoByDevID(asiReq.neID);
        if (null == bfdCfgLst) {
            return null;
        }
        Integer[] allNum = new Integer[16384];
        for (BfdCfgSession cfg : bfdCfgLst) {
            if (null == cfg.getLocalDiscr()) continue;
            allNum[cfg.getLocalDiscr().intValue() - 1] = cfg.getLocalDiscr().intValue();
        }
        int j = 0;
        for (int i = 0; i < 16384 && j < asiReq.iAssignNum.intValue(); ++i) {
            if (null != allNum[i]) continue;
            ++j;
            asiRet.lstBFDID.add((Object)(i + 1));
        }
        return asiRet;
    }

    private Collection<BfdCfgSession> queryBfdInfoByDevID(int iDevId) {
        try {
            ArrayList<Integer> lstDevID = new ArrayList<Integer>();
            lstDevID.add(iDevId);
            IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
            Collection bfdInfo = dao.queryByNeID(BfdCfgSession.class, lstDevID, true);
            return bfdInfo;
        }
        catch (VMFException e) {
            this.getLogger().error("query BfdCfgSession by devID failed", (Throwable)e);
            return null;
        }
    }
}

