/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.bfd;

import com.huawei.commextend.taskmgr.TaskDispatcherMgr;
import com.huawei.communicate.core.info.ProcessInfo;
import com.huawei.vmf.adapter.bfd.notify.BfdEventHandler;
import com.huawei.vmf.adapter.bfd.task.BfdTask;
import com.huawei.vmf.adapter.common.exception.ServiceNotAvailableException;
import com.huawei.vmf.adapter.common.uflight.ProcessInfoHelper;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.framework.model.MOAdditionalInfoMgr;
import com.huawei.vmf.adapter.framework.notify.INotifyListener;
import com.huawei.vmf.adapter.framework.notify.MOChangePublisher;
import com.huawei.vmf.adapter.fservice.bfd.model.BfdAllSession;
import com.huawei.vmf.adapter.fservice.bfd.model.BfdCfgSession;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import com.huawei.vmf.extendpoint.framework.IRegistryTask;
import com.huawei.vmf.extendpoint.register.FrameExtendPointServiceMgr;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class Activator
implements BundleActivator,
ApplicationContextAware {
    public static final Logger LOGGER = RunLogger.getLogger(Activator.class);
    private static ApplicationContext applicationContext;

    public static <T> T getService(Class<T> serviceType) throws ServiceNotAvailableException {
        if (applicationContext == null) {
            throw new ServiceNotAvailableException(serviceType);
        }
        Object serviceInstance = applicationContext.getBean(serviceType);
        if (serviceInstance == null) {
            throw new ServiceNotAvailableException(serviceType);
        }
        return (T)serviceInstance;
    }

    public void registryNotifyListener() {
        MOChangePublisher.getInstance().registry((INotifyListener)new BfdEventHandler());
    }

    public void registryTask() {
        IRegistryTask register = (IRegistryTask)FrameExtendPointServiceMgr.getInstance().getExtendPoitService(IRegistryTask.class);
        if (register != null) {
            register.registryTask(BfdTask.class);
        } else {
            TaskDispatcherMgr taskDispatcherMgr = TaskDispatcherMgr.getInstance((ProcessInfo)ProcessInfoHelper.getRuntimeProcessInfo());
            taskDispatcherMgr.registerTask(BfdTask.class);
        }
    }

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        applicationContext = ctx;
    }

    public void start(BundleContext context) {
        MOAdditionalInfoMgr.getInstance().addFeatureTopMoClass(FeatureName.BFD, BfdCfgSession.class);
        MOAdditionalInfoMgr.getInstance().addFeatureTopMoClass(FeatureName.BFD, BfdAllSession.class);
        this.registryTask();
        this.registryNotifyListener();
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }
}

