/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.arp.translation.asn.spec;

import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnArpItem;
import com.huawei.vmf.adapter.arp.common.Utility;
import com.huawei.vmf.adapter.arp.translation.asn.QAsnArpItemTranslator;
import com.huawei.vmf.adapter.common.utilty.StringUtil;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnSpecTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.arp.model.ArpStaticTable;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.VmfMO;

public class QAsnArpItemSpecTranslator
extends AbstractAsnSpecTranslator<QAsnArpItemTranslator> {
    public void decodeKeyProperties(QAsnArpItem asn, ArpStaticTable mo, IAsnTranslationContext context) {
        if (asn.poOutIf != null) {
            InterfaceFdnParser interfaceFdnParser = new InterfaceFdnParser();
            mo.setIfName(((Interface)interfaceFdnParser.getIndexMo(asn.poOutIf)).getIfName());
        }
    }

    public void decodeMacAddr(QAsnArpItem asn, ArpStaticTable mo, IAsnTranslationContext context) {
        String mac6 = StringUtil.globalString((byte[])asn.macAddr);
        if (null != mac6 && !"--".equals(mac6)) {
            if (mac6.split("-").length == 3) {
                mo.setMacAddr(mac6);
            } else {
                mo.setMacAddr(Utility.INSTANCE.formate6MacTo3Mac(mac6));
            }
        }
    }

    public void encodeKeyProperties(ArpStaticTable mo, QAsnArpItem asn, IAsnTranslationContext context) {
        if (mo.getIfName() != null && !"--".equals(mo.getIfName())) {
            InterfaceFdnParser interfaceFdnParser = new InterfaceFdnParser();
            Interface ifObject = new Interface();
            ifObject.setDevID(mo.getDevID());
            ifObject.setVrID(mo.getVrID());
            ifObject.setIfName(mo.getIfName());
            asn.poOutIf = interfaceFdnParser.getUniResID((VmfMO)ifObject);
        }
    }

    public void encodeMacAddr(ArpStaticTable mo, QAsnArpItem asn, IAsnTranslationContext context) {
        asn.macAddr = mo.getMacAddr().getBytes();
        if (!"--".equals(mo.getMacAddr())) {
            asn.macAddr = Utility.INSTANCE.format3MacTo6Mac(mo.getMacAddr()).getBytes();
        }
    }
}

