/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.arp.translation.asn;

import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnArpItem;
import com.huawei.vmf.adapter.arp.translation.asn.spec.QAsnArpItemSpecTranslator;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.translation.asn.AbstractAsnTranslator;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.arp.model.ArpStaticTable;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;

public class QAsnArpItemTranslator
extends AbstractAsnTranslator<QAsnArpItem, ArpStaticTable> {
    public static final Object[][] z_qasnArpItemMasks = new Object[0][];
    public static final Object[][] z_arpStaticTableMasks = new Object[0][];
    private QAsnArpItemSpecTranslator qasnArpItemSpecTranslator = new QAsnArpItemSpecTranslator();

    public void decode(QAsnArpItem asn, ArpStaticTable mo, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        L3vpnInstance vpninstance = (L3vpnInstance)context.getProperty(L3vpnInstance.class.getName());
        mo.setDeployStatus(vpninstance.getDeployStatus());
        mo.setDevID(vpninstance.getDevID());
        mo.setVrfName(vpninstance.getVrfName());
        mo.setVrID(vpninstance.getVrID());
        this.qasnArpItemSpecTranslator.decodeKeyProperties(asn, mo, context);
        this.decodeArpStaticTable(asn, mo, context);
        if (this.isDelete(0, asn.poOperMask, context)) {
            return;
        }
    }

    public void decodeArpStaticTable(QAsnArpItem asn, ArpStaticTable mo, IAsnTranslationContext context) throws VMFException {
        mo.setIpAddr(this.strValue(asn.ipAddr));
        this.qasnArpItemSpecTranslator.decodeMacAddr(asn, mo, context);
        context.addProperty(ArpStaticTable.class.getName(), (Object)mo);
        EOperationType operType = this.setAddOrDeleted((VmfMO)mo, 0, 0, asn.poOperMask, context);
        if (operType.equals((Object)EOperationType.DELETE)) {
            return;
        }
        if (asn.poVlan == null || -1 == asn.poVlan) {
            mo.setPeVid(null);
        } else {
            mo.setPeVid(Integer.valueOf(asn.poVlan));
        }
        this.setChanged((VmfMO)mo, z_arpStaticTableMasks, asn.poOperMask, context);
    }

    public void encode(ArpStaticTable mo, QAsnArpItem asn, IAsnTranslationContext context) throws VMFException {
        if (asn == null || mo == null) {
            return;
        }
        this.qasnArpItemSpecTranslator.encodeKeyProperties(mo, asn, context);
        this.encodeArpStaticTable(mo, asn, context);
        this.qasnArpItemSpecTranslator.encodeMacAddr(mo, asn, context);
    }

    public void encodeArpStaticTable(ArpStaticTable mo, QAsnArpItem asn, IAsnTranslationContext context) throws VMFException {
        int mask = 0;
        asn.ipAddr = this.getBytes(mo.getIpAddr());
        asn.macAddr = this.getBytes(mo.getMacAddr());
        asn.poVlan = this.intValue(mo.getPeVid());
        asn.poOperMask = this.getOperMask(asn.poOperMask, mask |= this.setChangeMask((VmfMO)mo, context, z_arpStaticTableMasks));
    }

    public Class<QAsnArpItem> getAsnClass() {
        return QAsnArpItem.class;
    }

    public Class<ArpStaticTable> getMoClass() {
        return ArpStaticTable.class;
    }
}

