/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.arp.task;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.network.qasn.m_q_common.QAsnUniResID;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnArpItem;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnArpItemList;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnL3vpnArpItem;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnL3vpnArpItemList;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnGetArpTableReq;
import com.huawei.network.qasn.m_q_ip_l3vpn_op.QAsnGetArpTableRsp;
import com.huawei.vmf.adapter.arp.dao.ArpDao;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.AsnUtil;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.service.DefaultMOService;
import com.huawei.vmf.adapter.framework.task.AbstractQTask;
import com.huawei.vmf.adapter.framework.translation.schema.QuerySchemaTranslatorContext;
import com.huawei.vmf.adapter.fservice.arp.model.ArpStaticTable;
import com.huawei.vmf.adapter.fservice.arp.model.ArpTable;
import com.huawei.vmf.adapter.fservice.ifm.fdn.InterfaceFdnParser;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.l3vpn.fdn.L3vpnInstanceFdnParser;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import net.commustru.fstru.FStruct;
import org.apache.commons.lang.StringUtils;

public class GetArpTableTask
extends AbstractQTask<QAsnGetArpTableReq, QAsnGetArpTableRsp> {
    private final int DEPLOY = 1;
    private final int UNDEPLOY = 0;
    private final int STATIC = 0;
    private final int DYNAMIC = 1;
    private final int REMOTE = 3;

    protected void executeTask(QAsnGetArpTableReq req, QAsnGetArpTableRsp rsp, Task task) {
        L3vpnInstanceFdnParser fdnParser = new L3vpnInstanceFdnParser();
        InterfaceFdnParser interfaceFdnParser = new InterfaceFdnParser();
        LinkedList<L3vpnInstance> l3vpnKeys = new LinkedList<L3vpnInstance>();
        for (Object fdnAsn : req.l3vpnKeyList) {
            L3vpnInstance l3vpn = (L3vpnInstance)fdnParser.getIndexMo((QAsnUniResID)fdnAsn);
            if (!StringUtils.isNumeric((String)l3vpn.getVrfName())) continue;
            l3vpnKeys.add(l3vpn);
        }
        rsp.result.result = 0;
        try {
            ArpDao dao = (ArpDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, ArpDao.class);
            Collection dhcpRelayFilter = dao.queryByFields(L3vpnInstance.class, new String[]{"devID", "vrfName"}, l3vpnKeys, false);
            Collection<L3vpnInstance> deployL3vpn = dao.queryL3vpnInstance(dhcpRelayFilter, 1);
            Collection<L3vpnInstance> unDeployL3vpn = dao.queryL3vpnInstance(dhcpRelayFilter, 0);
            Collection<ArpStaticTable> allDBArpTables = dao.queryArpStaticTables(unDeployL3vpn);
            for (L3vpnInstance vrf : l3vpnKeys) {
                Collection<ArpStaticTable> arpTables = this.getArpTables(vrf, allDBArpTables);
                QAsnL3vpnArpItem qasnL3vpnArpItem = new QAsnL3vpnArpItem();
                AsnUtil.setDefaultAsnValue((FStruct)qasnL3vpnArpItem);
                qasnL3vpnArpItem.neID = vrf.getDevID();
                qasnL3vpnArpItem.poVrID = vrf.getVrID();
                qasnL3vpnArpItem.vrfID = AsnUtil.intValue((String)vrf.getVrfName());
                qasnL3vpnArpItem.vrfName = AsnUtil.getBytes((String)vrf.getVrfName());
                qasnL3vpnArpItem.vrfKey = fdnParser.getUniResID((VmfMO)vrf);
                for (ArpStaticTable arpTable : arpTables) {
                    QAsnArpItem qasnArpItem = new QAsnArpItem();
                    AsnUtil.setDefaultAsnValue((FStruct)qasnArpItem);
                    qasnArpItem.ipAddr = AsnUtil.getBytes((String)arpTable.getIpAddr());
                    qasnArpItem.macAddr = AsnUtil.getBytes((String)arpTable.getMacAddr());
                    qasnArpItem.type = ArpTable.STYLE_TYPE_ENUM.STATIC_ARP;
                    Interface mo = new Interface();
                    mo.setDevID(vrf.getDevID());
                    mo.setVrID(vrf.getVrID());
                    mo.setIfName(arpTable.getIfName());
                    qasnArpItem.poOutIf = interfaceFdnParser.getUniResID((VmfMO)mo);
                    qasnArpItem.poVlan = AsnUtil.intValue((Integer)arpTable.getPeVid());
                    if (null == qasnL3vpnArpItem.arpItem) {
                        qasnL3vpnArpItem.arpItem = new QAsnArpItemList();
                    }
                    qasnL3vpnArpItem.arpItem.add((Object)qasnArpItem);
                }
                if (null == rsp.arpList) {
                    rsp.arpList = new QAsnL3vpnArpItemList();
                }
                rsp.arpList.add((Object)qasnL3vpnArpItem);
            }
            Collection<ArpTable> allArpTables = this.getArpTableFromDev(deployL3vpn);
            this.addL3vpnArpItemFormDev(req, rsp, l3vpnKeys, allArpTables, fdnParser, interfaceFdnParser);
        }
        catch (VMFException e) {
            this.getLogger().error("GetArpTableTask failed", (Throwable)e);
            rsp.result.result = e.getErrorCode();
        }
    }

    private Collection<ArpStaticTable> getArpTables(L3vpnInstance vrf, Collection<ArpStaticTable> allArpTables) {
        ArrayList<ArpStaticTable> arpTables = new ArrayList<ArpStaticTable>();
        for (ArpStaticTable arpTable : allArpTables) {
            if (!vrf.getDevID().equals(arpTable.getDevID()) || !vrf.getVrfName().equals(arpTable.getVrfName())) continue;
            arpTables.add(arpTable);
        }
        return arpTables;
    }

    private Collection<ArpTable> getDevArpTables(L3vpnInstance vrf, Collection<ArpTable> allArpTables) {
        ArrayList<ArpTable> arpTables = new ArrayList<ArpTable>();
        for (ArpTable arpTable : allArpTables) {
            if (!vrf.getDevID().equals(arpTable.getDevID()) || !vrf.getVrfName().equals(arpTable.getVrfName())) continue;
            arpTables.add(arpTable);
        }
        return arpTables;
    }

    private Collection<ArpTable> getArpTableFromDev(Collection<L3vpnInstance> l3vpnKeys) throws VMFException {
        ArrayList<ArpTable> arpTables = new ArrayList<ArpTable>();
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(null);
        HashSet<Integer> devIDs = new HashSet<Integer>();
        Collection vrfs = dao.queryByKey(L3vpnInstance.class, l3vpnKeys, true);
        DefaultMOService pollService = new DefaultMOService();
        for (L3vpnInstance vrf : vrfs) {
            devIDs.add(vrf.getDevID());
            QuerySchemaTranslatorContext queryContext = pollService.getQueryContext(vrf.getDevID().intValue());
            if (queryContext == null) {
                queryContext = new QuerySchemaTranslatorContext(vrf.getDevID().intValue());
                pollService.addQueryJob(queryContext);
            }
            ArpTable arpTable = new ArpTable();
            arpTable.setDevID(vrf.getDevID());
            arpTable.setVrID(vrf.getVrID());
            arpTable.setVrfName(vrf.getVrfName());
            queryContext.addQueryAttributes(FeatureName.ARP, (VmfMO)arpTable, Arrays.asList("ipAddr", "macAddr", "styleType", "ifName", "peVid"));
        }
        pollService.poll();
        for (Integer devid : devIDs) {
            Collection a = pollService.getQueryContext(devid.intValue()).getQueryResult(ArpTable.class);
            arpTables.addAll(pollService.getQueryContext(devid.intValue()).getQueryResult(ArpTable.class));
        }
        return arpTables;
    }

    private void addL3vpnArpItemFormDev(QAsnGetArpTableReq req, QAsnGetArpTableRsp rsp, Collection<L3vpnInstance> l3vpnKeys, Collection<ArpTable> allArpTables, L3vpnInstanceFdnParser fdnParser, InterfaceFdnParser interfaceFdnParser) {
        for (L3vpnInstance vrf : l3vpnKeys) {
            Collection<ArpTable> arpTables = this.getDevArpTables(vrf, allArpTables);
            QAsnL3vpnArpItem qasnL3vpnArpItem = new QAsnL3vpnArpItem();
            AsnUtil.setDefaultAsnValue((FStruct)qasnL3vpnArpItem);
            qasnL3vpnArpItem.neID = vrf.getDevID();
            qasnL3vpnArpItem.poVrID = vrf.getVrID();
            qasnL3vpnArpItem.vrfID = AsnUtil.intValue((String)vrf.getVrfName());
            qasnL3vpnArpItem.vrfName = AsnUtil.getBytes((String)vrf.getVrfName());
            qasnL3vpnArpItem.vrfKey = fdnParser.getUniResID((VmfMO)vrf);
            for (ArpTable arpTable : arpTables) {
                QAsnArpItem qasnArpItem = new QAsnArpItem();
                AsnUtil.setDefaultAsnValue((FStruct)qasnArpItem);
                qasnArpItem.ipAddr = AsnUtil.getBytes((String)arpTable.getIpAddr());
                qasnArpItem.macAddr = AsnUtil.getBytes((String)arpTable.getMacAddr());
                qasnArpItem.type = arpTable.getStyleType();
                Interface mo = new Interface();
                mo.setDevID(vrf.getDevID());
                mo.setVrID(vrf.getVrID());
                mo.setIfName(arpTable.getIfName());
                qasnArpItem.poOutIf = interfaceFdnParser.getUniResID((VmfMO)mo);
                qasnArpItem.poVlan = AsnUtil.intValue((Integer)arpTable.getPeVid());
                if (null == qasnL3vpnArpItem.arpItem) {
                    qasnL3vpnArpItem.arpItem = new QAsnArpItemList();
                }
                if (1 != arpTable.getStyleType() && 0 != arpTable.getStyleType() && 3 != arpTable.getStyleType()) continue;
                if (3 == arpTable.getStyleType()) {
                    qasnArpItem.type = 1;
                }
                qasnL3vpnArpItem.arpItem.add((Object)qasnArpItem);
            }
            if (null == rsp.arpList) {
                rsp.arpList = new QAsnL3vpnArpItemList();
            }
            rsp.arpList.add((Object)qasnL3vpnArpItem);
        }
    }
}

