/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.arp.service;

import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnArpItem;
import com.huawei.network.qasn.m_q_ip_l3vpn_model.QAsnArpItemList;
import com.huawei.vmf.adapter.arp.common.Utility;
import com.huawei.vmf.adapter.arp.dao.ArpDao;
import com.huawei.vmf.adapter.arp.translation.asn.QAsnArpItemTranslator;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.arp.model.ArpInterface;
import com.huawei.vmf.adapter.fservice.arp.model.ArpStaticTable;
import com.huawei.vmf.adapter.fservice.arp.service.IArpService;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnIf;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ArpService
implements IArpService {
    private Logger logger = LoggerFactory.getLogger(ArpService.class);

    public void decodeStaticArp(QAsnArpItemList asnList, L3vpnInstance vpn, Object objContext) throws VMFException {
        if (asnList == null || asnList.isEmpty()) {
            return;
        }
        IAsnTranslationContext context = (IAsnTranslationContext)objContext;
        QAsnArpItemTranslator trans = new QAsnArpItemTranslator();
        if (EOperationType.MODIFY.equals((Object)context.getOperType())) {
            ArpDao dao = (ArpDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, ArpDao.class);
            Collection<ArpStaticTable> existTables = dao.queryArpStaticTables(Arrays.asList(vpn));
            HashMap<String, ArpStaticTable> existRecords = new HashMap<String, ArpStaticTable>();
            for (ArpStaticTable table : existTables) {
                existRecords.put(this.getKey(table), table);
            }
            ArrayList<ArpStaticTable> deleteList = new ArrayList<ArpStaticTable>();
            ArrayList<ArpStaticTable> addList = new ArrayList<ArpStaticTable>();
            ArrayList<ArpStaticTable> realDeleteList = new ArrayList<ArpStaticTable>();
            ArrayList<ArpStaticTable> realAddList = new ArrayList<ArpStaticTable>();
            ArrayList<ArpStaticTable> realModifyList = new ArrayList<ArpStaticTable>();
            HashMap<String, ArpStaticTable> deleteRecords = new HashMap<String, ArpStaticTable>();
            HashMap<String, ArpStaticTable> addRecords = new HashMap<String, ArpStaticTable>();
            IMOChangeRecord rcd = context.getTransactionContext().addChangeRecord(ArpStaticTable.class);
            int size = asnList.size();
            for (int i = 0; i < size; ++i) {
                QAsnArpItem asn = (QAsnArpItem)asnList.get(i);
                ArpStaticTable arpStatic = (ArpStaticTable)trans.decode((FStruct)asn, context);
                if (asn.poOperMask == null || asn.poOperMask == 0) {
                    vpn.addKeyRefMo((VmfMO)arpStatic);
                    continue;
                }
                if (asn.poOperMask == 2) {
                    deleteRecords.put(this.getKey(arpStatic), arpStatic);
                    deleteList.add(arpStatic);
                    continue;
                }
                addRecords.put(this.getKey(arpStatic), arpStatic);
                addList.add(arpStatic);
            }
            for (ArpStaticTable arpStatic : deleteList) {
                if (addRecords.get(this.getKey(arpStatic)) != null) continue;
                realDeleteList.add(arpStatic);
            }
            for (ArpStaticTable arpStatic : addList) {
                if (deleteRecords.get(this.getKey(arpStatic)) == null) {
                    realAddList.add(arpStatic);
                    continue;
                }
                realModifyList.add(arpStatic);
            }
            context.getTransactionContext().addChangeRecord(L3vpnInstance.class).addModify((Object)vpn, new PropertyChangeItem("vrfName", (Object)vpn.getVrfName(), (Object)vpn.getVrfName()));
            for (ArpStaticTable arpStatic : realDeleteList) {
                rcd.addDelete((Object)arpStatic);
                vpn.addKeyRefMo((VmfMO)arpStatic);
            }
            for (ArpStaticTable arpStatic : realAddList) {
                rcd.addCreate((Object)arpStatic);
                vpn.addKeyRefMo((VmfMO)arpStatic);
            }
            for (ArpStaticTable arpStatic : realModifyList) {
                ArpStaticTable existRecord = (ArpStaticTable)existRecords.get(this.getKey(arpStatic));
                if (existRecord == null) continue;
                if (arpStatic.getIfName() == null && existRecord.getIfName() != null || arpStatic.getIfName() != null && existRecord.getIfName() == null) {
                    rcd.addModify((Object)arpStatic, new PropertyChangeItem("ifName", (Object)arpStatic.getIfName(), (Object)existRecord.getIfName()));
                }
                if (arpStatic.getIfName() != null && existRecord.getIfName() != null && !arpStatic.getIfName().equals(existRecord.getIfName())) {
                    rcd.addModify((Object)arpStatic, new PropertyChangeItem("ifName", (Object)arpStatic.getIfName(), (Object)existRecord.getIfName()));
                }
                if (arpStatic.getPeVid() == null && existRecord.getPeVid() != null || arpStatic.getPeVid() != null && existRecord.getPeVid() == null) {
                    rcd.addModify((Object)arpStatic, new PropertyChangeItem("peVid", (Object)arpStatic.getPeVid(), (Object)existRecord.getPeVid()));
                }
                if (arpStatic.getPeVid() != null && existRecord.getPeVid() != null && arpStatic.getPeVid().intValue() != existRecord.getPeVid().intValue()) {
                    rcd.addModify((Object)arpStatic, new PropertyChangeItem("peVid", (Object)arpStatic.getPeVid(), (Object)existRecord.getPeVid()));
                }
                vpn.addKeyRefMo((VmfMO)arpStatic);
            }
        } else {
            int length = asnList.size();
            for (int i = 0; i < length; ++i) {
                QAsnArpItem asn = (QAsnArpItem)asnList.get(i);
                ArpStaticTable arpStatic = (ArpStaticTable)trans.decode((FStruct)asn, context);
                vpn.addKeyRefMo((VmfMO)arpStatic);
            }
        }
    }

    private String getKey(ArpStaticTable staticTable) {
        String key = staticTable.getIpAddr();
        if (staticTable.getMacAddr() != null) {
            key = key + staticTable.getMacAddr();
        }
        return key;
    }

    public Collection<L3vpnInstance> processStaticArp(Collection<L3vpnInstance> l3vpns, Object objContext, EOperationType operType) throws VMFException {
        Context context = (Context)objContext;
        ArpDao dao = (ArpDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, ArpDao.class);
        Collection<ArpStaticTable> relayVpns = dao.queryArpStaticTables(l3vpns);
        if (CollectionUtils.isEmpty(relayVpns)) {
            return l3vpns;
        }
        for (L3vpnInstance l3vpn : l3vpns) {
            for (ArpStaticTable staticTable : relayVpns) {
                if (l3vpn.getDevID().intValue() != staticTable.getDevID().intValue() || !l3vpn.getVrfName().equals(staticTable.getVrfName())) continue;
                Utility.INSTANCE.addMo2Context(context, operType, ArpStaticTable.class, staticTable, (VmfMO)l3vpn);
            }
        }
        return l3vpns;
    }

    public QAsnArpItemList encodeStaticArp(Collection<ArpStaticTable> arpStaticTables, Object context) throws VMFException {
        QAsnArpItemList arpList = new QAsnArpItemList();
        if (CollectionUtils.isEmpty(arpStaticTables)) {
            return arpList;
        }
        QAsnArpItemTranslator trans = new QAsnArpItemTranslator();
        for (ArpStaticTable staticTable : arpStaticTables) {
            arpList.add((Object)trans.encode(staticTable, (IAsnTranslationContext)context));
        }
        return arpList;
    }

    public Collection<ArpStaticTable> processStaticArpFromDb(Collection<L3vpnInstance> l3vpns) throws VMFException {
        Collection<ArpStaticTable> arpStaticTables = null;
        try {
            ArpDao dao = (ArpDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, ArpDao.class);
            ArrayList<Interface> interfaceKeys = new ArrayList<Interface>();
            for (L3vpnInstance l3vpn : l3vpns) {
                if (l3vpn.getL3vpnIfs() == null) continue;
                for (L3vpnIf ifMo : l3vpn.getL3vpnIfs()) {
                    Interface mo = new Interface();
                    mo.setDevID(ifMo.getDevID());
                    mo.setVrID(ifMo.getVrID());
                    mo.setIfName(ifMo.getIfName());
                    interfaceKeys.add(mo);
                }
            }
            Collection<Object> arpInterfaces = new ArrayList();
            if (!CollectionUtils.isEmpty(interfaceKeys)) {
                arpInterfaces = dao.queryArpAgents(interfaceKeys);
            }
            for (L3vpnInstance l3vpn : l3vpns) {
                if (CollectionUtils.isEmpty((Collection)l3vpn.getL3vpnIfs())) continue;
                for (L3vpnIf l3vpnIf : l3vpn.getL3vpnIfs()) {
                    for (ArpInterface arpInterface : arpInterfaces) {
                        if (!arpInterface.getIfName().equals(l3vpnIf.getIfName()) || arpInterface.getDevID().intValue() != l3vpnIf.getDevID().intValue() || arpInterface.getVrID().intValue() != l3vpnIf.getVrID().intValue()) continue;
                        l3vpn.addKeyRefMo((VmfMO)arpInterface);
                    }
                }
            }
            arpStaticTables = dao.queryArpStaticTables(l3vpns);
        }
        catch (VMFException e) {
            this.logger.error("DhcpService.processSAP error", (Throwable)e);
        }
        return arpStaticTables;
    }

    public void processArpToL3vpn(Map<L3vpnInstance, Collection<Interface>> vrf2Sap, Object objContext) {
        IAsnTranslationContext context = (IAsnTranslationContext)objContext;
        try {
            for (Map.Entry<L3vpnInstance, Collection<Interface>> entey : vrf2Sap.entrySet()) {
                Collection<Interface> interfaceKeys = entey.getValue();
                ArpDao dao = (ArpDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, null, ArpDao.class);
                Collection<ArpInterface> arpInterfaceResults = dao.queryArpAgents(interfaceKeys);
                if (CollectionUtils.isEmpty(arpInterfaceResults)) {
                    return;
                }
                Map<Interface, ArpInterface> ifCfgMap = this.getDhcpRelayIfCfgMap(interfaceKeys, arpInterfaceResults);
                for (Interface interfaceKey : ifCfgMap.keySet()) {
                    ArpInterface dhcpRelayResult = ifCfgMap.get(interfaceKey);
                    if (dhcpRelayResult == null) continue;
                    Utility.INSTANCE.addMo2Context(context.getTransactionContext(), context.getOperType(), ArpInterface.class, dhcpRelayResult, (VmfMO)entey.getKey());
                }
                IMOChangeRecord arpStatic = context.getTransactionContext().addChangeRecord(ArpInterface.class);
                IMOChangeRecord arpStaticDb = context.getTransactionContext().addDBChangeRecord(ArpInterface.class);
                if (arpStatic.hasCreate()) {
                    for (ArpInterface arpInterface : arpStatic.getCreates()) {
                        arpStatic.addModify((Object)arpInterface, new PropertyChangeItem("interProxyEnable", (Object)arpInterface.getInterProxyEnable(), (Object)0));
                    }
                    arpStatic.getCreates().clear();
                }
                if (!arpStatic.hasDelete()) continue;
                for (ArpInterface arpInterface : arpStatic.getDeletes()) {
                    arpStatic.addModify((Object)arpInterface, new PropertyChangeItem("interProxyEnable", (Object)0, (Object)arpInterface.getInterProxyEnable()));
                }
                arpStatic.getDeletes().clear();
            }
        }
        catch (VMFException e) {
            this.logger.error("ArpExtPoint.processSAP error", (Throwable)e);
        }
    }

    private Map<Interface, ArpInterface> getDhcpRelayIfCfgMap(Collection<Interface> interfaceKeys, Collection<ArpInterface> dhcpRelayResults) {
        HashMap<Interface, ArpInterface> dhcpRelayIfCgfMap = new HashMap<Interface, ArpInterface>();
        block0: for (Interface interfaceKey : interfaceKeys) {
            for (ArpInterface dhcpIfCfg : dhcpRelayResults) {
                if (interfaceKey.getDevID().intValue() != dhcpIfCfg.getDevID().intValue() || interfaceKey.getVrID().intValue() != dhcpIfCfg.getVrID().intValue() || !interfaceKey.getIfName().equals(dhcpIfCfg.getIfName())) continue;
                dhcpRelayIfCgfMap.put(interfaceKey, dhcpIfCfg);
                continue block0;
            }
        }
        return dhcpRelayIfCgfMap;
    }
}

