/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.arp.service;

import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnArp;
import com.huawei.network.qasn.m_q_ip_ctp_model.QAsnSAP;
import com.huawei.vmf.adapter.arp.common.Utility;
import com.huawei.vmf.adapter.arp.translation.asn.QAsnArpTranslator;
import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.extendpoint.ifm.util.IIfmAssociateFunctionExtPoint;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.translation.asn.IAsnTranslationContext;
import com.huawei.vmf.adapter.fservice.arp.model.ArpInterface;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ArpExtPoint
implements IIfmAssociateFunctionExtPoint {
    private Logger logger = LoggerFactory.getLogger(ArpExtPoint.class);

    private Map<Interface, ArpInterface> getDhcpRelayIfCfgMap(Collection<Interface> interfaceKeys, Collection<ArpInterface> dhcpRelayResults) {
        HashMap<Interface, ArpInterface> dhcpRelayIfCgfMap = new HashMap<Interface, ArpInterface>();
        block0: for (Interface interfaceKey : interfaceKeys) {
            for (ArpInterface dhcpIfCfg : dhcpRelayResults) {
                if (interfaceKey.getDevID().intValue() != dhcpIfCfg.getDevID().intValue() || interfaceKey.getVrID().intValue() != dhcpIfCfg.getVrID().intValue() || !interfaceKey.getIfName().equals(dhcpIfCfg.getIfName())) continue;
                dhcpRelayIfCgfMap.put(interfaceKey, dhcpIfCfg);
                continue block0;
            }
        }
        return dhcpRelayIfCgfMap;
    }

    public Collection<Interface> processSAP(Collection<Interface> interfaceKeys, IAsnTranslationContext context) {
        return interfaceKeys;
    }

    public void decode(FStruct req, Interface mo, IAsnTranslationContext context) {
        try {
            ArpInterface delayMo;
            context.addProperty(Interface.class.getName(), (Object)mo);
            QAsnSAP asn = (QAsnSAP)req;
            IMOChangeRecord arpStatic = context.getTransactionContext().addChangeRecord(ArpInterface.class);
            if (EOperationType.MODIFY.equals((Object)context.getOperType())) {
                if (asn.poOperMask == null || asn.poOperMask == 0 || asn.poArp == null) {
                    return;
                }
                delayMo = (ArpInterface)new QAsnArpTranslator().decode((FStruct)asn.poArp, context);
                if (asn.poOperMask == 1) {
                    arpStatic.addCreate((Object)delayMo);
                } else {
                    arpStatic.addDelete((Object)delayMo);
                }
            } else {
                delayMo = (ArpInterface)new QAsnArpTranslator().decode((FStruct)asn.poArp, context);
            }
            if (arpStatic.hasCreate()) {
                for (ArpInterface arpInterface : arpStatic.getCreates()) {
                    Utility.INSTANCE.modifyArpAgentMo(arpInterface, arpInterface.getInterProxyEnable(), false);
                    mo.addKeyRefMo((VmfMO)arpInterface);
                }
                arpStatic.getCreates().clear();
            }
            if (arpStatic.hasDelete()) {
                for (ArpInterface arpInterface : arpStatic.getDeletes()) {
                    Utility.INSTANCE.modifyArpAgentMo(arpInterface, false, arpInterface.getInterProxyEnable());
                    mo.addKeyRefMo((VmfMO)arpInterface);
                }
                arpStatic.getDeletes().clear();
            }
        }
        catch (VMFException e) {
            this.logger.error("ArpExtPoint.decode error", (Throwable)e);
        }
    }

    public void encode(Interface mo, FStruct rsp, IAsnTranslationContext context) {
        try {
            if (mo == null || rsp == null) {
                return;
            }
            List dhcpRelayIfCfgs = mo.getKeyRefMos(ArpInterface.class);
            if (CollectionUtils.isEmpty((Collection)dhcpRelayIfCfgs)) {
                return;
            }
            ArpInterface dhcpRelayResult = (ArpInterface)dhcpRelayIfCfgs.iterator().next();
            if (dhcpRelayResult != null) {
                QAsnSAP qasn = (QAsnSAP)rsp;
                qasn.poArp = (QAsnArp)new QAsnArpTranslator().encode(dhcpRelayResult, context);
            }
        }
        catch (VMFException e) {
            this.logger.error("ArpExtPoint.encode error", (Throwable)e);
        }
    }
}

