/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.arp.dao;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.DefaultDao;
import com.huawei.vmf.adapter.framework.dao.RelationMetaMgr;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.arp.model.ArpInterface;
import com.huawei.vmf.adapter.fservice.arp.model.ArpStaticTable;
import com.huawei.vmf.adapter.fservice.ifm.model.Interface;
import com.huawei.vmf.adapter.fservice.l3vpn.model.L3vpnInstance;
import java.util.ArrayList;
import java.util.Collection;
import org.hibernate.SessionFactory;

public class ArpDao
extends DefaultDao {
    protected ArpDao(SessionFactory sf, RelationMetaMgr relationMgr) {
        super(sf, relationMgr);
    }

    public static ArpDao newInstance() {
        return (ArpDao)DaoFactory.getInstance().getExtendDao(DaoFactory.VMF_DB, new Context(), ArpDao.class);
    }

    public Collection<ArpStaticTable> queryArpStaticTables(Collection<L3vpnInstance> l3vpns) throws VMFException {
        if (null == l3vpns || l3vpns.isEmpty()) {
            return new ArrayList<ArpStaticTable>();
        }
        ArrayList<ArpStaticTable> dhcpRelayFilter = new ArrayList<ArpStaticTable>();
        for (L3vpnInstance l3vpn : l3vpns) {
            ArpStaticTable dhcpRelay = new ArpStaticTable();
            dhcpRelay.setDevID(l3vpn.getDevID());
            dhcpRelay.setVrfName(l3vpn.getVrfName());
            dhcpRelayFilter.add(dhcpRelay);
        }
        Collection dhcpRelayResult = this.queryByFields(ArpStaticTable.class, new String[]{"devID", "vrfName"}, dhcpRelayFilter, false);
        return dhcpRelayResult;
    }

    public Collection<ArpInterface> queryArpAgents(Collection<Interface> interfaceKeys) throws VMFException {
        if (null == interfaceKeys || interfaceKeys.isEmpty()) {
            return new ArrayList<ArpInterface>();
        }
        ArrayList<ArpInterface> arpFilter = new ArrayList<ArpInterface>();
        for (Interface interfaceKey : interfaceKeys) {
            ArpInterface dhcpRelay = new ArpInterface();
            dhcpRelay.setDevID(interfaceKey.getDevID());
            dhcpRelay.setIfName(interfaceKey.getIfName());
            arpFilter.add(dhcpRelay);
        }
        Collection arpResult = this.queryByFields(ArpInterface.class, new String[]{"devID", "ifName"}, arpFilter, false);
        return arpResult;
    }

    public Collection<L3vpnInstance> queryL3vpnInstance(Collection<L3vpnInstance> l3vpns, int deployType) throws VMFException {
        if (null == l3vpns || l3vpns.isEmpty()) {
            return new ArrayList<L3vpnInstance>();
        }
        ArrayList<L3vpnInstance> deployL3vpn = new ArrayList<L3vpnInstance>();
        ArrayList<L3vpnInstance> unDeployL3vpn = new ArrayList<L3vpnInstance>();
        for (L3vpnInstance l3vpn : l3vpns) {
            if (0 == l3vpn.getDeployStatus()) {
                unDeployL3vpn.add(l3vpn);
                continue;
            }
            if (1 != l3vpn.getDeployStatus()) continue;
            deployL3vpn.add(l3vpn);
        }
        if (0 == deployType) {
            return unDeployL3vpn;
        }
        return deployL3vpn;
    }
}

