/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.vmf.adapter.arp.common;

import com.huawei.vmf.adapter.common.exception.VMFException;
import com.huawei.vmf.adapter.common.utilty.RunLogger;
import com.huawei.vmf.adapter.framework.dao.DaoFactory;
import com.huawei.vmf.adapter.framework.dao.IDao;
import com.huawei.vmf.adapter.framework.device.DeviceAccessorFactory;
import com.huawei.vmf.adapter.framework.notify.IMOChangeRecord;
import com.huawei.vmf.adapter.framework.notify.PropertyChangeItem;
import com.huawei.vmf.adapter.framework.transaction.Context;
import com.huawei.vmf.adapter.fservice.arp.model.ArpInterface;
import com.huawei.vmf.adapter.fservice.model.DeployableMO;
import com.huawei.vmf.adapter.fservice.model.EOperationType;
import com.huawei.vmf.adapter.fservice.model.VmfMO;
import com.huawei.vmf.adapter.fservice.service.FeatureName;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;

public class Utility {
    public static final Utility INSTANCE = new Utility();
    private final Logger logger = RunLogger.getLogger(this.getClass());

    private Utility() {
    }

    public <T extends VmfMO> void addMo2Context(Context cxt, EOperationType operType, Class<T> clazz, T mo, VmfMO mainMo) {
        switch (operType) {
            case CREATE: 
            case PREDEPLOY: {
                cxt.addChangeRecord(clazz).addCreate(mo);
                break;
            }
            case DEPLOY: {
                if (mo instanceof DeployableMO) {
                    if (Integer.valueOf(1).equals(((DeployableMO)mo).getDeployStatus())) break;
                    ((DeployableMO)mo).setDeployStatus(Integer.valueOf(1));
                    cxt.addDBChangeRecord(clazz).addModify(mo, new PropertyChangeItem("deployStatus", (Object)1, (Object)0));
                }
                cxt.addChangeRecord(clazz).addCreate(mo);
                break;
            }
            case UNDEPLOY: {
                if (mo instanceof DeployableMO) {
                    if (!((DeployableMO)mo).getDeployStatus().equals(1)) break;
                    ((DeployableMO)mo).setDeployStatus(Integer.valueOf(0));
                    cxt.addDBChangeRecord(clazz).addModify(mo, new PropertyChangeItem("deployStatus", (Object)0, (Object)1));
                }
                cxt.addChangeRecord(clazz).addDelete(mo);
                break;
            }
            case DELETE: {
                cxt.addChangeRecord(clazz).addDelete(mo);
                break;
            }
            case GET: {
                break;
            }
            default: {
                this.logger.error("unsupported oper-type:" + operType.name());
                return;
            }
        }
        this.addKeyRef2MainMo(mainMo, mo, operType, cxt);
    }

    private void addKeyRef2MainMo(VmfMO mainMo, VmfMO mo, EOperationType operType, Context cxt) {
        if (mainMo == null || cxt == null) {
            return;
        }
        mainMo.addKeyRefMo(mo);
        IMOChangeRecord rcd = cxt.addChangeRecord(mainMo.getClass());
        switch (operType) {
            case DEPLOY: {
                if (rcd.isCreated((Object)mainMo) || rcd.isModified((Object)mainMo, mo.getClass().getName())) break;
                rcd.addModify((Object)mainMo, Arrays.asList(mo.getClass().getName()));
                break;
            }
            case UNDEPLOY: {
                if (rcd.isDeleted((Object)mainMo) || rcd.isModified((Object)mainMo, mo.getClass().getName())) break;
                rcd.addModify((Object)mainMo, Arrays.asList(mo.getClass().getName()));
                break;
            }
            case DELETE: {
                break;
            }
        }
    }

    public String formate6MacTo3Mac(String str6Mac) {
        String[] strArry = str6Mac.split("-");
        StringBuffer strbuffer = new StringBuffer();
        int n = strArry.length;
        for (int m = 0; m < n; ++m) {
            if (1 == strArry[m].length()) {
                strbuffer.append('0');
            }
            strbuffer.append(strArry[m]);
            if (m == n - 1 || m % 2 == 0) continue;
            strbuffer.append('-');
        }
        return strbuffer.toString();
    }

    public String format3MacTo6Mac(String str3Mac) {
        String[] strArry = str3Mac.split("-");
        StringBuffer strbuffer = new StringBuffer();
        int k = strArry.length;
        for (int j = 0; j < k; ++j) {
            strbuffer.append(strArry[j].substring(0, 2).toUpperCase());
            strbuffer.append('-');
            strbuffer.append(strArry[j].substring(2, 4).toUpperCase());
            if (j == k - 1) continue;
            strbuffer.append('-');
        }
        return strbuffer.toString();
    }

    public void modifyArpAgentMo(ArpInterface mo, boolean newValue, boolean oldValue) throws VMFException {
        Context cxt = new Context(false);
        IMOChangeRecord rcd = cxt.addChangeRecord(ArpInterface.class);
        IMOChangeRecord dbRcd = cxt.addDBChangeRecord(ArpInterface.class);
        rcd.addModify((Object)mo, new PropertyChangeItem("interProxyEnable", (Object)newValue, (Object)oldValue));
        IDao dao = DaoFactory.getInstance().getDefaultVmfDao(cxt);
        if (!dao.exists(ArpInterface.class, Arrays.asList(mo)).isEmpty()) {
            dbRcd.addModify((Object)mo, new PropertyChangeItem("interProxyEnable", (Object)newValue, (Object)oldValue));
        } else {
            dbRcd.addCreate((Object)mo);
        }
        HashMap<FeatureName, List<Class>> features = new HashMap<FeatureName, List<Class>>();
        features.put(mo.getFeatureName(), Arrays.asList(ArpInterface.class));
        DeviceAccessorFactory.getDefaultNetconfDeployer((int)mo.getDevID(), (Context)cxt).merge(features);
        dao.merge(ArpInterface.class, true);
    }
}

