/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.util;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class UMThreadPool
implements Executor {
    private static final int CORE_THREAD_COUNT = 8;
    private static final int MAX_THREAD_COUNT = 32;
    private static final long IDLE_ALIVE_TIME = 300L;
    private static final UMThreadPool INSTANCE = new UMThreadPool();
    private ExecutorService executor;

    private UMThreadPool() {
        LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
        this.executor = new ThreadPoolExecutor(8, 32, 300L, TimeUnit.SECONDS, workQueue);
        Runtime.getRuntime().addShutdownHook(new Thread("Thread pool shut down hook"){

            @Override
            public void run() {
                UMThreadPool.this.executor.shutdown();
            }
        });
    }

    public static UMThreadPool getInstance() {
        return INSTANCE;
    }

    @Override
    public void execute(Runnable event) {
        if (this.executor.isShutdown()) {
            event.run();
        } else {
            this.executor.execute(event);
        }
    }
}

