/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.util;

import com.huawei.u2000.framework.adaptive.AdaptiveUtil;
import com.huawei.u2000.util.UMLogger;
import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import java.util.ArrayList;
import java.util.List;

public class UMSubSystemAdapter {
    private static final String PATH = "conf/ext_u2000_unitedmgr/domainsubsystem";
    private static final String AREA_DESC = "MapArea";
    private static final String IP_DESC = "IP";
    private static final String ACCESS_DESC = "Access";
    private static final String TRANSPORT_DESC = "Transport";
    private static final String VMF_DESC = "VMF";
    private List<String> IPSubSystemLst = new ArrayList<String>();
    private List<String> AccessSubSystemLst = new ArrayList<String>();
    private List<String> TransSubSystemLst = new ArrayList<String>();
    private List<String> VMFSubSystemLst = new ArrayList<String>();
    private static UMSubSystemAdapter instance = null;

    public static UMSubSystemAdapter getInstance() {
        if (null == instance) {
            instance = new UMSubSystemAdapter();
        }
        return instance;
    }

    private UMSubSystemAdapter() {
        this.parseConfigurationFiles();
    }

    private void parseConfigurationFiles() {
        try {
            CommStyleInfo procIDStyleInfo = CommStyleManager.getInstance().getCommonStyleFromDefaultAndProductStyle(PATH);
            if (null == procIDStyleInfo) {
                UMLogger.debug("Class:UMSubSystemAdapter, Parse the devices description file fail!");
                return;
            }
            AreaDescContainer container = procIDStyleInfo.getAreaDescContainer(AREA_DESC);
            if (null == container) {
                UMLogger.debug("Class:UMSubSystemAdapter, AreaDescContainer is null!");
                return;
            }
            this.IPSubSystemLst = this.readDescPara(container, IP_DESC);
            this.AccessSubSystemLst = this.readDescPara(container, ACCESS_DESC);
            this.TransSubSystemLst = this.readDescPara(container, TRANSPORT_DESC);
            this.VMFSubSystemLst = this.readDescPara(container, VMF_DESC);
        }
        catch (Exception ex) {
            UMLogger.debug(UMSubSystemAdapter.class.toString() + " parseConfigurationFiles() error!");
            UMLogger.exception(ex);
        }
    }

    private List<String> readDescPara(AreaDescContainer container, String strDesc) {
        DescContainer dcObject = null;
        PARA para = null;
        ArrayList<String> proLst = new ArrayList<String>();
        try {
            dcObject = container.getDescContainer(strDesc);
            if (null != dcObject) {
                int paraLenth = dcObject.getParasItemCount();
                for (int j = 0; j < paraLenth; ++j) {
                    para = dcObject.getParasItem(j);
                    if (null == para) continue;
                    proLst.add(para.getValue());
                }
            } else {
                UMLogger.debug(strDesc + " is null!");
            }
        }
        catch (Exception ex) {
            UMLogger.debug("Class: UMSubSystemAdapter, function is readDescPara, strDesc is: " + strDesc);
            UMLogger.exception(ex);
        }
        return proLst;
    }

    public boolean isIPSubSystemDeployed() {
        return this.isSubSystemDeployed(this.IPSubSystemLst, "isIPSubSystemRun()");
    }

    public boolean isAccessSubSystemDeployed() {
        return this.isSubSystemDeployed(this.AccessSubSystemLst, "isAccessSubSystemRun()");
    }

    public boolean isTransportSubSystemDeployed() {
        return this.isSubSystemDeployed(this.TransSubSystemLst, "isTransportSubSystemRun()");
    }

    public boolean isVMFSubSystemDeployed() {
        return this.isSubSystemDeployed(this.VMFSubSystemLst, "isVMFSubSystemDeployed()");
    }

    private boolean isSubSystemDeployed(List<String> subSystemLst, String strFunName) {
        UMLogger.debug("Class:UMSubSystemAdapter, subSystemLst is :" + subSystemLst);
        if (null == subSystemLst || subSystemLst.isEmpty()) {
            UMLogger.debug(this.getClass(), "isSubSystemRun", subSystemLst + " Current subsystem: " + strFunName);
            return true;
        }
        int len = subSystemLst.size();
        for (int i = 0; i < len; ++i) {
            boolean blSubsystemDeployed = AdaptiveUtil.isSubsystemDeployed((String)subSystemLst.get(i));
            UMLogger.debug(this.getClass(), " isSubSystemDeployed ", subSystemLst.get(i) + " is deployed " + blSubsystemDeployed);
            if (!blSubsystemDeployed) continue;
            return true;
        }
        return false;
    }
}

