/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.util;

import com.huawei.u2000.umcommon.util.UMXMLUtil;
import com.huawei.u2000.util.UMLogger;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jdom.Element;

public class UMSingleOSSUtil {
    private static final String CUSTOMIZE_CFGFILE = "style/productstyle/conf/ext_unitedmgr_customize/u2kslnunitedmgrconf.xml";
    private static final String STR_ENABLE = "true";
    private static UMSingleOSSUtil instance = null;
    private static final String ROOT_DESC = "customizes";
    private static final String RES_NAME = "resname";
    private static final String RES_VALUE = "value";
    private Map<String, String> CustomizeMap = new HashMap<String, String>();

    public static synchronized UMSingleOSSUtil getInstance() {
        if (null == instance) {
            instance = new UMSingleOSSUtil();
        }
        return instance;
    }

    private UMSingleOSSUtil() {
        try {
            this.initData();
        }
        catch (Exception ex) {
            UMLogger.exception(ex);
        }
    }

    public boolean isEnableCfg(String strCfgName) {
        try {
            String strValue = this.CustomizeMap.get(strCfgName);
            if (null != strValue) {
                boolean bVal = STR_ENABLE.equals(strValue.trim().toLowerCase(Locale.ENGLISH));
                UMLogger.debug(this.getClass(), " isEnableCfg ", "strCfgName : " + strCfgName + " strValue : " + strValue);
                return bVal;
            }
            return false;
        }
        catch (Exception ex) {
            UMLogger.exception(ex);
            return false;
        }
    }

    private void initData() {
        Element root = UMXMLUtil.getRootElement(CUSTOMIZE_CFGFILE);
        if (null == root) {
            UMLogger.error(this.getClass(), " initData ", "read gem cfg file failed: style/productstyle/conf/ext_unitedmgr_customize/u2kslnunitedmgrconf.xml");
            return;
        }
        Element element = root.getChild(ROOT_DESC);
        List children = element.getChildren();
        String strKey = "";
        String strValue = "";
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            Element aChild = (Element)children.get(i);
            strKey = aChild.getAttributeValue(RES_NAME);
            strValue = aChild.getAttributeValue(RES_VALUE);
            UMLogger.debug(this.getClass(), " initData ", "strKey : " + strKey + " strValue : " + strValue);
            this.CustomizeMap.put(strKey, strValue);
        }
    }
}

