/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.util;

import com.swimap.iview.util.DebugTracer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class UMLogger {
    public static final String LOG_PRIFIX = "[Unitedmgr] ";
    public static final String TRACE_PRIFIX = "[Unitedmgr] | ";
    public static final Logger logger = Logger.getLogger(UMLogger.class);

    private UMLogger() {
    }

    public static void debug(String detail) {
        logger.trace((Object)(LOG_PRIFIX + detail));
    }

    public static void debug(Class clazz, String method, String detail) {
        DebugTracer.trace((int)1, (String)(TRACE_PRIFIX + clazz.getSimpleName()), (String)method, (String)detail);
    }

    public static void warn(String detail) {
        logger.warn((Object)(LOG_PRIFIX + detail));
    }

    public static void warn(Class clazz, String method, String detail) {
        DebugTracer.trace((int)2, (String)(TRACE_PRIFIX + clazz.getSimpleName()), (String)method, (String)detail);
    }

    public static void error(String detail) {
        logger.error((Object)(LOG_PRIFIX + detail));
    }

    public static void error(Class clazz, String method, String detail) {
        DebugTracer.trace((int)3, (String)(TRACE_PRIFIX + clazz.getSimpleName()), (String)method, (String)detail);
    }

    public static void exception(Exception e) {
        logger.error((Object)TRACE_PRIFIX, (Throwable)e);
    }

    public static void exception(String message, Exception e) {
        logger.error((Object)(TRACE_PRIFIX + message), (Throwable)e);
        DebugTracer.trace((Exception)e);
    }

    static {
        if (!DebugTracer.isEnableDebug()) {
            logger.setLevel(Level.OFF);
        }
    }

    public static class UMLoggerModelLabel {
        public static final String STR_INV_LOGGER = " [Inventory KeyLogger] ";
        public static final String STR_FIBER_LOGGER = " [Fiber KeyLogger] ";
        public static final String STR_LINK_LOGGER = " [Link KeyLogger] ";
        public static final String STR_OBJTREE_LOGGER = " [Object Tree KeyLogger] ";
    }
}

