/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.util;

import com.huawei.imap12.utility.InmCommonUtil;
import com.huawei.u2000.basetool.uid.StrUIDParser;
import com.huawei.u2000.inf.UMCommonSBIInterface;
import com.huawei.u2000.unitedmgr.UMResourceFieldEnvironment;
import com.huawei.u2000.unitedmgr.UMUnitedMgrModule;
import com.huawei.u2000.util.U2kModuleManagerFactory;
import com.huawei.u2000.util.U2kUnitedUtilities;
import com.huawei.u2000.util.UMLogger;

public class UMFDNUtil {
    private StrUIDParser parser = new StrUIDParser();
    public static final int INVALID_INT = -1;

    public static boolean isBrothers(String fdn1, String fdn2) {
        StrUIDParser fdnParser1 = new StrUIDParser();
        boolean isFDN1Succeed = fdnParser1.parse(fdn1);
        StrUIDParser fdnParser2 = new StrUIDParser();
        boolean isFDN2Succeed = fdnParser2.parse(fdn2);
        if (isFDN1Succeed && isFDN2Succeed) {
            boolean isExistNext1 = fdnParser1.next();
            boolean isExistNext2 = fdnParser2.next();
            while (isExistNext1 == isExistNext2) {
                if (!isExistNext1 || UMFDNUtil.isSameCurrentObj(fdnParser1, fdnParser2)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private static boolean isSameCurrentObj(StrUIDParser fdnParser1, StrUIDParser fdnParser2) {
        boolean isSameType = fdnParser1.type().equals(fdnParser2.type());
        boolean isSameValue = fdnParser1.intValue() == fdnParser2.intValue();
        return isSameType && isSameValue;
    }

    public static int[] getNeIDListFromFDNList(String[] resFDNList) {
        if (null == resFDNList) {
            return null;
        }
        int[] neIDList = new int[resFDNList.length];
        for (int i = 0; i < resFDNList.length; ++i) {
            StrUIDParser fdnParser = new StrUIDParser();
            neIDList[i] = fdnParser.parse(resFDNList[i]) ? (int)fdnParser.intValue("NE") : -1;
        }
        return neIDList;
    }

    public static int getNeIDFromFDN(String resFDN) {
        if (U2kUnitedUtilities.isNull(resFDN)) {
            return -1;
        }
        StrUIDParser fdnParser = new StrUIDParser();
        if (fdnParser.parse(resFDN)) {
            return (int)fdnParser.intValue("NE");
        }
        return -1;
    }

    public static int getOSIDFromFDN(String resFDN) {
        if (U2kUnitedUtilities.isNull(resFDN)) {
            return -1;
        }
        StrUIDParser fdnParser = new StrUIDParser();
        if (fdnParser.parse(resFDN)) {
            return (int)fdnParser.intValue("OS");
        }
        return -1;
    }

    public static int getOneIDFromFDN(String resFDN) {
        if (U2kUnitedUtilities.isNull(resFDN)) {
            return -1;
        }
        StrUIDParser fdnParser = new StrUIDParser();
        if (fdnParser.parse(resFDN)) {
            return (int)fdnParser.intValue("ONE");
        }
        return -1;
    }

    public static int getNMFromFDN(String resFDN) {
        if (U2kUnitedUtilities.isNull(resFDN)) {
            return -1;
        }
        StrUIDParser fdnParser = new StrUIDParser();
        if (fdnParser.parse(resFDN)) {
            return (int)fdnParser.intValue("OS");
        }
        return -1;
    }

    public static String getMOC(String fdn) {
        StrUIDParser fdnParser = new StrUIDParser();
        if (fdnParser.parse(fdn)) {
            return fdnParser.getMOC();
        }
        return "";
    }

    public static boolean isBelongSameNE(String fdn1, String fdn2) {
        StrUIDParser fdnParser1 = new StrUIDParser();
        boolean isFDN1Succeed = fdnParser1.parse(fdn1);
        StrUIDParser fdnParser2 = new StrUIDParser();
        boolean isFDN2Succeed = fdnParser2.parse(fdn2);
        if (isFDN1Succeed && isFDN2Succeed) {
            long neID2;
            long neID1 = fdnParser1.intValue("NE");
            return neID1 == (neID2 = fdnParser2.intValue("NE"));
        }
        return false;
    }

    public static int getIntValue(String strFDN, String strMOC) {
        StrUIDParser fdnParser = new StrUIDParser();
        if (fdnParser.parse(strFDN)) {
            return (int)fdnParser.intValue(strMOC);
        }
        return -1;
    }

    public static String getResourceNameFromFDN(String fdn) {
        String name = "";
        UMUnitedMgrModule mgrModule = (UMUnitedMgrModule)U2kModuleManagerFactory.getModule("united_common");
        UMCommonSBIInterface sbiInf = mgrModule.getSBIInterfaceFromFDN(fdn);
        UMResourceFieldEnvironment environment = new UMResourceFieldEnvironment(){

            public int getShowStyle() {
                return 0;
            }
        };
        if (sbiInf != null) {
            name = sbiInf.getResourceNameFromFDN(fdn, environment);
        }
        return name;
    }

    public int getNeOrOneIdFromFDN(String fdn) {
        if (fdn != null) {
            String mocValue;
            if (fdn.indexOf("ONE") >= 0 && (mocValue = this.getMocValue(fdn, "ONE")) != null) {
                return Integer.parseInt(mocValue);
            }
            if (fdn.indexOf("NE") >= 0 && (mocValue = this.getMocValue(fdn, "NE")) != null) {
                return Integer.parseInt(mocValue);
            }
            if (InmCommonUtil.isNum((String)fdn)) {
                return Integer.parseInt(fdn);
            }
        }
        UMLogger.debug(UMFDNUtil.class, "getNeOrOneIdFromFDN", "fdn is not valid \uff1a" + fdn);
        return -1;
    }

    private String getMocValue(String fdn, String mocKey) {
        this.parser.parse(fdn);
        return this.parser.strValue(mocKey);
    }
}

