/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.util;

import com.huawei.dfw.data.ProcessInfo;
import com.huawei.dfw.proxy.ProxyFactory;
import com.huawei.u2000.util.UMLogger;
import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class UMDomainKeyProcAdapter {
    private static final String PATH = "style" + File.separator + "productstyle" + File.separator + "conf" + File.separator + "ext_u2000_unitedmgr" + File.separator + "domainkeyprocessid.xml";
    private static final String AREA_DESC = "MapArea";
    private static final String IP_DESC = "IP";
    private static final String ACCESS_DESC = "Access";
    private static final String TRANSPORT_DESC = "Transport";
    private List<Integer> IPProcLst = new ArrayList<Integer>();
    private List<Integer> AccessProcLst = new ArrayList<Integer>();
    private List<Integer> TransProcLst = new ArrayList<Integer>();
    private static UMDomainKeyProcAdapter instance = null;
    private boolean blIPKeyProcExist = true;
    private boolean blAccessKeyProcExist = true;
    private boolean blTransKeyProcExist = true;

    public static synchronized UMDomainKeyProcAdapter getInstance() {
        if (null == instance) {
            instance = new UMDomainKeyProcAdapter();
        }
        return instance;
    }

    private UMDomainKeyProcAdapter() {
        this.parseConfigurationFiles();
        this.initKeyProcExist();
    }

    private void parseConfigurationFiles() {
        try {
            CommStyleInfo procIDStyleInfo = CommStyleManager.getInstance().getCommonStyleFileByPath(PATH, false);
            if (null == procIDStyleInfo) {
                UMLogger.debug("Class: UMDomainKeyProcAdapter, Parse the devices description file fail!");
                return;
            }
            AreaDescContainer container = procIDStyleInfo.getAreaDescContainer(AREA_DESC);
            if (null == container) {
                UMLogger.debug("Class: UMDomainKeyProcAdapter, AreaDescContainer is null!");
                return;
            }
            this.IPProcLst = this.readDescPara(container, IP_DESC);
            this.AccessProcLst = this.readDescPara(container, ACCESS_DESC);
            this.TransProcLst = this.readDescPara(container, TRANSPORT_DESC);
        }
        catch (Exception ex) {
            UMLogger.debug(UMDomainKeyProcAdapter.class.toString() + " parseConfigurationFiles() error!");
            UMLogger.exception(ex);
        }
    }

    private List<Integer> readDescPara(AreaDescContainer container, String strDesc) {
        DescContainer dcObject = null;
        PARA para = null;
        ArrayList<Integer> proLst = new ArrayList<Integer>();
        try {
            dcObject = container.getDescContainer(strDesc);
            if (null != dcObject) {
                int paraLenth = dcObject.getParasItemCount();
                for (int j = 0; j < paraLenth; ++j) {
                    para = dcObject.getParasItem(j);
                    if (null == para) continue;
                    proLst.add(Integer.valueOf(para.getValue().trim()));
                }
            } else {
                UMLogger.debug(strDesc + " is null!");
            }
        }
        catch (Exception ex) {
            UMLogger.error(this.getClass(), "readDescPara", "function is readDescPara, strDesc is: " + strDesc);
            UMLogger.exception(ex);
        }
        return proLst;
    }

    private List<ProcessInfo> getAllNeMgrProcessInfo() {
        List proInfoLst = ProxyFactory.getInstance().getDFWDataMgr().getAllNeMgrProcessInfo();
        if (null == proInfoLst) {
            UMLogger.debug(UMDomainKeyProcAdapter.class.toString() + " getAllNeMgrProcessInfo() Process infomation list is null!");
            return null;
        }
        UMLogger.debug("Class:UMDomainKeyProcAdapter, Process infomation========>");
        for (ProcessInfo proInfo : proInfoLst) {
            UMLogger.debug(proInfo.toString());
        }
        UMLogger.debug("Class:UMDomainKeyProcAdapter, Process infomation End ===>");
        return proInfoLst;
    }

    private void initKeyProcExist() {
        List<ProcessInfo> proInfoLst = this.getAllNeMgrProcessInfo();
        if (null == proInfoLst) {
            UMLogger.debug("Class: UMDomainKeyProcAdapter, Function: isProcessExist(), proInfoLst is null!");
            return;
        }
        this.blIPKeyProcExist = this.isProcessExist(proInfoLst, this.IPProcLst, "isIPKeyProcessExist");
        this.blAccessKeyProcExist = this.isProcessExist(proInfoLst, this.AccessProcLst, "isAccessKeyProcessExist");
        this.blTransKeyProcExist = this.isProcessExist(proInfoLst, this.TransProcLst, "isTransportKeyProcessExist");
    }

    private boolean isProcessExist(List<ProcessInfo> proInfoLst, List<Integer> procLst, String strFunctionName) {
        if (null == procLst || procLst.isEmpty()) {
            UMLogger.debug("Class: UMDomainKeyProcAdapter, Function: isProcessExist(), procLst is: " + procLst + " function name is : " + strFunctionName);
            return true;
        }
        UMLogger.debug("Class: UMDomainKeyProcAdapter, strFunctionName is : " + strFunctionName + " processLst is :" + procLst);
        int len = proInfoLst.size();
        for (int i = 0; i < len; ++i) {
            char procID = proInfoLst.get(i).getProcID();
            if (!procLst.contains(procID)) continue;
            return true;
        }
        return false;
    }

    public boolean isIPKeyProcessExist() {
        return this.blIPKeyProcExist;
    }

    public boolean isAccessKeyProcessExist() {
        return this.blAccessKeyProcExist;
    }

    public boolean isTransportKeyProcessExist() {
        return this.blTransKeyProcExist;
    }

    public boolean isIPSingleDomainInstall() {
        return !this.isAccessKeyProcessExist() && !this.isTransportKeyProcessExist() && this.isIPKeyProcessExist();
    }

    public boolean isAccessSingleDomainInstall() {
        return !this.isIPKeyProcessExist() && !this.isTransportKeyProcessExist() && this.isAccessKeyProcessExist();
    }

    public boolean isTransportSingleDomainInstall() {
        return !this.isIPKeyProcessExist() && !this.isAccessKeyProcessExist() && this.isTransportKeyProcessExist();
    }
}

