/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.util;

import com.huawei.core.util.asn.AsnDateTimeType;
import com.huawei.core.util.datetime.TEDisplayDateTime;
import com.huawei.core.util.datetime.TETimeLocalizationUtilities;
import com.swimap.iview.util.format.TimeFormatService;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class UMCreateDateTime
implements Comparable<UMCreateDateTime> {
    private AsnDateTimeType asnDate = null;
    private Calendar calendarObj = null;

    public UMCreateDateTime(AsnDateTimeType other) {
        this.asnDate = other;
        this.checkData();
        this.calendarObj = this.getCalendar();
    }

    public UMCreateDateTime(Calendar cal) {
        this.asnDate = new AsnDateTimeType();
        this.setCalendar(cal);
    }

    private void checkData() {
        if (this.asnDate == null) {
            this.asnDate = new TEDisplayDateTime().getAsnDateTimeType();
        }
    }

    public AsnDateTimeType getAsnData() {
        if (this.asnDate == null) {
            this.asnDate = new TEDisplayDateTime().getAsnDateTimeType();
        }
        return this.asnDate;
    }

    public Calendar getCalendar() {
        if (null != this.calendarObj) {
            return this.calendarObj;
        }
        GregorianCalendar calendar = new GregorianCalendar(TETimeLocalizationUtilities.getTimeZoneByNEID((int)-1));
        calendar.setTimeInMillis(this.getGMTUTCTimeInMillis(this.getAsnData()));
        return calendar;
    }

    private long getGMTUTCTimeInMillis(AsnDateTimeType dateDateTime) {
        TEDisplayDateTime calendar = new TEDisplayDateTime();
        calendar.set(dateDateTime.year, dateDateTime.month - 1, dateDateTime.day, dateDateTime.hour, dateDateTime.minute, dateDateTime.second);
        return calendar.getTimeInMillis();
    }

    void setCalendar(Calendar cal) {
        if (cal == null) {
            return;
        }
        TEDisplayDateTime displayTime = new TEDisplayDateTime();
        displayTime.setTimeInMillis(cal.getTimeInMillis());
        this.asnDate = displayTime.updateAsnDateTimeType();
    }

    @Override
    public int compareTo(UMCreateDateTime o) {
        if (null == o || !(o instanceof UMCreateDateTime)) {
            return -1;
        }
        this.checkData();
        UMCreateDateTime other = o;
        if (this.asnDate.year != other.asnDate.year) {
            return this.asnDate.year - other.asnDate.year;
        }
        if (this.asnDate.month != other.asnDate.month) {
            return this.asnDate.month - other.asnDate.month;
        }
        if (this.asnDate.day != other.asnDate.day) {
            return this.asnDate.day - other.asnDate.day;
        }
        if (this.asnDate.hour != other.asnDate.hour) {
            return this.asnDate.hour - other.asnDate.hour;
        }
        if (this.asnDate.minute != other.asnDate.minute) {
            return this.asnDate.minute - other.asnDate.minute;
        }
        return this.asnDate.second - other.asnDate.second;
    }

    public boolean equals(Object o) {
        if (!(o instanceof UMCreateDateTime)) {
            return false;
        }
        this.checkData();
        UMCreateDateTime other = (UMCreateDateTime)o;
        return this.asnDate.year == other.asnDate.year && this.asnDate.month == other.asnDate.month && this.asnDate.day == other.asnDate.day && this.asnDate.hour == other.asnDate.hour && this.asnDate.minute == other.asnDate.minute && this.asnDate.second == other.asnDate.second;
    }

    public int hashCode() {
        int result = this.asnDate.year;
        result += 31 * this.asnDate.month;
        result += 31 * this.asnDate.day;
        result += 31 * this.asnDate.hour;
        result += 31 * this.asnDate.minute;
        return result += 31 * this.asnDate.second;
    }

    public String toString() {
        GregorianCalendar calTmp = new GregorianCalendar(TETimeLocalizationUtilities.getTimeZone());
        calTmp.setTimeInMillis(this.getGMTUTCTimeInMillis(this.getAsnData()));
        return TimeFormatService.getString((Calendar)calTmp);
    }
}

