/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.util;

import com.huawei.imap12.utility.InmAreaDescObject;
import com.huawei.imap12.utility.InmFileDescObject;
import com.huawei.imap12.utility.InmProfileFactory;
import com.huawei.u2000.util.UMLogger;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class UMCommonResourceUtil {
    private static InmAreaDescObject oAreaObject = null;
    private static Object oLock = new Object();
    private static Map<String, UMCommonResourceUtil> fileMap = new HashMap<String, UMCommonResourceUtil>();
    private String strCurrFileName = "";

    private UMCommonResourceUtil(String strFileName) {
        this.strCurrFileName = strFileName;
    }

    public static UMCommonResourceUtil getInstance(String strFileName) {
        UMCommonResourceUtil instance = null;
        if (!fileMap.containsKey(strFileName)) {
            instance = new UMCommonResourceUtil(strFileName);
            fileMap.put(strFileName, instance);
        } else {
            instance = fileMap.get(strFileName);
        }
        return instance;
    }

    public String getString(String strKey) {
        try {
            return this.getString("string_resource", strKey);
        }
        catch (Exception exp) {
            UMLogger.exception(exp);
            return strKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getString(String strAreaName, String strKey) {
        Object object = oLock;
        synchronized (object) {
            InmFileDescObject fileDescObject = InmProfileFactory.getCommonFileDescObject((String)this.strCurrFileName);
            if (null == fileDescObject) {
                UMLogger.debug("Class: UMCommonResourceUtil, function:getString, fileDescObject is null.");
                return strKey;
            }
            oAreaObject = fileDescObject.getAreaDescObject(strAreaName);
            if (null == oAreaObject) {
                StringBuffer message = new StringBuffer("read config file\uff1a");
                message.append(this.strCurrFileName);
                message.append("  domain :string_resource failed.");
                UMLogger.debug(message.toString());
                return strKey;
            }
            String strValue = oAreaObject.getStringPropertyvalue(strKey, "value");
            String string = null == strValue ? strKey : strValue;
            return string;
        }
    }

    public static Element getRootElement(String xmlFile) {
        SAXBuilder sb = new SAXBuilder();
        URL path = InmProfileFactory.getCommonResourceURL((String)xmlFile);
        UMLogger.debug("start to parse XML = " + path);
        Document myDocument = null;
        try {
            myDocument = sb.build(path);
        }
        catch (Exception e) {
            UMLogger.exception("parse xml failed!", e);
            return null;
        }
        return myDocument.getRootElement();
    }
}

