/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.util;

import com.huawei.u2000.util.UMLogger;
import com.swimap.external.sf.sys.viewframework.tzdstregister.TZDSTRegistry;
import com.swimap.iview.framework.IViewTimeZone;
import com.swimap.iview.util.format.TimeDateFormatUtil;
import java.util.Calendar;
import java.util.TimeZone;

public class UMAlarmUtility {
    public static final int INVALID_VALUE = -100;
    private static int clientTimeZone = -100;
    private static int serverTimeZone = -100;
    private static TimeZone clientTimeZoneInst = null;

    public static String getStringForDateAndTime(int timeInSeoncds, int timeZone, int offset) {
        if (timeInSeoncds == 0) {
            return "";
        }
        int[] timedata = UMAlarmUtility.getTimeData((long)timeInSeoncds * 1000L);
        return UMAlarmUtility.getStringForTimes(timedata[0], timedata[1], timedata[2], timedata[3], timedata[4], timedata[5], offset, timeZone);
    }

    public static int[] getTimeData(long timeInMillis) {
        int[] dateArray = new int[6];
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeInMillis);
        dateArray[0] = calendar.get(1);
        dateArray[1] = calendar.get(2) + 1;
        dateArray[2] = calendar.get(5);
        dateArray[3] = calendar.get(11);
        dateArray[4] = calendar.get(12);
        dateArray[5] = calendar.get(13);
        return dateArray;
    }

    static String getStringForTimes(int year, int month, int date, int hour, int minute, int second, int offset, int timeZone) {
        try {
            String value = null;
            value = timeZone == -100 && offset == -100 ? TimeDateFormatUtil.getFormatDateTime((int)year, (int)month, (int)date, (int)hour, (int)minute, (int)second) : TimeDateFormatUtil.getFormatDateTime((int)year, (int)month, (int)date, (int)hour, (int)minute, (int)second, (int)offset, (int)timeZone);
            return value;
        }
        catch (Exception e) {
            UMLogger.exception("Convert date-time to display string fail.", e);
            return UMAlarmUtility.convertToDateTimeString(year, month, date, hour, minute, second);
        }
    }

    public static String convertToDateTimeString(int year, int month, int day, int hour, int minute, int second) {
        StringBuffer timeBuffer = new StringBuffer().append(year);
        if (10 > month) {
            timeBuffer.append("-0").append(month);
        } else {
            timeBuffer.append("-").append(month);
        }
        if (10 > day) {
            timeBuffer.append("-0").append(day).append("  ");
        } else {
            timeBuffer.append("-").append(day).append("  ");
        }
        if (10 > hour) {
            timeBuffer.append("0").append(hour);
        } else {
            timeBuffer.append(hour);
        }
        if (10 > minute) {
            timeBuffer.append(":0").append(minute);
        } else {
            timeBuffer.append(":").append(minute);
        }
        if (10 > second) {
            timeBuffer.append(":0").append(second);
        } else {
            timeBuffer.append(":").append(second);
        }
        return timeBuffer.toString();
    }

    public static int getServerTimeZone() {
        if (-100 == serverTimeZone) {
            serverTimeZone = TZDSTRegistry.getInstance().getServiceTimeZone().getRawOffset() / 1000;
        }
        return serverTimeZone;
    }

    public static int getClientTimeZone() {
        if (-100 == clientTimeZone) {
            TimeZone clientTimeZoneInst = new IViewTimeZone().getTimeZone();
            clientTimeZone = clientTimeZoneInst.getRawOffset() / 1000;
        }
        return clientTimeZone;
    }

    public static TimeZone getClientTimeZoneInst() {
        if (null == clientTimeZoneInst) {
            clientTimeZoneInst = new IViewTimeZone().getTimeZone();
        }
        return clientTimeZoneInst;
    }
}

