/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.util;

import com.huawei.core.util.progressbactrl.ProgressBarMgr;
import com.huawei.dfw.data.CommonDataMgr;
import com.huawei.dfw.data.ProcessInfo;
import com.huawei.dfw.proxy.ProxyFactory;
import com.huawei.dfw.proxy.iface.INEProxyService;
import com.huawei.imap12.security.InmSecurityUtil;
import com.huawei.imap12.topo.InmTopoSubnet;
import com.huawei.imap12.topo.InmTopoUtil;
import com.huawei.imap12.utility.InmCommonUtil;
import com.huawei.imap12.utility.help.InmHelpMgr;
import com.huawei.te.common.neproxy.TEProcID;
import com.huawei.u2000.basetool.UMFrameAppAdapter;
import com.huawei.u2000.basetool.uid.StrUIDParser;
import com.huawei.u2000.component.dialog.BaseInternalDialog;
import com.huawei.u2000.framework.module.AbstractProductBaseModule;
import com.huawei.u2000.inf.UMCommonSBIInterface;
import com.huawei.u2000.inf.inventory.common.UMNeInfo;
import com.huawei.u2000.inf.inventory.common.UMOneInf;
import com.huawei.u2000.inventory.UMInventoryModule;
import com.huawei.u2000.umcommon.security.U2kCommonSecurityUtil;
import com.huawei.u2000.unitedmgr.UMResourceFieldEnvironment;
import com.huawei.u2000.unitedmgr.UMUnitedMgrAdapter;
import com.huawei.u2000.unitedmgr.UMUnitedMgrModule;
import com.huawei.u2000.util.U2kModuleManagerFactory;
import com.huawei.u2000.util.UMFDNUtil;
import com.huawei.u2000.util.UMLogger;
import com.swimap.external.ifms.adapter.message.PlatformFaultContext;
import com.swimap.external.resource.client.emf.EmfTopoDeviceType;
import com.swimap.external.resource.client.emf.EmfTopoElementIf;
import com.swimap.external.sm.client.base.AuthorizationService;
import com.swimap.external.sm.client.base.common.model.RightInfo;
import com.swimap.external.topo.adapter.message.EmfTopoContainerInfo;
import com.swimap.external.topo.adapter.message.EmfTopoInterface;
import com.swimap.external.topo.adapter.message.EmfTopoLinkInfo;
import com.swimap.external.topo.adapter.message.EmfTopoNodeInfo;
import com.swimap.external.topo.adapter.message.EmfTopoObjectInfo;
import com.swimap.external.topo.adapter.message.EmfTopoSubmapInfo;
import com.swimap.iview.communicate.MSGPacketExt;
import com.swimap.iview.framework.Main;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.InternalLocalMsg;
import com.swimap.iview.framework.pluginmanagement.CommStyleParser;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import net.commustru.fstru.Decoder;
import net.commustru.fstru.FStruDecoder;
import net.commustru.fstru.FStruct;

public final class U2kUnitedUtilities {
    public static final int BASE_HYBRID_LEVEL = 61440;
    public static final int MAX_HYBRID_LEVEL = 65535;
    public static final String PHY_ROOT_MAP_ID = "S102";
    public static final int FRAME_SIZE = 100;
    public static final int PHY_VIEW_ID = 101;
    public static final String M2000_DEVTYPE_ID = "65535";
    private static List<EmfTopoContainerInfo> allContainerInfo = null;
    public static final char LINE_SEPATORE = File.separatorChar;
    public static final char ANOTHER_LINE_SEPATORE = U2kUnitedUtilities.getAnotherSepator();

    private U2kUnitedUtilities() {
    }

    public static Object sendTopoEvent(String moduleID, InternalLocalMsg msg) {
        BaseModule moduleHandle = UMFrameAppAdapter.getInstance().getLocalModule(moduleID, false);
        if (moduleHandle != null) {
            return UMFrameAppAdapter.getInstance().sendEvent(moduleHandle, "com.swimap.adapter.message.tm", msg);
        }
        return null;
    }

    private static int getExpanOrCallapseState() {
        InternalLocalMsg msg = new InternalLocalMsg();
        msg.ID = 4149;
        msg.data = null;
        msg.sendModule = "united_common";
        Integer ret = Integer.valueOf("0");
        try {
            ret = (Integer)U2kUnitedUtilities.sendTopoEvent(msg.sendModule, msg);
        }
        catch (RuntimeException e) {
            UMLogger.exception(e);
        }
        return ret == null ? -1 : ret;
    }

    public static boolean getExpandState() {
        switch (U2kUnitedUtilities.getExpanOrCallapseState()) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
        }
        return false;
    }

    public static boolean getCallapseState() {
        switch (U2kUnitedUtilities.getExpanOrCallapseState()) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
        }
        return false;
    }

    public static void expandAll() {
        UMLogger.debug("call expandAll()");
        U2kUnitedUtilities.getEmfTopoInterface().expandCurrentAllSubnet(true);
    }

    public static void collapseAll() {
        UMLogger.debug("call collapseAll()");
        EmfTopoInterface topoInf = U2kUnitedUtilities.getEmfTopoInterface();
        if (topoInf != null) {
            topoInf.collpaseCurrentAllSubnet(true);
        }
    }

    public static EmfTopoInterface getEmfTopoInterface() {
        return (EmfTopoInterface)UMFrameAppAdapter.getInstance().getLocalModule("com.swimap.adapter.message.tm", false);
    }

    public static boolean securityQualify(int neID, int cmdCode) {
        return InmSecurityUtil.securityQualify((int)cmdCode, (String)String.valueOf(neID));
    }

    public static void doConfirmAlarm(List<String> resIDList) {
        PlatformFaultContext faultInf = U2kModuleManagerFactory.getFaultInterface();
        if (faultInf != null) {
            faultInf.ackAlarmByFDN(resIDList);
        }
    }

    public static List getAllNodeChildren(String submapID) {
        return U2kUnitedUtilities.getEmfTopoInterface().getAllNodeChildren(submapID);
    }

    public static EmfTopoSubmapInfo getTopoSubmapInfo(String submapID) {
        return (EmfTopoSubmapInfo)U2kUnitedUtilities.getTopoObjectInfo(submapID);
    }

    public static EmfTopoObjectInfo getTopoObjectInfo(String nodeID) {
        String fdnNodeID = InmCommonUtil.getObjFDNFromResID((String)nodeID);
        LinkedList topoObjectList = U2kUnitedUtilities.getEmfTopoInterface().getTopoNode(new String[]{fdnNodeID});
        if (null == topoObjectList || topoObjectList.size() <= 0) {
            UMLogger.debug("The" + nodeID + " is null.");
            return null;
        }
        return (EmfTopoObjectInfo)topoObjectList.get(0);
    }

    public static InmTopoSubnet getSubnetFromNE(int neID) {
        String resID = "";
        LinkedList list = InmTopoUtil.getTopoElementInfo((String)(resID = resID + neID));
        if (list == null) {
            return null;
        }
        EmfTopoNodeInfo nodeInfo = (EmfTopoNodeInfo)list.get(0);
        return InmTopoUtil.getTopoSubmap((String)nodeInfo.m_szParentID);
    }

    public static List<EmfTopoNodeInfo> convertEmfListToNodeInfoList(List<EmfTopoElementIf> emfObjList) {
        if (null == emfObjList || emfObjList.isEmpty()) {
            return null;
        }
        ArrayList<EmfTopoNodeInfo> emfTopoNodeInfoLst = new ArrayList<EmfTopoNodeInfo>();
        EmfTopoElementIf topoEle = null;
        int size = emfObjList.size();
        for (int i = 0; i < size; ++i) {
            topoEle = emfObjList.get(i);
            if (1 != topoEle.getElementType()) continue;
            emfTopoNodeInfoLst.add((EmfTopoNodeInfo)topoEle);
        }
        return emfTopoNodeInfoLst;
    }

    public static boolean isNull(String inputStr) {
        boolean isNull = false;
        isNull = inputStr == null || "".equals(inputStr.trim());
        return isNull;
    }

    public static String convertNullToBlankString(String inputString) {
        String outputString = "";
        if (inputString != null) {
            outputString = inputString;
        }
        return outputString;
    }

    public static char getAnotherSepator() {
        if ('\\' == LINE_SEPATORE) {
            return '/';
        }
        return '\\';
    }

    public static String getPath(String path) {
        return path.replace(ANOTHER_LINE_SEPATORE, LINE_SEPATORE);
    }

    public static void registeHelp(Component parent, String helpId) {
        InmHelpMgr.instance().helpComponent(parent, InmHelpMgr.instance().getHelpID(helpId));
    }

    public static boolean isTransNe(long neTypeID) {
        boolean isTransNe = false;
        isTransNe = neTypeID >= 1793L && neTypeID <= 2047L;
        return isTransNe;
    }

    public static List<EmfTopoObjectInfo> getTopoElementInfo(int iNEID) {
        LinkedList nodeInfoList = InmTopoUtil.getTopoElementInfo((String)String.valueOf(iNEID));
        if (null != nodeInfoList && !nodeInfoList.isEmpty()) {
            return nodeInfoList;
        }
        UMUnitedMgrModule unitedModule = U2kModuleManagerFactory.getUMUnitedMgrModule();
        if (null != unitedModule) {
            UMCommonSBIInterface sbiInterface = unitedModule.getSBIInterface(iNEID);
            if (null == sbiInterface) {
                UMLogger.debug("Class: U2kUnitedUtilities, getTopoElementInfo(int iNEID), neID: " + iNEID + " sbiInterface is null.");
                return null;
            }
            return sbiInterface.getTopoElementInfo(String.valueOf(iNEID));
        }
        return null;
    }

    private static Object getTopoSelectedObject(int type) {
        InternalLocalMsg msg = new InternalLocalMsg();
        msg.ID = type;
        msg.sendModule = "united_common";
        return U2kUnitedUtilities.sendTopoEvent(msg.sendModule, msg);
    }

    public static List<EmfTopoNodeInfo> getTopoSelectedNode() {
        ArrayList list = (ArrayList)U2kUnitedUtilities.getTopoSelectedObject(4099);
        if (null == list) {
            list = new ArrayList();
        }
        return list;
    }

    public static List<EmfTopoLinkInfo> getTopoSelectedLink() {
        ArrayList list = (ArrayList)U2kUnitedUtilities.getTopoSelectedObject(4117);
        if (null == list) {
            list = new ArrayList();
        }
        return list;
    }

    public static List<EmfTopoNodeInfo> getTopoSeletedNodeInfoLst() {
        ArrayList<EmfTopoNodeInfo> neInfoLst = new ArrayList<EmfTopoNodeInfo>();
        InternalLocalMsg msg = new InternalLocalMsg();
        msg.ID = 4099;
        msg.sendModule = "united_common";
        List curSelNodes = (List)U2kUnitedUtilities.sendTopoEvent(msg.sendModule, msg);
        U2kUnitedUtilities.addSelectedNE(neInfoLst, curSelNodes);
        msg.ID = 4098;
        List submaps = (List)U2kUnitedUtilities.sendTopoEvent(msg.sendModule, msg);
        U2kUnitedUtilities.addSelectedSubMapNode(neInfoLst, submaps);
        return neInfoLst;
    }

    public static List<EmfTopoSubmapInfo> getTopoSelectedSubmap() {
        return (List)U2kUnitedUtilities.getTopoSelectedObject(4098);
    }

    public static boolean isSelectedPhysicalRootSubmap() {
        EmfTopoSubmapInfo subMapInfo;
        List<EmfTopoSubmapInfo> submapLst = U2kUnitedUtilities.getTopoSelectedSubmap();
        if (null == submapLst) {
            return false;
        }
        if (submapLst.size() == 1 && null != (subMapInfo = submapLst.get(0))) {
            return PHY_ROOT_MAP_ID.equalsIgnoreCase(subMapInfo.m_szID);
        }
        return false;
    }

    public static List<EmfTopoObjectInfo> getTopoSeletedObjectInfoLst() {
        ArrayList<EmfTopoObjectInfo> neInfoLst = new ArrayList<EmfTopoObjectInfo>();
        InternalLocalMsg msg = new InternalLocalMsg();
        msg.ID = 4099;
        msg.sendModule = "united_common";
        List curSelNodes = (List)U2kUnitedUtilities.sendTopoEvent(msg.sendModule, msg);
        U2kUnitedUtilities.addSelectedObject(neInfoLst, curSelNodes);
        msg.ID = 4098;
        List submaps = (List)U2kUnitedUtilities.sendTopoEvent(msg.sendModule, msg);
        U2kUnitedUtilities.addSelectedContainerNode(neInfoLst, submaps);
        return neInfoLst;
    }

    public static synchronized List<EmfTopoContainerInfo> getAllContainerInfo() {
        if (null == allContainerInfo) {
            allContainerInfo = new ArrayList<EmfTopoContainerInfo>();
            EmfTopoInterface topoInterface = U2kUnitedUtilities.getEmfTopoInterface();
            LinkedList neInfoLst = topoInterface.getAllObjectInView(topoInterface.getBaseViewID(), 2);
            for (EmfTopoObjectInfo info : neInfoLst) {
                if (!(info instanceof EmfTopoContainerInfo)) continue;
                allContainerInfo.add((EmfTopoContainerInfo)info);
            }
        }
        return allContainerInfo;
    }

    public static void clearAllContainerInfo() {
        if (null != allContainerInfo) {
            allContainerInfo.clear();
            allContainerInfo = null;
        }
    }

    private static void addSelectedObject(List<EmfTopoObjectInfo> neInfoLst, List<EmfTopoObjectInfo> curSelNodes) {
        if (null == curSelNodes || curSelNodes.isEmpty()) {
            return;
        }
        for (EmfTopoObjectInfo node : curSelNodes) {
            if (null == node) continue;
            neInfoLst.add(node);
        }
    }

    private static void addSelectedSubMapNode(List<EmfTopoNodeInfo> neInfoLst, List<EmfTopoSubmapInfo> subnets) {
        if (null == subnets || subnets.isEmpty()) {
            return;
        }
        List nodeList = null;
        EmfTopoSubmapInfo submap = null;
        int size = subnets.size();
        for (int i = 0; i < size; ++i) {
            submap = subnets.get(i);
            if (null == submap) continue;
            nodeList = U2kUnitedUtilities.getAllNodeChildren(submap.m_szID);
            U2kUnitedUtilities.addSelectedNE(neInfoLst, nodeList);
        }
    }

    private static void addSelectedNE(List<EmfTopoNodeInfo> neInfoLst, List<EmfTopoNodeInfo> curSelNodes) {
        if (null == curSelNodes || curSelNodes.isEmpty()) {
            return;
        }
        EmfTopoNodeInfo node = null;
        int size = curSelNodes.size();
        for (int i = 0; i < size; ++i) {
            node = curSelNodes.get(i);
            if (node == null) continue;
            neInfoLst.add(node);
        }
    }

    private static void addSelectedContainerNode(List<EmfTopoObjectInfo> neInfoLst, List<EmfTopoObjectInfo> subnets) {
        if (null == subnets || subnets.isEmpty()) {
            return;
        }
        List nodeList = null;
        for (EmfTopoObjectInfo submap : subnets) {
            if (submap instanceof EmfTopoContainerInfo) {
                neInfoLst.add(submap);
                continue;
            }
            if (null == submap) continue;
            nodeList = U2kUnitedUtilities.getAllNodeChildren(submap.m_szID);
            U2kUnitedUtilities.addSelectedObject(neInfoLst, nodeList);
            LinkedList list = U2kUnitedUtilities.getEmfTopoInterface().getAllSubmapChildren(submap.m_szID);
            for (EmfTopoSubmapInfo info : list) {
                if (!(info instanceof EmfTopoContainerInfo)) continue;
                neInfoLst.add((EmfTopoObjectInfo)info);
            }
        }
    }

    public static List<EmfTopoDeviceType> getAllDecType() {
        EmfTopoInterface topoInterface = (EmfTopoInterface)UMFrameAppAdapter.getInstance().getLocalModule("com.swimap.adapter.message.tm");
        return topoInterface.getAllDevType();
    }

    public static boolean isAvailableIP(String strIP) {
        if (U2kUnitedUtilities.isNull(strIP)) {
            return false;
        }
        Pattern ipPattern = Pattern.compile("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b");
        Matcher matcher = ipPattern.matcher(strIP);
        return matcher.matches();
    }

    public static boolean pathFormatIscorrect(String path) {
        String[] str;
        String pathRegex = "(\\w:\\\\([\\w\\W]+\\\\?)+)|(\\w:\\/([\\w\\W]+\\/?)+)|([\\/]([\\w\\W]+\\/?)*+)|([a-zA-Z][:]?[\\\\/]{0,1})";
        String errorRegex = "[`~!@#$%^&*()+=|{}';',\\[\\].<>?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
        for (String element : str = path.split("")) {
            if (!element.matches(errorRegex)) continue;
            return false;
        }
        return path.matches(pathRegex);
    }

    public static boolean charPathFormatIscorrect(String path) {
        String[] str;
        String pathRegex = "(\\w:\\\\([\\w\\W]+\\\\?)+)|(\\w:\\/([\\w\\W]+\\/?)+)|([\\/]([\\w\\W]+\\/?)*+)|([a-zA-Z][:]?[\\\\/]{0,1})";
        String errorRegex = "[`~!@#$%^&*()+=|{}';',\\[\\].<>?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
        String strCorrectRegex = "[\\w\\s:\\\\/]";
        for (String element : str = path.split("")) {
            if (element.isEmpty() || !element.matches(errorRegex) && element.matches(strCorrectRegex)) continue;
            return false;
        }
        return path.matches(pathRegex);
    }

    public static int getSTMLevel(int srcLevel, int dstLevel) {
        int stmLevel = srcLevel;
        if (U2kUnitedUtilities.isHybridLevel(srcLevel) && U2kUnitedUtilities.isHybridLevel(dstLevel)) {
            return srcLevel > dstLevel ? dstLevel : srcLevel;
        }
        if (12289 == srcLevel && 12289 == dstLevel) {
            stmLevel = srcLevel;
        } else if (12289 != srcLevel && 12289 != dstLevel) {
            int n = stmLevel = srcLevel > dstLevel ? dstLevel : srcLevel;
            if (stmLevel <= 0) {
                stmLevel = srcLevel > dstLevel ? srcLevel : dstLevel;
            }
        } else {
            stmLevel = 12289 == srcLevel ? dstLevel : srcLevel;
        }
        return stmLevel < 0 ? -1 : stmLevel;
    }

    private static boolean isHybridLevel(int srcLevel) {
        return srcLevel >= 61440 && srcLevel <= 65535;
    }

    public static String processLongStr(String strTmp, int iMaxSize) {
        String tempString = null;
        if (null == strTmp || strTmp.trim().isEmpty()) {
            tempString = "  ";
        } else if (strTmp.length() > iMaxSize) {
            int iSizeTmp = strTmp.length();
            StringBuilder sbtmp = new StringBuilder(100);
            int iStartTmp = 0;
            int iEndTmp = iMaxSize;
            while (iSizeTmp > 0) {
                sbtmp.append(strTmp.substring(iStartTmp, iEndTmp));
                iStartTmp = iEndTmp;
                if ((iSizeTmp -= iMaxSize) >= iMaxSize) {
                    iEndTmp += iMaxSize;
                    sbtmp.append(System.getProperty("line.separator"));
                    continue;
                }
                if (iSizeTmp <= 0) continue;
                iEndTmp += iSizeTmp;
                sbtmp.append(System.getProperty("line.separator"));
            }
            tempString = sbtmp.toString();
        } else {
            tempString = strTmp;
        }
        return tempString;
    }

    public static String getTooltipFormatterString(String strTmp, int iMaxSize) {
        String tempString = null;
        if (null == strTmp || strTmp.trim().isEmpty()) {
            tempString = "  ";
        } else if (strTmp.length() > iMaxSize) {
            int iSizeTmp = strTmp.length();
            StringBuilder sbtmp = new StringBuilder(100);
            sbtmp.append("<html><table>");
            int iStartTmp = 0;
            int iEndTmp = iMaxSize;
            while (iSizeTmp > 0) {
                sbtmp.append("<tr><td>");
                sbtmp.append(strTmp.substring(iStartTmp, iEndTmp));
                sbtmp.append("</td></tr>");
                iStartTmp = iEndTmp;
                if ((iSizeTmp -= iMaxSize) >= iMaxSize) {
                    iEndTmp += iMaxSize;
                    continue;
                }
                if (iSizeTmp <= 0) continue;
                iEndTmp += iSizeTmp;
            }
            sbtmp.append("</table></html>");
            tempString = sbtmp.toString();
        } else {
            tempString = strTmp;
        }
        return tempString;
    }

    public static void centerLocateToInternalFrame(Component comptoLocate) {
        if (null == comptoLocate) {
            return;
        }
        Dimension dScreen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dComponent = comptoLocate.getSize();
        Point pos = new Point();
        pos.x = (int)(dScreen.getWidth() / 2.0 - dComponent.getWidth() / 2.0);
        pos.y = (int)(dScreen.getHeight() / 2.0 - dComponent.getHeight() / 2.0) - 100;
        comptoLocate.setLocation(pos);
    }

    public static BaseInternalDialog getBaseInternalDlgForComponent(Component parentComponent) {
        if (parentComponent == null) {
            return null;
        }
        if (parentComponent instanceof BaseInternalDialog) {
            return (BaseInternalDialog)parentComponent;
        }
        return U2kUnitedUtilities.getBaseInternalDlgForComponent(parentComponent.getParent());
    }

    public static String formatStrByComma(String str) {
        if (null == str || "--".equals(str.trim()) || str.trim().isEmpty()) {
            return str;
        }
        int strLen = (str = str.trim()).length();
        if (strLen <= 3) {
            return str;
        }
        char[] strChar = str.toCharArray();
        StringBuilder sbuilder = new StringBuilder(strLen * 2);
        int iCount = 0;
        for (int i = strChar.length - 1; i >= 0; --i) {
            sbuilder.append(strChar[i]);
            if (3 != ++iCount || i <= 0) continue;
            sbuilder.append(",");
            iCount = 0;
        }
        return sbuilder.reverse().toString();
    }

    public static Map<String, String> getResourceNameFromFDN(List<String> fdn) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        Map<UMCommonSBIInterface, List<String>> interface2FDNListMap = U2kUnitedUtilities.groupFDNByProcess(fdn);
        if (null == interface2FDNListMap) {
            UMLogger.debug("interface2FDNListMap is null,FDNList : " + fdn);
            return resultMap;
        }
        Set<UMCommonSBIInterface> keySet = interface2FDNListMap.keySet();
        List<String> currentFDNList = null;
        UMResourceFieldEnvironment environment = new UMResourceFieldEnvironment(){

            public int getShowStyle() {
                return 0;
            }
        };
        List<String> currentResult = null;
        for (UMCommonSBIInterface interfaceKey : keySet) {
            currentFDNList = interface2FDNListMap.get(interfaceKey);
            UMLogger.debug(U2kUnitedUtilities.class, " getResourceNameFromFDN ", "currentFDNList size " + currentFDNList.size() + " interfaceKey is : " + interfaceKey);
            currentResult = interfaceKey.getResourceNameFromFDN(currentFDNList, environment);
            UMLogger.debug(U2kUnitedUtilities.class, " getResourceNameFromFDN ", "currentResult size " + (null == currentResult ? currentResult : Integer.valueOf(currentResult.size())) + " interfaceKey is end: " + interfaceKey);
            if (null == currentResult) continue;
            int size = currentResult.size();
            for (int i = 0; i < size; ++i) {
                resultMap.put(currentFDNList.get(i), currentResult.get(i));
            }
        }
        return resultMap;
    }

    private static Map<UMCommonSBIInterface, List<String>> groupFDNByProcess(List<String> fdnList) {
        HashMap<UMCommonSBIInterface, List<String>> interface2FDNListMap = new HashMap<UMCommonSBIInterface, List<String>>();
        StrUIDParser fdnParser = new StrUIDParser();
        UMCommonSBIInterface sbiInterface = null;
        HashMap sbiMap = UMUnitedMgrAdapter.getInstance().getSBInterfaceMap();
        ArrayList<String> currentFDNList = null;
        for (String fdn : fdnList) {
            ProcessInfo info;
            if (!fdnParser.parse(fdn)) {
                UMLogger.debug(U2kUnitedUtilities.class, "groupFDNByProcess", " fdn parse error, fdn ==" + fdn);
                continue;
            }
            int neID = (int)fdnParser.intValue("NE");
            if ("ONE".equals(UMFDNUtil.getMOC(fdn))) {
                neID = (int)fdnParser.intValue("ONE");
            }
            if ((info = ProxyFactory.getInstance().getDFWDataMgr().getNeMgrByNeID(neID)) == null) {
                UMLogger.debug(U2kUnitedUtilities.class, "groupFDNByProcess", "getSBIInterface(neID) is null neID ==" + neID);
                continue;
            }
            TEProcID procID = new TEProcID(info.getProcID(), info.getProcHandle());
            sbiInterface = (UMCommonSBIInterface)sbiMap.get(procID.getProcID());
            currentFDNList = (ArrayList<String>)interface2FDNListMap.get(sbiInterface);
            if (null == currentFDNList) {
                currentFDNList = new ArrayList<String>();
                currentFDNList.add(fdn);
                interface2FDNListMap.put(sbiInterface, currentFDNList);
                continue;
            }
            currentFDNList.add(fdn);
        }
        if (interface2FDNListMap.isEmpty()) {
            return null;
        }
        return interface2FDNListMap;
    }

    public static boolean isModuleInit(String moduleName) {
        BaseModule module = Main.instance().getModuleManager().getLocalModule(moduleName, false);
        if (module == null) {
            return false;
        }
        if (module instanceof AbstractProductBaseModule) {
            return ((AbstractProductBaseModule)module).isInitialized();
        }
        return false;
    }

    public static void getDecoderData(MSGPacketExt oMsg, FStruct oAsnObject) {
        try {
            byte[] oBytes = oMsg.getData();
            if (oBytes == null || oBytes.length == 0) {
                return;
            }
            FStruDecoder oDec = new FStruDecoder(oBytes);
            oAsnObject.deserialize((Decoder)oDec);
        }
        catch (Exception e) {
            UMLogger.exception(e);
        }
    }

    public static boolean isU2KNeTypeID(int neTypeID) {
        return neTypeID >= 65536 && neTypeID <= 65546 || neTypeID >= 131072 && neTypeID < 0x650000 || neTypeID >= 0x970000 && neTypeID < 0x1000000 || neTypeID >= 0x2010000 && neTypeID < 51707904 || neTypeID >= 51773440 && neTypeID < 0x8000000 || neTypeID >= 0x9000000 && neTypeID < 0xC000000;
    }

    public static boolean isU2KDevTypeID(String devTypeID) {
        if (null == devTypeID || devTypeID.isEmpty()) {
            return false;
        }
        if (devTypeID.trim().equals(M2000_DEVTYPE_ID)) {
            return false;
        }
        try {
            int iDevTypeID = Integer.valueOf(devTypeID.trim());
            return iDevTypeID >= 1 && iDevTypeID <= 100 || iDevTypeID >= 151 && iDevTypeID <= 255 || iDevTypeID >= 513 && iDevTypeID <= 788 || iDevTypeID >= 790 && iDevTypeID <= 3071 || iDevTypeID >= 5915 && iDevTypeID <= 5921;
        }
        catch (Exception ex) {
            UMLogger.exception(ex);
            UMLogger.debug(U2kUnitedUtilities.class, "isU2KDevTypeID", "devTypeID is :" + devTypeID);
            return true;
        }
    }

    public static boolean isThirdPartDevTypeID(String devTypeID) {
        if (null == devTypeID || devTypeID.isEmpty()) {
            return false;
        }
        if (devTypeID.trim().equals(M2000_DEVTYPE_ID)) {
            return false;
        }
        try {
            int iDevTypeID = Integer.valueOf(devTypeID.trim());
            return iDevTypeID == 256 || iDevTypeID == 257 || iDevTypeID == 258 || iDevTypeID == 789;
        }
        catch (Exception ex) {
            UMLogger.exception(ex);
            UMLogger.debug(U2kUnitedUtilities.class, "isThirdPartDevTypeID", "devTypeID is :" + devTypeID);
            return true;
        }
    }

    public static boolean hasCreateRight() {
        if (U2kCommonSecurityUtil.isAdmin()) {
            return true;
        }
        String topoNEClassName = "TopoAPP";
        RightInfo deleteRightInfo = new RightInfo("APPLICATION", topoNEClassName, "", "Create_Ne");
        boolean[] deleteRight = null;
        try {
            deleteRight = AuthorizationService.getInstance().checkRight(new RightInfo[]{deleteRightInfo});
        }
        catch (Exception ex) {
            UMLogger.exception(ex);
        }
        UMLogger.debug(U2kUnitedUtilities.class, "hasCreateRight", "hasDeleteNeRight : " + Arrays.toString(deleteRight));
        if (null != deleteRight && deleteRight.length > 0) {
            return deleteRight[0];
        }
        return true;
    }

    public static CommStyleParser getCommStyleParser() {
        Plugin plugin = PluginManager.getInstance().getPlugin("unitedmgr");
        if (null == plugin) {
            UMLogger.debug(U2kUnitedUtilities.class, " getCommStyleParser() ", " plugin is null.");
            return null;
        }
        return plugin.getCommStyleParser();
    }

    public static UMCommonSBIInterface getSbiInf(int iNeID) {
        UMUnitedMgrModule mgrModule = (UMUnitedMgrModule)U2kModuleManagerFactory.getModule("united_common");
        if (null == mgrModule) {
            UMLogger.debug(U2kUnitedUtilities.class, " getSbiInf ", " mgrModule is null,  iNeID is: " + iNeID);
            return null;
        }
        UMCommonSBIInterface sbiInterface = mgrModule.getSBIInterface(iNeID);
        if (null == sbiInterface) {
            UMLogger.debug(U2kUnitedUtilities.class, " getSbiInf ", " sbiInterface is null,  iNeID is: " + iNeID);
        }
        return sbiInterface;
    }

    public static TEProcID getTEProcID(int neID, String errorInfo) {
        ProcessInfo info = CommonDataMgr.getInstance().getNeProcIDByNeID(neID, errorInfo);
        if (info == null) {
            return null;
        }
        TEProcID procID = new TEProcID(info.getProcID(), info.getProcHandle());
        return procID;
    }

    public static int allocmissionID() {
        return ProgressBarMgr._instance((INEProxyService)ProxyFactory.getInstance().getNEProxy()).allocMissionID();
    }

    public static void showInternalDlg(final BaseInternalDialog dialog) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                dialog.setVisible(true);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        dialog.setVisible(true);
                    }
                });
            }
        }
        catch (Exception e) {
            UMLogger.exception(e);
        }
    }

    public static void showJDialog(final Dialog dialog) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                dialog.setVisible(true);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        dialog.setVisible(true);
                    }
                });
            }
        }
        catch (Exception e) {
            UMLogger.exception(e);
        }
    }

    public static boolean isONE(int idevID) {
        return idevID >= 0x3E0000 && idevID <= 0x3F7FFF;
    }

    public static Map<Integer, List<UMNeInfo>> getOneShelfInfo(List<Integer> oneIDList) {
        if (null == oneIDList || oneIDList.isEmpty()) {
            UMLogger.debug("getOneShelfInfo , oneIDList is null ");
            return null;
        }
        int[] oneID = new int[oneIDList.size()];
        int iSize = oneIDList.size();
        for (int i = 0; i < iSize; ++i) {
            oneID[i] = oneIDList.get(i);
        }
        UMInventoryModule invModule = (UMInventoryModule)U2kModuleManagerFactory.getTEModule("inventoryModule");
        if (null == invModule) {
            UMLogger.debug("getOneShelfInfo , invModule is null ");
            return null;
        }
        List oneInterLst = invModule.getOneInfList();
        if (null == oneInterLst || oneInterLst.isEmpty()) {
            UMLogger.debug("getOneShelfInfo , oneInterLst is null ");
            return null;
        }
        UMLogger.debug(U2kUnitedUtilities.class, " getOneShelfInfo ", " oneID : " + Arrays.toString(oneID));
        if (1 == oneInterLst.size()) {
            return ((UMOneInf)oneInterLst.get(0)).getOneChildren(oneID);
        }
        HashMap<Integer, List<UMNeInfo>> oneInfoLst = new HashMap<Integer, List<UMNeInfo>>();
        Map<Integer, List<UMNeInfo>> oneInfoLstTmp = null;
        for (UMOneInf oneInter : oneInterLst) {
            oneInfoLstTmp = oneInter.getOneChildren(oneID);
            if (null == oneInfoLstTmp || oneInfoLstTmp.isEmpty()) continue;
            oneInfoLst.putAll(oneInfoLstTmp);
        }
        return oneInfoLst;
    }
}

