/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.util;

import com.huawei.imap12.topo.InmTopoUtil;
import com.huawei.u2000.inf.UMCommonSBIInterface;
import com.huawei.u2000.inventory.common.util.UMInventoryUtils;
import com.huawei.u2000.unitedmgr.UMUnitedMgrModule;
import com.huawei.u2000.util.U2kModuleManagerFactory;
import com.huawei.u2000.util.UMLogger;
import com.swimap.external.topo.adapter.message.EmfTopoContainerInfo;
import com.swimap.external.topo.adapter.message.EmfTopoInterface;
import com.swimap.external.topo.adapter.message.EmfTopoObjectInfo;
import com.swimap.external.topo.adapter.message.EmfTopoSubmapInfo;
import com.swimap.external.topo.adapter.message.EmfTopoViewInfo;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class UMTopoSubnetUtil {
    private static Map<String, EmfTopoSubmapInfo> submapInfoMap;
    private static Map<Integer, EmfTopoContainerInfo> containerMapInfo;
    static boolean reQuery;

    private UMTopoSubnetUtil() {
    }

    public static String getNeSubMap(int neID) {
        List<EmfTopoSubmapInfo> submapList;
        String moduleName = "united_common";
        UMUnitedMgrModule mgrModule = (UMUnitedMgrModule)U2kModuleManagerFactory.getModule(moduleName);
        UMCommonSBIInterface sbiInf = mgrModule.getSBIInterface(neID);
        StringBuffer subMapStringBuffer = new StringBuffer();
        if (null != sbiInf && null != (submapList = sbiInf.getSubmapList(neID))) {
            int size = submapList.size();
            for (int i = 0; i < size; ++i) {
                EmfTopoSubmapInfo submapInfo = submapList.get(i);
                if (null == submapInfo) continue;
                UMTopoSubnetUtil.recursionSubMap(submapInfo, subMapStringBuffer);
            }
            String string = subMapStringBuffer.toString();
            UMLogger.debug("[Submap] from SBI:" + string);
            return UMInventoryUtils.replaceString((String)string);
        }
        UMTopoSubnetUtil.getNeSubMapStrForTopo(neID, subMapStringBuffer);
        return UMInventoryUtils.replaceString((String)subMapStringBuffer.toString());
    }

    public static void recursionSubMap(EmfTopoSubmapInfo submapInfo, StringBuffer subMapStringBuffer) {
        Stack<String> infos = new Stack<String>();
        UMTopoSubnetUtil.getRecursionSubMapInfo(submapInfo, infos);
        int size = infos.size();
        for (int i = 0; i < size; ++i) {
            subMapStringBuffer.append(infos.pop());
            if (i != size - 1) {
                subMapStringBuffer.append('\\');
            }
            if (infos.empty()) break;
        }
    }

    public static void getRecursionSubMapInfo(EmfTopoSubmapInfo submapInfo, Stack<String> infos) {
        infos.push(submapInfo.m_szLabel);
        if (!submapInfo.m_szParentID.equals(submapInfo.m_szID)) {
            EmfTopoSubmapInfo parent = InmTopoUtil.getTopoSubmapInfo((String)submapInfo.m_szParentID);
            UMTopoSubnetUtil.getRecursionSubMapInfo(parent, infos);
        }
    }

    private static String getNeSubMapStrForTopo(int neID, StringBuffer subMapStringBuffer) {
        List<Object> topoObjectInfoList = InmTopoUtil.getTopoElementInfo((String)String.valueOf(neID));
        if (null == topoObjectInfoList) {
            topoObjectInfoList = UMTopoSubnetUtil.getTopoContainerInfo(neID);
        }
        StringBuffer sb = new StringBuffer();
        if (null != topoObjectInfoList) {
            int size = topoObjectInfoList.size();
            for (int i = 0; i < size; ++i) {
                EmfTopoObjectInfo nodeInfo = (EmfTopoObjectInfo)topoObjectInfoList.get(i);
                if (null != nodeInfo) {
                    EmfTopoSubmapInfo topoSubmapInfo = InmTopoUtil.getTopoSubmapInfo((String)nodeInfo.m_szParentID);
                    UMTopoSubnetUtil.recursionSubMap(topoSubmapInfo, subMapStringBuffer);
                    if (i == size - 1) continue;
                    subMapStringBuffer.append("; ");
                    continue;
                }
                UMLogger.debug("the submap list containts null!");
            }
        }
        return sb.toString();
    }

    public static List<EmfTopoObjectInfo> getTopoContainerInfo(int neID) {
        Map<Integer, EmfTopoContainerInfo> infos = UMTopoSubnetUtil.getAllContainerInfo();
        ArrayList<EmfTopoObjectInfo> returnValue = new ArrayList<EmfTopoObjectInfo>();
        if (infos.containsKey(neID)) {
            returnValue.add((EmfTopoObjectInfo)infos.get(neID));
        }
        return returnValue;
    }

    public static synchronized Map<Integer, EmfTopoContainerInfo> getAllContainerInfo() {
        if (null == containerMapInfo || reQuery) {
            containerMapInfo = new HashMap<Integer, EmfTopoContainerInfo>();
            List views = InmTopoUtil.getTopoInterface().getAllView();
            for (EmfTopoViewInfo view : views) {
                LinkedList list = InmTopoUtil.getTopoInterface().getAllObjectInView(view.m_szID, 2);
                for (EmfTopoObjectInfo info : list) {
                    if (!(info instanceof EmfTopoContainerInfo)) continue;
                    EmfTopoContainerInfo node = (EmfTopoContainerInfo)info;
                    containerMapInfo.put(node.m_iDevID, node);
                }
            }
            reQuery = false;
        }
        return containerMapInfo;
    }

    public static void clearContainerInfo() {
        if (null != containerMapInfo) {
            containerMapInfo.clear();
            containerMapInfo = null;
        }
    }

    public static void expandAll(JTree tree, boolean expand) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        UMTopoSubnetUtil.expandAll(tree, new TreePath(root), expand);
    }

    private static void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                UMTopoSubnetUtil.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public static DefaultTreeModel getPhySubmapModel() {
        EmfTopoInterface topoInterface = InmTopoUtil.getTopoInterface();
        return topoInterface.getPhyicalSubmapTreeModel();
    }

    public static synchronized Map<String, EmfTopoSubmapInfo> getSubmapNameMap() {
        return UMTopoSubnetUtil.getSubmapInfoMap();
    }

    public static void clearSubmap() {
        if (null != submapInfoMap) {
            submapInfoMap.clear();
            submapInfoMap = null;
        }
    }

    public static void getFullPath(EmfTopoSubmapInfo submap, List<String> sb) {
        if (null == sb || null == submap) {
            return;
        }
        if (null != submap.m_szParentID && !submap.m_szID.equals(submap.m_szParentID)) {
            sb.add(" / ");
            sb.add(UMTopoSubnetUtil.getSubmapNameMap().get((Object)submap.m_szParentID).m_szLabel);
            UMTopoSubnetUtil.getFullPath(UMTopoSubnetUtil.getSubmapNameMap().get(submap.m_szParentID), sb);
        }
    }

    public static String getFullPath(EmfTopoSubmapInfo submap) {
        if (null == submap) {
            return "";
        }
        LinkedList<String> nameList = new LinkedList<String>();
        nameList.add(submap.m_szLabel);
        UMTopoSubnetUtil.getFullPath(submap, nameList);
        StringBuffer nameSB = new StringBuffer();
        for (int i = nameList.size() - 1; i >= 0; --i) {
            nameSB.append((String)nameList.get(i));
        }
        return nameSB.toString();
    }

    public static synchronized Map<String, EmfTopoSubmapInfo> getSubmapInfoMap() {
        if (null == submapInfoMap || submapInfoMap.isEmpty()) {
            UMTopoSubnetUtil.initSubmapInfoMap();
        }
        return submapInfoMap;
    }

    public static synchronized void initSubmapInfoMap() {
        if (null != submapInfoMap && !submapInfoMap.isEmpty()) {
            submapInfoMap.clear();
        }
        submapInfoMap = new HashMap<String, EmfTopoSubmapInfo>();
        List<EmfTopoSubmapInfo> submapInfoLst = UMTopoSubnetUtil.getAllSubmap();
        for (EmfTopoSubmapInfo topoSubmapInfo : submapInfoLst) {
            if (null == topoSubmapInfo) continue;
            submapInfoMap.put(topoSubmapInfo.m_szID, topoSubmapInfo);
        }
    }

    private static List<EmfTopoSubmapInfo> getAllSubmap() {
        ArrayList<EmfTopoSubmapInfo> submapInfoLst = new ArrayList<EmfTopoSubmapInfo>();
        EmfTopoInterface topo = InmTopoUtil.getTopoInterface();
        List viewListInfos = topo.getAllView();
        int length = viewListInfos.size();
        for (int i = 0; i < length; ++i) {
            submapInfoLst.addAll(topo.getAllObjectInView(((EmfTopoViewInfo)viewListInfos.get((int)i)).m_szID, 2));
        }
        return submapInfoLst;
    }

    public static void getNeFullPath(EmfTopoSubmapInfo submap, List<String> sb) {
        if (null == sb || null == submap) {
            return;
        }
        if (null != submap.m_szParentID && !submap.m_szID.equals(submap.m_szParentID)) {
            sb.add(" / ");
            sb.add(UMTopoSubnetUtil.getSubmapInfoMap().get((Object)submap.m_szParentID).m_szLabel);
            UMTopoSubnetUtil.getNeFullPath(UMTopoSubnetUtil.getSubmapInfoMap().get(submap.m_szParentID), sb);
        }
    }

    public static String getNeFullPath(EmfTopoSubmapInfo submap) {
        if (null == submap) {
            return "";
        }
        LinkedList<String> nameList = new LinkedList<String>();
        nameList.add(submap.m_szLabel);
        UMTopoSubnetUtil.getNeFullPath(submap, nameList);
        StringBuffer nameSB = new StringBuffer();
        for (int i = nameList.size() - 1; i >= 0; --i) {
            nameSB.append((String)nameList.get(i));
        }
        return nameSB.toString();
    }

    public static String getFullPath(String submapID) {
        return UMTopoSubnetUtil.getNeFullPath(UMTopoSubnetUtil.getSubmapInfoMap().get(submapID));
    }

    static {
        reQuery = false;
    }
}

