/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class UMTimerTextField
extends JTextField {
    private int delay = 1000;
    private Timer timer = null;
    private Vector m_ignoreKeys = new Vector();
    private TextFieldKeyListener m_keyListener = new TextFieldKeyListener();
    private TextFieldDocumentListener m_docListener = new TextFieldDocumentListener();
    static final int TEXTFUNCTION = 1;
    static final int KEYFUNCTION = 2;
    private int functionType = 1;

    public UMTimerTextField() {
        this("");
    }

    public UMTimerTextField(String str) {
        super(str);
        this.timer = new Timer(this.delay, new DefaultTimerListener());
        this.timer.setRepeats(false);
        this.setListenerFunction(1);
    }

    public UMTimerTextField(String str, int delayTime) {
        super(str);
        this.delay = delayTime;
        this.timer = new Timer(this.delay, new DefaultTimerListener());
        this.timer.setRepeats(false);
        this.setListenerFunction(1);
    }

    public void setListenerFunction(int fun) {
        if (fun == 1) {
            super.removeKeyListener(this.m_keyListener);
            this.getDocument().addDocumentListener(this.m_docListener);
        } else if (fun == 2) {
            this.getDocument().removeDocumentListener(this.m_docListener);
            super.addKeyListener(this.m_keyListener);
        }
        this.functionType = fun;
    }

    public void setActionDelay(int delay) {
        if (delay > 100) {
            this.delay = delay;
        }
    }

    public void setIgnoreKey(Vector vector) {
        if (vector != null) {
            this.m_ignoreKeys.addAll(vector);
        }
    }

    public void addTimerListener(ActionListener listener) {
        this.setListenerFunction(this.functionType);
        if (!this.isExistEqual(listener)) {
            this.timer.addActionListener(listener);
        }
    }

    private boolean isExistEqual(ActionListener listener) {
        ActionListener[] listeners;
        boolean flag = false;
        for (ActionListener l : listeners = this.timer.getActionListeners()) {
            if (listener != l) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public void removeTimerListener(ActionListener listener) {
        this.setListenerFunction(this.functionType);
        this.timer.removeActionListener(listener);
    }

    @Override
    public void setDocument(Document doc) {
        if (this.m_docListener != null) {
            this.getDocument().removeDocumentListener(this.m_docListener);
        }
        super.setDocument(doc);
        if (this.functionType == 1 && this.m_docListener != null) {
            doc.addDocumentListener(this.m_docListener);
        }
    }

    private class TextFieldDocumentListener
    implements DocumentListener {
        private TextFieldDocumentListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            UMTimerTextField.this.timer.restart();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            UMTimerTextField.this.timer.restart();
        }
    }

    private class TextFieldKeyListener
    implements KeyListener {
        private TextFieldKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (!UMTimerTextField.this.m_ignoreKeys.contains(e.getKeyCode())) {
                UMTimerTextField.this.timer.stop();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (!UMTimerTextField.this.m_ignoreKeys.contains(e.getKeyCode()) && UMTimerTextField.this.timer != null) {
                UMTimerTextField.this.timer.start();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    private class DefaultTimerListener
    implements ActionListener {
        private DefaultTimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

