/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.util;

import com.huawei.u2000.util.U2kUnitedUtilities;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class UMPathDocument
extends PlainDocument {
    private static final long serialVersionUID = -32911773092840485L;
    public boolean isOnlySupportUSChar = false;
    public int iLength = -1;

    public UMPathDocument() {
    }

    public UMPathDocument(boolean isOnlySupportUSChar, int iLength) {
        this.isOnlySupportUSChar = isOnlySupportUSChar;
        this.iLength = iLength;
    }

    @Override
    public synchronized void insertString(int offs, String str, AttributeSet attributeSet) throws BadLocationException {
        String oldPath = this.getText(0, this.getLength());
        String newPath = this.getNewPath(oldPath, offs, str);
        if (this.isCanInput(newPath)) {
            super.insertString(offs, str, attributeSet);
        }
    }

    private String getNewPath(String oldPath, int offs, String insertString) {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append(oldPath.substring(0, offs));
        strBuffer.append(insertString);
        strBuffer.append(oldPath.substring(offs, oldPath.length()));
        return strBuffer.toString();
    }

    private boolean isCanInput(String v) {
        boolean flag = true;
        if (this.isOnlySupportUSChar) {
            if (!U2kUnitedUtilities.isNull(v) && !U2kUnitedUtilities.charPathFormatIscorrect(v)) {
                flag = false;
            }
        } else if (!U2kUnitedUtilities.isNull(v) && !U2kUnitedUtilities.pathFormatIscorrect(v)) {
            flag = false;
        }
        if (this.iLength > 0 && null != v && v.length() > this.iLength) {
            flag = false;
        }
        return flag;
    }

    private List<String> getSpecialString() {
        ArrayList<String> val = new ArrayList<String>();
        val.add("\\");
        val.add("/");
        val.add(":");
        return val;
    }
}

