/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.util;

import com.huawei.u2000.util.U2kModuleManagerFactory;
import com.huawei.u2000.util.UMLogger;
import com.swimap.external.eam.client.EamClientInterface;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import javax.swing.ImageIcon;

public class UMImageUtil {
    public static final int NUM_32 = 32;
    public static final int NUM_18 = 18;
    public static final int NUM_15 = 15;
    public static final int COLOR_PERCENT = 100;

    public static ImageIcon getImageIconWithState(ImageIcon objIcon, ImageIcon stateIcon, Color backGroundColor) {
        BufferedImage bufImage = new BufferedImage(32, 18, 1);
        Graphics2D bufImageGraphic = (Graphics2D)bufImage.getGraphics();
        bufImageGraphic.setColor(backGroundColor);
        bufImageGraphic.fillRect(0, 0, 32, 18);
        if (objIcon == null) {
            EamClientInterface eamInf = (EamClientInterface)U2kModuleManagerFactory.getModule("eam");
            if (null == eamInf) {
                UMLogger.debug(UMImageUtil.class, " getImageIconWithState ", " eam if is null. ");
                return new ImageIcon();
            }
            objIcon = eamInf.getEamResourceManagerIf().getUnknowTypeImageIcon();
        }
        bufImageGraphic.drawImage(objIcon.getImage(), 15, 1, objIcon.getIconWidth(), objIcon.getIconHeight(), backGroundColor, null);
        if (stateIcon != null) {
            bufImageGraphic.drawImage(stateIcon.getImage(), 0, 6, stateIcon.getIconWidth(), stateIcon.getIconHeight(), null, null);
        }
        bufImage.flush();
        return new ImageIcon(bufImage);
    }

    public static ImageIcon createIconWithColor(ImageIcon sourceIcon, Color color) {
        EamClientInterface eamInf = (EamClientInterface)U2kModuleManagerFactory.getModule("eam");
        if (null == eamInf) {
            UMLogger.debug(UMImageUtil.class, " getImageIconWithState ", " eam if is null. ");
            return new ImageIcon();
        }
        ImageFilter imageFilter = (ImageFilter)eamInf.getColorSharpenTool(true, 100, 10.0, color);
        FilteredImageSource imageProducer = new FilteredImageSource(sourceIcon.getImage().getSource(), imageFilter);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image imageWithAlarm = toolkit.createImage(imageProducer);
        return new ImageIcon(imageWithAlarm);
    }
}

