/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.util;

import com.huawei.u2000.umcommon.util.IUMDeviceChangeObserver;
import com.huawei.u2000.util.UMLogger;
import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.RpcServerPush;
import com.swimap.external.dsf.base.rpc.RpcServerPushHandler;
import java.util.ArrayList;
import java.util.List;

public class UMDeviceChangeNotifier
implements RpcServerPushHandler {
    private List<IUMDeviceChangeObserver> observerList = new ArrayList<IUMDeviceChangeObserver>();
    private boolean hasOpen = false;
    private static UMDeviceChangeNotifier instance = null;

    private UMDeviceChangeNotifier() {
    }

    public static UMDeviceChangeNotifier getInstance() {
        if (null == instance) {
            instance = new UMDeviceChangeNotifier();
        }
        return instance;
    }

    public void handleServerPush(RpcEvent event) {
        try {
            RpcMessage msg = event.getMessage();
            String eventType = msg.getString("eventtype");
            UMLogger.debug("UMObjRpcSeverPushHandler receive event type : " + eventType);
            int size = this.observerList.size();
            for (int i = 0; i < size; ++i) {
                this.observerList.get(i).notify(event);
            }
        }
        catch (Exception e) {
            UMLogger.debug("process modify attribute error");
        }
    }

    public void registerObserver(IUMDeviceChangeObserver noticer) {
        if (!this.hasOpen) {
            this.open();
        }
        this.observerList.add(noticer);
    }

    public void open() {
        if (!this.hasOpen) {
            UMLogger.debug("(UMObjRpcSeverPushHandler)opened.");
            RpcServerPush.addHandler((String)"eam.ds.event", (RpcServerPushHandler)this);
            this.hasOpen = true;
        }
    }

    public void close() {
        if (this.hasOpen) {
            UMLogger.debug("(UMObjRpcSeverPushHandler)closed.");
            RpcServerPush.removeHandler((RpcServerPushHandler)this);
            this.hasOpen = false;
        }
    }

    public List<IUMDeviceChangeObserver> getObserverList() {
        return this.observerList;
    }

    public void unregisterObserver(IUMDeviceChangeObserver observer) {
        this.observerList.remove(observer);
    }

    public void clearObservers() {
        this.observerList.clear();
        this.close();
    }
}

