/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.util;

import com.huawei.u2000.umcommon.util.UMTopoSubnetUtil;
import com.swimap.external.topo.adapter.message.EmfTopoNaviTreeNodeIf;
import com.swimap.external.topo.adapter.message.EmfTopoSubmapInfo;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class InvisibleNode
extends DefaultMutableTreeNode
implements Comparable<InvisibleNode> {
    protected boolean isVisible;
    private EmfTopoNaviTreeNodeIf node;
    private boolean isRightTree = false;
    private boolean isExist;

    public InvisibleNode() {
        this(null);
    }

    public InvisibleNode(Object userObject) {
        this(userObject, true, true);
    }

    public InvisibleNode(EmfTopoNaviTreeNodeIf node) {
        this.node = node;
        this.isVisible = true;
    }

    public InvisibleNode(Object userObject, boolean allowsChildren, boolean isVisible) {
        super(userObject, allowsChildren);
        this.isVisible = isVisible;
    }

    public EmfTopoNaviTreeNodeIf getNode() {
        return this.node;
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }
        int realIndex = -1;
        int visibleIndex = -1;
        Enumeration enums = this.children.elements();
        while (enums.hasMoreElements()) {
            InvisibleNode node = (InvisibleNode)enums.nextElement();
            if (node.isVisible()) {
                ++visibleIndex;
            }
            ++realIndex;
            if (visibleIndex != index) continue;
            return (TreeNode)this.children.elementAt(realIndex);
        }
        throw new ArrayIndexOutOfBoundsException("index unmatched");
    }

    @Override
    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        int count = 0;
        Enumeration enums = this.children.elements();
        while (enums.hasMoreElements()) {
            InvisibleNode node = (InvisibleNode)enums.nextElement();
            if (!node.isVisible()) continue;
            ++count;
        }
        return count;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean isExist() {
        return this.isExist;
    }

    public void setExist(boolean isExist) {
        this.isExist = isExist;
    }

    @Override
    public String toString() {
        if (this.isRightTree) {
            EmfTopoSubmapInfo submap = (EmfTopoSubmapInfo)this.node.getNaviTreeNodeInfo();
            return UMTopoSubnetUtil.getFullPath(submap);
        }
        return super.toString();
    }

    public boolean isRightTree() {
        return this.isRightTree;
    }

    public void setRightTree(boolean isRightTree) {
        this.isRightTree = isRightTree;
    }

    public boolean equals(Object obj) {
        InvisibleNode newObj;
        if (obj instanceof InvisibleNode && null != (newObj = (InvisibleNode)obj).getNode() && null != this.getNode()) {
            return newObj.getNode().getNaviTreeNodeInfo().m_szID.equals(this.getNode().getNaviTreeNodeInfo().m_szID);
        }
        return false;
    }

    public int hashCode() {
        if (null == this.getNode()) {
            return super.hashCode();
        }
        return this.getNode().getNaviTreeNodeInfo().m_szID.hashCode();
    }

    @Override
    public int compareTo(InvisibleNode obj) {
        if (null == this.node) {
            return -1;
        }
        if (null == obj.getNode()) {
            return 1;
        }
        return this.node.toString().compareTo(obj.getNode().toString());
    }
}

