/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.topo;

import com.huawei.core.util.TEResourceUtil;
import com.huawei.imap12.topo.InmTopoUtil;
import com.huawei.u2000.basetool.UMFrameAppAdapter;
import com.huawei.u2000.util.U2kUnitedUtilities;
import com.huawei.u2000.util.UMLogger;
import com.swimap.external.resource.client.emf.EmfTopoDeviceType;
import com.swimap.external.resource.client.emf.EmfTopoElementIf;
import com.swimap.external.topo.adapter.message.EmfTopoContainerInfo;
import com.swimap.external.topo.adapter.message.EmfTopoInterface;
import com.swimap.external.topo.adapter.message.EmfTopoNodeInfo;
import com.swimap.external.topo.adapter.message.EmfTopoObjToolTipIf;
import java.util.LinkedList;

public class TopoTipsMgr
implements EmfTopoObjToolTipIf {
    private static final String SOURCE_STRING_FILE = "u2000/topo/resources/stringresource.ini";
    public static final TEResourceUtil res = TEResourceUtil.getInstance((String)"u2000/topo/resources/stringresource.ini");
    private static final String REGULAR_IP_ADDRESS = "(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)";

    private String[] getDevVersionName(String m_szDevType, String m_szDevVer) {
        LinkedList allDevType = U2kUnitedUtilities.getAllDecType();
        if (allDevType == null) {
            EmfTopoInterface topoInterface = (EmfTopoInterface)UMFrameAppAdapter.getInstance().getLocalModule("com.swimap.adapter.message.tm");
            allDevType = topoInterface.getAllDevType();
        }
        int j = allDevType.size();
        for (int i = 0; i < j; ++i) {
            Object devTypeObj = allDevType.get(i);
            if (!(devTypeObj instanceof EmfTopoDeviceType)) continue;
            EmfTopoDeviceType devType = (EmfTopoDeviceType)devTypeObj;
            if (!String.valueOf(devType.m_iDevTypeID).equals(m_szDevType) || !m_szDevVer.equals(String.valueOf(devType.m_iDevVersionID))) continue;
            return new String[]{devType.m_szDevTypeName, devType.m_szDevVersionName};
        }
        return new String[]{"", ""};
    }

    public String createToolTip(EmfTopoElementIf topoElement) {
        try {
            StringBuilder result = new StringBuilder();
            if (topoElement instanceof EmfTopoNodeInfo) {
                EmfTopoNodeInfo topoNode = (EmfTopoNodeInfo)topoElement;
                String phyViewID = InmTopoUtil.getTopoInterface().getBaseViewID();
                if (!phyViewID.equals(topoNode.m_szViewID)) {
                    return null;
                }
                if (!U2kUnitedUtilities.isU2KDevTypeID(topoNode.m_szDevType) && !U2kUnitedUtilities.isThirdPartDevTypeID(topoNode.m_szDevType)) {
                    return null;
                }
                String[] devVerAndDevTypeName = this.getDevVersionName(topoNode.getDevType(), topoNode.getDevVer());
                result.append(res.getString("view.tooltip.typeTitle"));
                result.append(":[");
                result.append(devVerAndDevTypeName[0]);
                result.append("]");
                if (devVerAndDevTypeName[1].length() > 1 && !devVerAndDevTypeName[0].equals(devVerAndDevTypeName[1])) {
                    result.append(System.getProperty("line.separator"));
                    result.append(res.getString("view.tooltip.version"));
                    result.append(":[");
                    result.append(devVerAndDevTypeName[1]);
                    result.append("]");
                }
                if (topoNode.m_szIP.matches(REGULAR_IP_ADDRESS)) {
                    result.append(System.getProperty("line.separator"));
                    result.append(res.getString("objectNEAddress"));
                    result.append(":[");
                    result.append(topoNode.m_szIP);
                    result.append("]");
                }
                return result.toString();
            }
            if (topoElement instanceof EmfTopoContainerInfo) {
                EmfTopoContainerInfo topoNode = (EmfTopoContainerInfo)topoElement;
                String phyViewID = InmTopoUtil.getTopoInterface().getBaseViewID();
                if (!phyViewID.equals(topoNode.m_szViewID)) {
                    return null;
                }
                if (!U2kUnitedUtilities.isU2KDevTypeID(topoNode.m_szDevType) && !U2kUnitedUtilities.isThirdPartDevTypeID(topoNode.m_szDevType)) {
                    return null;
                }
                String[] devVerAndDevTypeName = this.getDevVersionName(topoNode.getDevType(), topoNode.getDevVer());
                result.append(res.getString("view.tooltip.typeTitle"));
                result.append(":[");
                result.append(devVerAndDevTypeName[0]);
                result.append("]");
                result.append(System.getProperty("line.separator"));
                result.append(res.getString("view.tooltip.version"));
                result.append(":[");
                result.append(devVerAndDevTypeName[1]);
                result.append("]");
                if (topoNode.m_szIP.matches(REGULAR_IP_ADDRESS)) {
                    result.append(System.getProperty("line.separator"));
                    result.append(res.getString("objectNEAddress"));
                    result.append(":[");
                    result.append(topoNode.m_szIP);
                    result.append("]");
                }
                return result.toString();
            }
            return null;
        }
        catch (Exception e) {
            UMLogger.exception(e);
            return null;
        }
    }
}

