/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.topo;

import com.huawei.u2000.umcommon.topo.TNNE;
import com.huawei.u2000.umcommon.topo.TNTopoInterface;
import com.huawei.u2000.umcommon.topo.TNTopoObj;
import com.huawei.u2000.util.UMLogger;
import com.swimap.external.topo.adapter.message.EmfTopoLinkInfo;
import java.util.ArrayList;
import java.util.List;

public class TNLink
extends TNTopoObj {
    public String srcNodeId;
    public String destNodeId;
    public int linkType;
    public int activeState;
    public String label;
    static final String NMS_EMS_LINK_TAG = "2000000";
    private final String comment;
    private final String leftPortID;
    private final String rightPortID;

    public TNLink(EmfTopoLinkInfo linkInfo) {
        this.id = linkInfo.m_szID;
        this.srcNodeId = linkInfo.m_szLeftObjID;
        this.destNodeId = linkInfo.m_szRightObjID;
        this.linkType = linkInfo.m_iType;
        this.entityId = TNLink.isFiberLink(this.linkType) || 5636 == linkInfo.m_iClass ? TNLink.parseFiberID(linkInfo.m_szID) : TNLink.parseEntityID(linkInfo.m_szID);
        this.activeState = linkInfo.m_iStatus;
        this.label = linkInfo.m_szLabel;
        this.comment = linkInfo.m_szComment;
        this.leftPortID = linkInfo.getLeftObjID();
        this.rightPortID = linkInfo.getRightObjID();
    }

    public String getComment() {
        return this.comment;
    }

    public String getLeftPortID() {
        return this.leftPortID;
    }

    public String getRightPortID() {
        return this.rightPortID;
    }

    public int getLinkID() {
        try {
            return Integer.parseInt(this.entityId);
        }
        catch (Exception e) {
            UMLogger.exception(e);
            return -1;
        }
    }

    public int getSrcID() {
        return TNNE.parseNEID(this.srcNodeId);
    }

    public int getDstID() {
        return TNNE.parseNEID(this.destNodeId);
    }

    public int getLinkType() {
        return this.linkType;
    }

    public static int isIDValid(String id) {
        if (id.matches("-?[0-9]+:-?[0-9]+:-?[0-9]+")) {
            return 3;
        }
        if (id.matches("-?[0-9]+:-?[0-9]+")) {
            return 2;
        }
        if (id.matches("-?[0-9]+")) {
            return 1;
        }
        return -1;
    }

    public static String parseEntityID(String id) {
        int idPattern = TNLink.isIDValid(id);
        if (idPattern < 2) {
            return id;
        }
        return id.split(":")[0];
    }

    public static String parseFiberID(String id) {
        int idPattern = TNLink.isIDValid(id);
        if (idPattern < 2) {
            return id;
        }
        return id.split(":")[1];
    }

    public static String parseFiberTopoObjID(int fiberID) {
        return "310:" + fiberID;
    }

    public static String parseProtectTopoObjID(int psnID, int linkID, int linkNum) {
        StringBuffer result = new StringBuffer();
        result.append(psnID);
        result.append(":");
        result.append(linkID);
        result.append(":");
        result.append(linkNum);
        return result.toString();
    }

    public static List<String> getProtectAllLinkIDs(String linkID) {
        if (TNLink.isIDValid(linkID) != 3) {
            return new ArrayList<String>(0);
        }
        String[] aLink = linkID.split(":");
        int psnID = Integer.parseInt(aLink[0]);
        int linkNum = Integer.parseInt(aLink[2]);
        ArrayList<String> result = new ArrayList<String>(linkNum);
        for (int i = 0; i < linkNum; ++i) {
            result.add(TNLink.parseProtectTopoObjID(psnID, i + 1, linkNum));
        }
        return result;
    }

    public static String parseCircuitTopoObjID(int level, int srcNEID, int snkNEID) {
        StringBuffer result = new StringBuffer();
        result.append(level);
        result.append(":");
        result.append(srcNEID);
        result.append(":");
        result.append(snkNEID);
        return result.toString();
    }

    public boolean isLegal() {
        return this.id != null && this.srcNodeId != null && this.destNodeId != null;
    }

    public static boolean isFiberLink(int linkID) {
        return 310 == linkID || 311 == linkID || 312 == linkID || 313 == linkID;
    }

    public static boolean isTrailLink(int type) {
        return type >= 4097 && type <= 4928 || type == 5633 || type == 16385 || type >= 12289 && type <= 12342 || type == 36865;
    }

    public static boolean isSupportQueryTrail(int type) {
        return type >= 4097 && type <= 5635 && type != 5633 || type >= 12289 && type <= 12342 || type == 36865 || type == 16385;
    }

    public static boolean isProtect1toNLink(int type) {
        return type == 12800;
    }

    public static boolean isProtectODUKLink(int type) {
        return type == 12801;
    }

    public static boolean isProtectLink(int type) {
        return type >= 7681 && type <= 7689 || type == 12800 || type == 12801 || type == 7690 || type == 7691;
    }

    public static boolean isSDHProtectLink(int type) {
        return type >= 7681 && type <= 7689;
    }

    public static boolean isRTNProtectLink(int type) {
        return type == 7690 || type == 7691;
    }

    public static boolean isRingProtect(int type) {
        return type >= 7681 && type <= 7685 || type == 7688;
    }

    public static boolean isMSProtect(int type) {
        return type == 7682 || type == 7681 || type == 7683 || type == 7686 || type == 7687;
    }

    public static boolean isVisibleAtTopo(int type) {
        int[] link = TNTopoInterface.getVisibleLinkLayers();
        for (int i = 0; i < link.length; ++i) {
            if (link[i] != type) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.id + ", " + this.srcNodeId + ", " + this.destNodeId + this.linkType + this.activeState;
    }

    @Override
    public String getName() {
        return this.label;
    }
}

