/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.security;

import com.huawei.u2000.basetool.UMFrameAppAdapter;
import com.huawei.u2000.util.UMLogger;
import com.swimap.external.sm.adapter.message.EmfSecurityInterface;

public class U2kCommonSecurityUtil {
    public static final int TYPE_NE = 1;
    private static final int INT_INVALID = -1;
    private static final String STR_INVALID = "";
    private static EmfSecurityInterface secInf = null;

    private static final EmfSecurityInterface getSecurityInterface() {
        return (EmfSecurityInterface)UMFrameAppAdapter.getInstance().getLocalModule("com.swimap.adapter.message.sm", false);
    }

    public static EmfSecurityInterface getSecInf() {
        if (null == secInf) {
            secInf = U2kCommonSecurityUtil.getSecurityInterface();
        }
        return secInf;
    }

    public static String getUsername() {
        EmfSecurityInterface oSecInf = U2kCommonSecurityUtil.getSecInf();
        if (null != oSecInf) {
            return oSecInf.getUsername();
        }
        UMLogger.debug("U2kCommonSecurityUtil : oSecInf is null. getUsername()");
        return STR_INVALID;
    }

    public static int getUserID() {
        EmfSecurityInterface oSecInf = U2kCommonSecurityUtil.getSecInf();
        if (null != oSecInf) {
            return oSecInf.getUserID();
        }
        UMLogger.debug("U2kCommonSecurityUtil : oSecInf is null. getUserID()");
        return -1;
    }

    public static boolean securityMenuQualify(int cmdCode) {
        if (U2kCommonSecurityUtil.isAdmin()) {
            return true;
        }
        EmfSecurityInterface oSecInf = U2kCommonSecurityUtil.getSecInf();
        if (null == oSecInf) {
            UMLogger.debug("U2kCommonSecurityUtil : oSecInf is null. + securityMenuQualify " + cmdCode);
            return false;
        }
        return oSecInf.checkUserOperation(cmdCode);
    }

    public static boolean securityQualify(int cmdCode) {
        if (U2kCommonSecurityUtil.isAdmin()) {
            return true;
        }
        EmfSecurityInterface oSecInf = U2kCommonSecurityUtil.getSecInf();
        if (null == oSecInf) {
            UMLogger.debug("U2kCommonSecurityUtil : secInf is null. + securityQualify " + cmdCode);
            return false;
        }
        return oSecInf.checkUserOperation(cmdCode);
    }

    public static boolean securityQualify(int cmdCode, String resID) {
        if (U2kCommonSecurityUtil.isAdmin()) {
            return true;
        }
        EmfSecurityInterface oSecInf = U2kCommonSecurityUtil.getSecInf();
        if (null == oSecInf) {
            UMLogger.debug("U2kCommonSecurityUtil : oSecInf is null. + securityQualify " + cmdCode + resID);
            return false;
        }
        return oSecInf.checkUserOperation(31, 1, resID, cmdCode);
    }

    public static boolean checkUserManagable(String resID) {
        if (U2kCommonSecurityUtil.isAdmin()) {
            return true;
        }
        EmfSecurityInterface oSecInf = U2kCommonSecurityUtil.getSecInf();
        if (null == oSecInf) {
            UMLogger.debug("U2kCommonSecurityUtil checkUserManagable : oSecInf is null. + securityQualify " + resID);
            return false;
        }
        return oSecInf.checkUserManagable(resID);
    }

    public static boolean isAdmin() {
        EmfSecurityInterface oSecInf = U2kCommonSecurityUtil.getSecInf();
        if (null == oSecInf) {
            UMLogger.debug("U2kCommonSecurityUtil : oSecInf is null. + securityQualify ");
            return false;
        }
        return oSecInf.isAdmin(U2kCommonSecurityUtil.getUserID());
    }
}

