/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.module;

import com.huawei.imap12.topo.InmTopoID;
import com.huawei.imap12.topo.InmTopoUtil;
import com.huawei.imap12.topo.TopoObjectSelectionChangedListener;
import com.huawei.imap12.topo.TopoObjectSet;
import com.huawei.u2000.inf.UMCommonSBIInterface;
import com.huawei.u2000.umcommon.module.UMAction;
import com.huawei.u2000.unitedmgr.UMUnitedMgrModule;
import com.huawei.u2000.util.U2kModuleManagerFactory;
import com.huawei.u2000.util.UMLogger;
import com.swimap.external.resource.client.emf.EmfTopoElementIf;
import com.swimap.external.topo.adapter.message.EmfTopoContainerInfo;
import com.swimap.external.topo.adapter.message.EmfTopoLinkInfo;
import com.swimap.external.topo.adapter.message.EmfTopoNodeInfo;
import com.swimap.external.topo.adapter.message.EmfTopoViewEvent;
import com.swimap.iview.commstyle.commini.ToolBarButton;
import com.swimap.iview.framework.menumanagement.MenuManager;
import com.swimap.iview.framework.toolbarmanagement.ToolbarManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;

public final class UMActionTopoManager
implements TopoObjectSelectionChangedListener {
    private Map<String, List<Integer>> propertyList = new HashMap<String, List<Integer>>();
    private List<UMAction> actionList = new ArrayList<UMAction>();
    private EmfTopoViewEvent topoViewEventInfo = null;
    private static UMActionTopoManager instance = null;

    private UMActionTopoManager() {
    }

    public static UMActionTopoManager getInstance() {
        if (instance == null) {
            instance = new UMActionTopoManager();
        }
        return instance;
    }

    public void nodeDeselected(TopoObjectSet topoobjectset) {
    }

    public void nodeSelected(TopoObjectSet topoobjectset) {
        this.clear("NE");
        if (topoobjectset != null) {
            this.addTopoNode(topoobjectset.getNodes(), "NE");
        }
        this.processAction();
        UMLogger.debug(this.getClass(), "nodeSelected", "Ne Explorer Toolbat Ststus=" + this.getNeExplorerToolbatStatus());
    }

    public static TopoObjectSet convertEmfListToInmList(List<EmfTopoElementIf> emfObjList) {
        if (emfObjList == null || emfObjList.size() == 0) {
            return null;
        }
        InmTopoID[] inmObjList = new InmTopoID[emfObjList.size()];
        int size = emfObjList.size();
        for (int i = 0; i < size; ++i) {
            EmfTopoElementIf topoEle = emfObjList.get(i);
            if (topoEle.getElementType() == 1) {
                EmfTopoNodeInfo tmpInfo = (EmfTopoNodeInfo)topoEle;
                int devType = Integer.parseInt(tmpInfo.m_szDevType);
                if (devType == 1873 || devType == 0) {
                    return null;
                }
                inmObjList[i] = InmTopoUtil.convertNodeToInmID((EmfTopoNodeInfo)tmpInfo);
                continue;
            }
            if (topoEle.getElementType() == 3) {
                inmObjList[i] = InmTopoUtil.convertLinkToInmID((EmfTopoLinkInfo)((EmfTopoLinkInfo)topoEle));
                continue;
            }
            if (topoEle.getElementType() != 2) continue;
            if (topoEle instanceof EmfTopoContainerInfo) {
                InmTopoID inmTopoNode = new InmTopoID();
                EmfTopoContainerInfo containerInfo = (EmfTopoContainerInfo)topoEle;
                inmTopoNode.iOTID = 1;
                inmTopoNode.iOSTID = Integer.parseInt(containerInfo.m_szDevType);
                inmTopoNode.iOID = containerInfo.m_iDevID;
                inmObjList[i] = inmTopoNode;
                continue;
            }
            return null;
        }
        return new TopoObjectSet(inmObjList);
    }

    public void processAction() {
        try {
            int size = this.actionList.size();
            for (int i = 0; i < size; ++i) {
                UMAction action = this.actionList.get(i);
                this.setButtonEnable(action.isActionEnabled());
            }
        }
        catch (Exception e) {
            UMLogger.exception("failed to process NE Explorer Toolbar Button.", e);
            this.setButtonEnable(false);
        }
    }

    public void setButtonEnable(final boolean isEnable) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MenuManager menuMgr;
                JMenuItem newMenu;
                ToolbarManager oToolMgr = FrameworkUtilities.getToolbarManager();
                ToolBarButton neMgrBtn = oToolMgr.getToolBarButton("mainTool", "network", "ne_explorer");
                if (null != neMgrBtn) {
                    neMgrBtn.setEnabled(isEnable);
                }
                if (null != (newMenu = (JMenuItem)(menuMgr = FrameworkUtilities.getMenuManager()).getMenuItem("mainMenu", "ConfigurationMenu", "NEExplorerMenu"))) {
                    newMenu.setEnabled(isEnable);
                }
                UMLogger.debug(this.getClass(), "setButtonEnable", "status=" + isEnable);
            }
        });
    }

    public boolean getNeExplorerToolbatStatus() {
        boolean neExplorerToolbatStatus = false;
        ToolbarManager oToolMgr = FrameworkUtilities.getToolbarManager();
        ToolBarButton neMgrBtn = oToolMgr.getToolBarButton("mainTool", "network", "ne_explorer");
        if (null != neMgrBtn) {
            neExplorerToolbatStatus = neMgrBtn.isEnabled();
        }
        UMLogger.debug(this.getClass(), "getNeExplorerToolbatStatus", "status=" + neExplorerToolbatStatus);
        return neExplorerToolbatStatus;
    }

    public boolean isSupportObject(int neID) {
        boolean blSupport = false;
        UMUnitedMgrModule unitedMgrModule = U2kModuleManagerFactory.getUMUnitedMgrModule();
        if (null == unitedMgrModule) {
            UMLogger.error("Class:UMActionTopoManager, Func:isSupportObject, neID : " + neID);
            return blSupport;
        }
        UMCommonSBIInterface sbiObj = unitedMgrModule.getSBIInterface(neID);
        if (null != sbiObj) {
            try {
                blSupport = sbiObj.isSupportObject(neID, 2002);
            }
            catch (Exception ex) {
                UMLogger.error("Class:UMActionTopoManager, Func:isSupportObject, isSupportObject error!");
                UMLogger.exception(ex);
            }
        }
        return blSupport;
    }

    private void addTopoNode(InmTopoID[] topoID, String nodeType) {
        if (topoID == null || topoID.length == 0) {
            return;
        }
        ArrayList<Integer> nodeList = new ArrayList<Integer>();
        for (int i = 0; i < topoID.length; ++i) {
            InmTopoID topoObj = topoID[i];
            nodeList.add(topoObj.iOID);
        }
        if (!nodeList.isEmpty()) {
            this.setNode(nodeType, nodeList);
        }
    }

    private void setNode(String property, List<Integer> nodeList) {
        if (property != null && nodeList != null) {
            this.propertyList.put(property, nodeList);
        }
    }

    public List<Integer> getNodeIDList() {
        return this.propertyList.get("NE");
    }

    public void onSelectionChange(EmfTopoViewEvent emftopoviewevent) {
        UMLogger.debug(this.getClass(), "onSelectionChange", " " + emftopoviewevent.getSelectObject());
        this.nodeSelected(UMActionTopoManager.convertEmfListToInmList(emftopoviewevent.getSelectObject()));
        this.topoViewEventInfo = emftopoviewevent;
    }

    public void registerTopoChangeListener(UMAction action) {
        this.actionList.add(action);
    }

    public void unregisterTopoChangeListener(UMAction action) {
        this.actionList.remove((Object)action);
    }

    public void registerTopoObjectSelectionChangedListener() {
        InmTopoUtil.registerTopoObjectSelectionChangedListener((TopoObjectSelectionChangedListener)this);
    }

    public void unregisterTopoObjectSelectionChangedListener() {
        InmTopoUtil.unregisterTopoObjectSelectionChangedListener((TopoObjectSelectionChangedListener)this);
    }

    private void clear(String actionNodeType) {
        this.propertyList.put(actionNodeType, null);
    }

    public EmfTopoViewEvent getTopoViewEventInfo() {
        return this.topoViewEventInfo;
    }
}

