/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.fiber.adapter;

import com.huawei.imap12.utility.InmProfileFactory;
import com.huawei.u2000.umcommon.fiber.adapter.Adapter;
import com.huawei.u2000.umcommon.fiber.adapter.Device;
import com.huawei.u2000.umcommon.fiber.adapter.DeviceDomain;
import com.huawei.u2000.umcommon.fiber.adapter.DeviceDomainBasePolicyAdapter;
import com.huawei.u2000.umcommon.fiber.adapter.DeviceDomainPolicyAdapter;
import com.huawei.u2000.umcommon.fiber.adapter.OnlyDevicePolicyAdapter;
import com.huawei.u2000.umcommon.fiber.adapter.Policy;
import com.huawei.u2000.umcommon.fiber.adapter.TEDomainClassType;
import com.huawei.u2000.util.UMLogger;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class TEDeviceAdapterMgrUtil {
    public static final int ONLY_DEVICE_POLICY = 1;
    public static final int DEVICE_DOMAIN_POLICY = 2;
    public static final int DEVICE_DOMAIN_BASE_POLICY = 3;
    private static TEDeviceAdapterMgrUtil instance = null;
    private static final int[] SUPPORTEDPOLICIES = new int[]{1, 2, 3};
    private Map adapterHashMap = new HashMap();
    private Map baseClassHashMap = new HashMap();

    private TEDeviceAdapterMgrUtil() {
    }

    public String getAdapterClass(String fileName, int domainType, int neType, String baseClassName) {
        return this.getAdapterClass(fileName, domainType, neType, baseClassName, 3);
    }

    public String getAdapterClass(String fileName, int domainType, int neType, String baseClassName, int policy) {
        if (fileName == null) {
            return null;
        }
        if (baseClassName == null) {
            return null;
        }
        if (!this.checkPolicy(policy)) {
            return null;
        }
        return this.searchAdapterClassInFile(fileName, domainType, neType, baseClassName, policy);
    }

    private boolean checkPolicy(int _policy) {
        return Arrays.binarySearch(this.getSupportPolicies(), _policy) >= 0;
    }

    public int[] getSupportPolicies() {
        return (int[])SUPPORTEDPOLICIES.clone();
    }

    private String searchAdapterClassInFile(String _fileName, int domainType, int _neType, String _baseClassName, int _policy) {
        Adapter adapter;
        TEDomainClassType domainClassType = null;
        if (this.baseClassHashMap.containsKey(_baseClassName)) {
            HashMap domainAdapterClassHashMap = (HashMap)this.baseClassHashMap.get(_baseClassName);
            domainClassType = (TEDomainClassType)domainAdapterClassHashMap.get(domainType);
        } else if (this.adapterHashMap.containsKey(_fileName)) {
            adapter = (Adapter)((Object)this.adapterHashMap.get(_fileName));
            Map map = this.findBaseClassInAdapter(adapter, _baseClassName);
            if (map != null) {
                domainClassType = (TEDomainClassType)map.get(domainType);
            }
        } else {
            adapter = null;
            URL url = InmProfileFactory.getCommonResourceURL((String)_fileName);
            if (url != null) {
                adapter = Adapter.unmarshal(url);
            }
            if (adapter != null) {
                this.adapterHashMap.put(_fileName, adapter);
                Map map = this.findBaseClassInAdapter(adapter, _baseClassName);
                if (map != null) {
                    domainClassType = (TEDomainClassType)map.get(domainType);
                }
            }
        }
        Policy policyAdapter = this.getPolicyAdapter(_policy);
        return policyAdapter.getAdapterClass(domainClassType, _neType, _baseClassName);
    }

    private Map findBaseClassInAdapter(Adapter _adapter, String _baseClassName) {
        HashMap<Integer, TEDomainClassType> adapterClassHashMap = new HashMap<Integer, TEDomainClassType>();
        TEDomainClassType domainClassType = null;
        for (int i = 0; i < _adapter.getBaseClassCount(); ++i) {
            if (!_adapter.getBaseClass(i).getClassName().equals(_baseClassName)) continue;
            for (int j = 0; j < _adapter.getBaseClass(i).getDeviceDomainCount(); ++j) {
                DeviceDomain deviceDomain = _adapter.getBaseClass(i).getDeviceDomain(j);
                domainClassType = new TEDomainClassType(Integer.parseInt(deviceDomain.getId()), deviceDomain.getAdapterClass());
                for (int k = 0; k < deviceDomain.getDeviceCount(); ++k) {
                    Device device = deviceDomain.getDevice(k);
                    domainClassType.addDeviceAdapterClass(Integer.parseInt(device.getId()), device.getAdapterClass());
                }
                adapterClassHashMap.put(Integer.valueOf(deviceDomain.getId()), domainClassType);
            }
            break;
        }
        if (!adapterClassHashMap.isEmpty()) {
            this.baseClassHashMap.put(_baseClassName, adapterClassHashMap);
            return adapterClassHashMap;
        }
        return null;
    }

    private Policy getPolicyAdapter(int _policy) {
        if (_policy == 1) {
            return OnlyDevicePolicyAdapter.getInstance();
        }
        if (_policy == 2) {
            return DeviceDomainPolicyAdapter.getInstance();
        }
        if (_policy == 3) {
            return DeviceDomainBasePolicyAdapter.getInstance();
        }
        return null;
    }

    public Object getAdapterObject(String fileName, int domainType, int neType, String baseClassName, Object[] params) {
        return this.getAdapterObject(fileName, domainType, neType, baseClassName, params, 3);
    }

    public Object getAdapterObject(String fileName, int domainType, int neType, String baseClassName) {
        return this.getAdapterObject(fileName, domainType, neType, baseClassName, null, 3);
    }

    public Object getAdapterObject(String fileName, int domainType, int neType, String baseClassName, int policy) {
        return this.getAdapterObject(fileName, domainType, neType, baseClassName, null, policy);
    }

    public Object getAdapterObject(String fileName, int domainType, int neType, String baseClassName, Class[] paramType, Object[] params, int policy) {
        String adapterClass = this.getAdapterClass(fileName, domainType, neType, baseClassName, policy);
        Class<?> classObject = null;
        if (adapterClass == null) {
            return null;
        }
        try {
            classObject = Class.forName(adapterClass);
        }
        catch (ClassNotFoundException exp) {
            UMLogger.exception(exp);
            return null;
        }
        Object adapterObject = null;
        if (params == null) {
            try {
                adapterObject = classObject.newInstance();
            }
            catch (InstantiationException exp) {
                UMLogger.exception(exp);
                return null;
            }
            catch (IllegalAccessException exp) {
                UMLogger.exception(exp);
                return null;
            }
        }
        try {
            Constructor<?> constructorObject = classObject.getConstructor(paramType);
            adapterObject = constructorObject.newInstance(params);
        }
        catch (Exception e) {
            UMLogger.exception(e);
            return null;
        }
        return adapterObject;
    }

    public Object getAdapterObject(String fileName, int domainType, int neType, String baseClassName, Object[] params, int policy) {
        String adapterClass = this.getAdapterClass(fileName, domainType, neType, baseClassName, policy);
        Class<?> classObject = null;
        if (adapterClass == null) {
            return null;
        }
        try {
            classObject = Class.forName(adapterClass);
        }
        catch (ClassNotFoundException exp) {
            UMLogger.exception(exp);
            return null;
        }
        Object adapterObject = null;
        if (params == null) {
            try {
                adapterObject = classObject.newInstance();
            }
            catch (InstantiationException exp) {
                UMLogger.exception(exp);
                return null;
            }
            catch (IllegalAccessException exp) {
                UMLogger.exception(exp);
                return null;
            }
        }
        try {
            Class[] classType = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                classType[i] = params[i].getClass();
            }
            Constructor<?> constructorObject = classObject.getConstructor(classType);
            adapterObject = constructorObject.newInstance(params);
        }
        catch (Exception e) {
            UMLogger.exception(e);
            return null;
        }
        return adapterObject;
    }

    public static TEDeviceAdapterMgrUtil getInstance() {
        if (instance == null) {
            instance = new TEDeviceAdapterMgrUtil();
        }
        return instance;
    }
}

