/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.fiber;

import com.huawei.core.inf.pubinf.pubmenu.FrameContextInf;
import com.huawei.core.util.TENameValuePair;
import com.huawei.core.util.ValueInterface;
import com.huawei.core.util.asn.TEAsnIntList;
import com.huawei.u2000.inventory.fiber.AsnFiber;
import com.huawei.u2000.inventory.fiber.AsnFiberList;
import com.huawei.u2000.inventory.fiber.TEFiberOperBroker;
import com.huawei.u2000.inventory.fiber.manager.Port;
import com.huawei.u2000.inventory.fiber.manager.STMLevel;
import com.huawei.u2000.inventory.fiber.manager.TEFiberMgrModel;
import com.huawei.u2000.inventory.fiber.manager.TEFiberMgrTable;
import com.huawei.u2000.inventory.fiber.manager.TEFiberMgrView;
import com.huawei.u2000.inventory.fiber.manager.TEFiberOperUtility;
import com.huawei.u2000.util.UMLogger;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class FiberContent
implements FrameContextInf {
    private TEFiberMgrModel model;
    private TEFiberMgrTable fiberTable;
    private int minRow;
    private Map<BigInteger, List> fiberCacheData;

    public FiberContent() {
        this.model = TEFiberMgrView.getInstance().fiberPanel.fiberTableModel;
        this.fiberTable = TEFiberMgrView.getInstance().fiberPanel.fiberTable;
        this.minRow = this.fiberTable.getSelectedRow();
        this.fiberCacheData = new HashMap<BigInteger, List>();
    }

    public HashMap getSelectedData() {
        if (this.minRow < 0) {
            return null;
        }
        BigInteger fiberID = this.model.getFiberIdFromRowIndex(this.minRow);
        HashMap<BigInteger, List> contentMap = new HashMap<BigInteger, List>();
        List data = (List)this.model.fiberInfoMap.get(fiberID);
        if (null == data) {
            data = this.getRowVector();
        }
        contentMap.put(fiberID, data);
        return contentMap;
    }

    public int getFiberID() {
        if (this.minRow < 0) {
            return -1;
        }
        BigInteger fiberID = this.model.getFiberIdFromRowIndex(this.minRow);
        if (fiberID == null) {
            return -1;
        }
        return fiberID.intValue();
    }

    public int[] getSelectedFiberRows() {
        return this.fiberTable.getSelectedRows();
    }

    public TEAsnIntList getSelectedFiberIDs() {
        TEAsnIntList fiberIDLst = new TEAsnIntList();
        int[] rows = this.fiberTable.getSelectedRows();
        BigInteger fiberID = null;
        for (int i = 0; i < rows.length; ++i) {
            fiberID = this.model.getFiberIdFromRowIndex(rows[i]);
            if (null == fiberID) continue;
            fiberIDLst.add(fiberID.intValue());
        }
        return fiberIDLst;
    }

    public List getRowVector() {
        BigInteger fiberID = this.model.getFiberIdFromRowIndex(this.minRow);
        List fiberData = (List)this.model.fiberInfoMap.get(fiberID);
        if (null == fiberData) {
            Vector fiberDataTmp;
            UMLogger.debug(this.getClass(), "getRowVector()", "fiberData is null, and fiber id is: " + fiberID);
            fiberData = this.fiberCacheData.get(fiberID);
            if (null != fiberData) {
                return fiberData;
            }
            ArrayList<BigInteger> fiberIDListTmp = new ArrayList<BigInteger>();
            fiberIDListTmp.add(fiberID);
            AsnFiberList asnFiberList = TEFiberOperBroker.getInstance().getAsnFiberList(fiberIDListTmp);
            if (null != asnFiberList && asnFiberList.size() > 0 && null != (fiberDataTmp = TEFiberOperUtility.getRowDataFromAsnFiber((AsnFiber)((AsnFiber)asnFiberList.get(0)))) && null != fiberID) {
                fiberData = (Vector)fiberDataTmp.clone();
                this.fiberCacheData.put(fiberID, fiberDataTmp);
            }
        }
        return fiberData;
    }

    public int getFiberLevel() {
        STMLevel level;
        List rowVector = this.getRowVector();
        if (rowVector != null && (level = (STMLevel)rowVector.get(7)) != null && level.level != null) {
            return level.level.intValue();
        }
        return -1;
    }

    public String getFiberLevelName() {
        STMLevel level;
        List rowVector = this.getRowVector();
        if (rowVector != null && (level = (STMLevel)rowVector.get(7)) != null) {
            return level.toString();
        }
        return "";
    }

    public int getFiberType() {
        ValueInterface fiberType;
        List rowVector = this.getRowVector();
        if (rowVector != null && (fiberType = (ValueInterface)rowVector.get(12)) != null) {
            return fiberType.getIntValue();
        }
        return -1;
    }

    public int getLinkType() {
        TENameValuePair linkPair;
        List rowVector = this.getRowVector();
        if (rowVector != null && (linkPair = (TENameValuePair)rowVector.get(11)) != null) {
            return linkPair.getValue();
        }
        return -1;
    }

    public int getSrcNeID() {
        Port port;
        List rowVector = this.getRowVector();
        if (rowVector != null && (port = (Port)rowVector.get(4)) != null && port.asnPort != null) {
            return port.asnPort.neID;
        }
        return -1;
    }

    public int getSrcSlot() {
        Port port;
        List rowVector = this.getRowVector();
        if (rowVector != null && (port = (Port)rowVector.get(4)) != null && port.asnPort != null) {
            return port.asnPort.bid;
        }
        return -1;
    }

    public int getSrcPortID() {
        Port port;
        List rowVector = this.getRowVector();
        if (rowVector != null && (port = (Port)rowVector.get(4)) != null && port.asnPort != null) {
            return port.asnPort.pid;
        }
        return -1;
    }

    public int getDstNeID() {
        Port port;
        List rowVector = this.getRowVector();
        if (rowVector != null && (port = (Port)rowVector.get(6)) != null && port.asnPort != null) {
            return port.asnPort.neID;
        }
        return -1;
    }

    public int getDstSlot() {
        Port port;
        List rowVector = this.getRowVector();
        if (rowVector != null && (port = (Port)rowVector.get(6)) != null && port.asnPort != null) {
            return port.asnPort.bid;
        }
        return -1;
    }

    public int getDstPortID() {
        Port port;
        List rowVector = this.getRowVector();
        if (rowVector != null && (port = (Port)rowVector.get(6)) != null && port.asnPort != null) {
            return port.asnPort.pid;
        }
        return -1;
    }

    public boolean isVirtualLink() {
        int linkType = this.getLinkType();
        if (linkType < 0) {
            return true;
        }
        return linkType == 311;
    }

    public String getSrcNeName() {
        List rowVector = this.getRowVector();
        if (rowVector != null) {
            return rowVector.get(3).toString();
        }
        return "";
    }

    public String getDstNeName() {
        List rowVector = this.getRowVector();
        if (rowVector != null) {
            return rowVector.get(5).toString();
        }
        return "";
    }

    public String getSrcPortNeName() {
        List rowVector = this.getRowVector();
        if (rowVector != null) {
            return rowVector.get(4).toString();
        }
        return "";
    }

    public String getDstPortNeName() {
        List rowVector = this.getRowVector();
        if (rowVector != null) {
            return rowVector.get(6).toString();
        }
        return "";
    }
}

