/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.fault;

import com.huawei.imap12.utility.InmResourceManager;
import com.huawei.u2000.basetool.UMFrameAppAdapter;
import com.huawei.u2000.basetool.uid.StrUIDParser;
import com.huawei.u2000.umcommon.fault.UMAlarmInfoStruct;
import com.huawei.u2000.util.U2kModuleManagerFactory;
import com.huawei.u2000.util.UMLogger;
import com.swimap.external.dsf.base.rpc.DataTable;
import com.swimap.external.ifms.adapter.message.ActionExtension;
import com.swimap.external.ifms.adapter.message.AlarmRecord;
import com.swimap.external.ifms.adapter.message.PlatformFaultContext;
import com.swimap.external.ifms.ifmsclientmanagement.IfmsFunctionInterface;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class U2kFaultUtil {
    public static final String PLAF_FIBER = "FiberID";
    public static final String PLAF_LINK = "LinkID";
    public static final int INVALID_ID = -1;
    private static final String RESOURCEFILE = "u2000/fault/resources/faultresource.ini";
    public static final String TOKEN = ".";

    private U2kFaultUtil() {
    }

    public static final void showAlarmExByLinks(DataTable dataTable, String tltle, String windowID) {
        UMLogger.debug(U2kFaultUtil.class, " showAlarmExByLinks ", " tltle : " + tltle + " windowID : " + windowID);
        IfmsFunctionInterface functionInterface = U2kModuleManagerFactory.getIfmsFunctionInterface();
        HashMap<String, DataTable> alarmSource = new HashMap<String, DataTable>();
        alarmSource.put("u2000alarmsource", dataTable);
        functionInterface.openFaultWindow("Fault", tltle, windowID, null, null, null, alarmSource, null);
    }

    public static final void showAlarmExByFibers(DataTable dataTable, String tltle, String windowID, boolean isCurrent) {
        UMLogger.debug(U2kFaultUtil.class, " showAlarmExByLinks ", " tltle : " + tltle + " windowID : " + windowID + " isCurrent : " + isCurrent);
        IfmsFunctionInterface functionInterface = U2kModuleManagerFactory.getIfmsFunctionInterface();
        HashMap<String, DataTable> alarmSource = new HashMap<String, DataTable>();
        alarmSource.put("u2000alarmsource", dataTable);
        if (isCurrent) {
            functionInterface.openFaultWindow("Fault", tltle, tltle, null, null, null, alarmSource, null);
        } else {
            functionInterface.openFaultWindow("HistoryLog", tltle, tltle, null, null, null, alarmSource, null);
        }
    }

    public static final PlatformFaultContext getFaultInterface() {
        try {
            return (PlatformFaultContext)UMFrameAppAdapter.getInstance().getLocalModule("com.swimap.adapter.message.fm", false);
        }
        catch (Exception ex) {
            UMLogger.exception(ex);
            return null;
        }
    }

    public static final String getString(String key) {
        return InmResourceManager.getString((String)RESOURCEFILE, (String)key);
    }

    public static int[] getNEIDListFromAlarmResIDList(String[] resIDList) {
        ArrayList<Integer> neIDList = new ArrayList<Integer>();
        for (int i = 0; i < resIDList.length; ++i) {
            int neID;
            StringTokenizer tokener = new StringTokenizer(resIDList[i], TOKEN);
            int size = tokener.countTokens();
            if (size == 0) {
                UMLogger.debug("The resID=" + resIDList[i] + " can't be parered!");
                continue;
            }
            if (size == 1) {
                neID = Integer.parseInt(tokener.nextToken());
                neIDList.add(neID);
            }
            if (size < 2) continue;
            tokener.nextToken();
            neID = Integer.parseInt(tokener.nextToken());
            neIDList.add(neID);
        }
        int[] neIDInt = new int[neIDList.size()];
        for (int i = 0; i < neIDList.size(); ++i) {
            neIDInt[i] = (Integer)neIDList.get(i);
        }
        return neIDInt;
    }

    public static final List getCurSelectedFaultSerialNo() {
        PlatformFaultContext faultInterface = U2kFaultUtil.getFaultInterface();
        ArrayList<Integer> lstSerialNo = new ArrayList<Integer>();
        if (faultInterface != null) {
            int[] ids = faultInterface.getSelectedAlarmIds();
            for (int i = 0; i < ids.length; ++i) {
                lstSerialNo.add(ids[i]);
            }
        }
        return lstSerialNo;
    }

    public static final List<UMAlarmInfoStruct> getCurSelectedFaultNEAndSerialNoInfo() {
        PlatformFaultContext faultInterface = U2kFaultUtil.getFaultInterface();
        if (null == faultInterface) {
            UMLogger.debug("getCurSelectedFaultNEAndSerialNoInfo : faultInterface is null.");
            return null;
        }
        AlarmRecord[] selectedAlarmObject = faultInterface.getSelectedAlarms();
        if (null == selectedAlarmObject) {
            UMLogger.debug("getCurSelectedFaultNEAndSerialNoInfo : selectedAlarmObject is null.");
            return null;
        }
        ArrayList<UMAlarmInfoStruct> alarmInfoLst = new ArrayList<UMAlarmInfoStruct>();
        AlarmRecord alarmRecord = null;
        StrUIDParser fndParser = new StrUIDParser();
        HashMap<Integer, UMAlarmInfoStruct> alramInfoMap = new HashMap<Integer, UMAlarmInfoStruct>();
        for (int i = 0; i < selectedAlarmObject.length; ++i) {
            alarmRecord = selectedAlarmObject[i];
            if (alarmRecord.isEnded()) continue;
            Object obj = alarmRecord.getExtendFieldValue("AlarmPlane");
            String strAlarmPlaneValue = "";
            if (null != obj) {
                strAlarmPlaneValue = obj.toString().trim();
            }
            if ("2".equals(strAlarmPlaneValue) || alarmRecord.getFDN().trim().startsWith("OS")) continue;
            if (fndParser.parse(alarmRecord.getFDN())) {
                int iOneID = (int)fndParser.intValue("ONE");
                if (0 != iOneID) {
                    U2kFaultUtil.setAlarmInfoMap(alramInfoMap, alarmRecord, iOneID);
                    continue;
                }
                int iNeID = (int)fndParser.intValue("NE");
                if (0 != iNeID) {
                    U2kFaultUtil.setAlarmInfoMap(alramInfoMap, alarmRecord, iNeID);
                    continue;
                }
                UMLogger.debug("getCurSelectedFaultNEAndSerialNoInfo : the fdn is : " + alarmRecord.getFDN());
                continue;
            }
            UMLogger.debug("getCurSelectedFaultNEAndSerialNoInfo : invalid fdn is : " + alarmRecord.getFDN());
        }
        Iterator alarmInfoEntrySet = alramInfoMap.entrySet().iterator();
        Map.Entry alarmEntry = null;
        while (alarmInfoEntrySet.hasNext()) {
            alarmEntry = alarmInfoEntrySet.next();
            if (null == alarmEntry.getValue()) continue;
            alarmInfoLst.add((UMAlarmInfoStruct)alarmEntry.getValue());
        }
        return alarmInfoLst;
    }

    private static void setAlarmInfoMap(Map<Integer, UMAlarmInfoStruct> alramInfoMap, AlarmRecord alarmRecord, int neID) {
        UMAlarmInfoStruct alarmInfo = alramInfoMap.get(neID);
        if (null == alarmInfo) {
            alarmInfo = new UMAlarmInfoStruct();
            alarmInfo.setNeID(neID);
            alarmInfo.getiAlarmSerialNoLst().add((Object)BigInteger.valueOf(alarmRecord.getSerialNumber()));
            alramInfoMap.put(neID, alarmInfo);
        } else {
            alarmInfo.getiAlarmSerialNoLst().add((Object)BigInteger.valueOf(alarmRecord.getSerialNumber()));
        }
    }

    public static final AlarmRecord[] getCurrAlarmRecorder() {
        PlatformFaultContext faultInterface = U2kFaultUtil.getFaultInterface();
        return faultInterface.getSelectedAlarms();
    }

    public static final void registerCurrAlarmActionExtension(ActionExtension actionEx) {
        U2kFaultUtil.getFaultInterface().registerActionExtension(1, actionEx);
    }
}

