/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.component.table;

import com.huawei.core.util.TEIPValue;
import com.huawei.core.util.TEUtilityRes;
import com.huawei.imap12.utility.InmOptionPane;
import com.huawei.ui.HwTextField;
import java.awt.Component;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class UMIPTextField
extends HwTextField {
    private static final long serialVersionUID = 3634630656261831333L;
    private boolean isShow = false;
    private TEIPValue ipValue = new TEIPValue(0L);
    private boolean isHodeDE = true;
    private static final int IPV4_NUMBER = 4;
    private static final int IPV4_MAX = 255;
    private static final int IPV4_MIN = 0;
    private static final int IPV4_MAX_NOT_DE = 223;

    public TEIPValue getIpValue() {
        return this.ipValue;
    }

    public void setIpValue(TEIPValue ipValue) {
        this.ipValue = ipValue;
    }

    public UMIPTextField() {
        UMIPInputDocument doc = new UMIPInputDocument((JTextComponent)((Object)this));
        this.setDocument(doc);
        this.setValue(0L);
    }

    public UMIPTextField(TEIPValue ipValue) {
        UMIPInputDocument doc = new UMIPInputDocument((JTextComponent)((Object)this));
        this.setDocument(doc);
        this.ipValue = ipValue;
        this.setValue(0L);
    }

    public void setHodeDE(boolean isDE) {
        this.isHodeDE = isDE;
    }

    public long getValue() {
        if (!this.isValidFormatString(this.splitString(this.getText(), '.')) && this.isShow) {
            Toolkit.getDefaultToolkit().beep();
            InmOptionPane.showMessageDialog((Component)((Object)this), (Object)TEUtilityRes.getInstance().getString("INPUT_IP_ERROR"), (String)TEUtilityRes.getInstance().getString("KEY9"), (int)1);
        }
        return this.ipValue.getValue();
    }

    public void setValue(long value) {
        this.ipValue.setValue(value);
        this.setText(this.ipValue.toString());
    }

    protected boolean isValidFormatString(List<String> strList) {
        boolean flag = false;
        if (strList != null && 4 == strList.size() && !strList.contains("")) {
            flag = true;
            int[] ip = new int[]{0, 0, 0, 0};
            for (int i = 0; i < 4; ++i) {
                ip[i] = Integer.parseInt(strList.get(i));
                boolean bl = i == 0 ? ip[i] > 0 && ip[i] <= 255 : (flag = ip[i] >= 0 && ip[i] <= 255);
                if (!flag) break;
            }
            this.ipValue.setValue((long)ip[0] << 24 | (long)ip[1] << 16 | (long)(ip[2] << 8) | (long)ip[3]);
        }
        return flag;
    }

    protected boolean isValidString(List<String> strList) {
        boolean flag = false;
        if (strList != null && 4 == strList.size()) {
            flag = true;
            int value = 0;
            try {
                for (int i = 0; i < 4; ++i) {
                    String tmp = strList.get(i);
                    if (tmp.trim().equals("")) continue;
                    value = Integer.parseInt(tmp);
                    if (i == 0 && !this.isHodeDE) {
                        flag = value >= 0 && value <= 223;
                    } else {
                        boolean bl = flag = value >= 0 && value <= 255;
                    }
                    if (flag) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                flag = false;
            }
        }
        return flag;
    }

    protected List<String> splitString(String strSplit, char index) {
        ArrayList<String> strList = new ArrayList<String>(5);
        if (strSplit != null) {
            int len = strSplit.length();
            int oldPos = 0;
            for (int i = 0; i < len; ++i) {
                if (strSplit.charAt(i) != index) continue;
                if (oldPos == i) {
                    strList.add("");
                } else {
                    strList.add(strSplit.substring(oldPos, i).trim());
                }
                oldPos = i + 1;
            }
            if (oldPos == len) {
                strList.add("");
            } else {
                strList.add(strSplit.substring(oldPos).trim());
            }
        }
        return strList;
    }

    public void setIsShow(boolean isShow) {
        this.isShow = isShow;
    }

    class UMIPInputDocument
    extends PlainDocument {
        public JTextComponent textComponent;

        public UMIPInputDocument(JTextComponent tc) {
            this.textComponent = tc;
        }

        @Override
        public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
            if (s.length() > 1 && UMIPTextField.this.isValidString(UMIPTextField.this.splitString(s, '.'))) {
                super.remove(0, this.textComponent.getText().length());
                super.insertString(0, s, attributeSet);
                this.textComponent.selectAll();
            } else if (s.length() == 1) {
                char inputChar = s.charAt(0);
                String oldStr = this.textComponent.getText();
                if (inputChar == '.' && offset != oldStr.length() && oldStr.charAt(offset) == '.') {
                    this.textComponent.setCaretPosition(offset + 1);
                    return;
                }
                if (!this.parseChar(inputChar)) {
                    Toolkit.getDefaultToolkit().beep();
                    return;
                }
                if (this.isValidInputString(oldStr, s.charAt(0), offset)) {
                    super.insertString(offset, s, attributeSet);
                } else if (this.isLastField(oldStr, offset)) {
                    int pos = offset + oldStr.substring(offset).indexOf(46) + 1;
                    if (this.isValidInputString(oldStr, s.charAt(0), pos)) {
                        this.textComponent.setCaretPosition(pos);
                        this.textComponent.setSelectionStart(pos);
                        super.insertString(pos, s, attributeSet);
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        }

        @Override
        public void remove(int offset, int length) throws BadLocationException {
            String oldStr = this.textComponent.getText();
            if (null == oldStr || oldStr.isEmpty() || offset < 0 || offset >= oldStr.length()) {
                return;
            }
            if (length > 1) {
                String subString = oldStr.substring(offset, length + offset);
                StringBuffer sb = new StringBuffer();
                sb.append(oldStr.substring(0, offset));
                int pos = subString.indexOf(46);
                int size = subString.length();
                for (int i = 0; i < size && pos != -1; ++i) {
                    sb.append('.');
                    pos = subString.indexOf(46, pos + 1);
                }
                sb.append(oldStr.substring(offset + length));
                super.remove(offset, length);
                this.insertString(0, sb.toString(), null);
                this.textComponent.setCaretPosition(offset);
            } else if (oldStr.charAt(offset) != '.') {
                super.remove(offset, length);
            } else if (offset >= 0) {
                this.textComponent.setCaretPosition(offset);
            }
        }

        public boolean parseChar(char inputValue) {
            boolean retValue = false;
            if (inputValue >= '0' && inputValue <= '9') {
                retValue = true;
            }
            return retValue;
        }

        private boolean isValidInputString(String oldStr, char inputValue, int offset) {
            boolean flag = false;
            boolean isFirstArea = false;
            if (offset > oldStr.length()) {
                offset = oldStr.length();
            }
            String validValue = oldStr.substring(0, offset).trim();
            int pos = validValue.lastIndexOf(46);
            int pos2 = 0;
            if (pos == -1) {
                pos = 0;
                pos2 = oldStr.indexOf(46);
                isFirstArea = true;
            } else {
                pos2 = oldStr.indexOf(46, pos + 1);
                if (pos2 == -1) {
                    pos2 = oldStr.length();
                }
            }
            StringBuffer sb = new StringBuffer();
            for (int i = pos; i <= pos2; ++i) {
                if (i == offset) {
                    sb.append(inputValue);
                }
                if (i >= oldStr.length() || oldStr.charAt(i) == '.') continue;
                sb.append(oldStr.charAt(i));
            }
            validValue = sb.toString().trim();
            try {
                int value = Integer.parseInt(validValue);
                flag = isFirstArea ? value >= 0 && value <= 223 && validValue.indexOf("00") != 0 && validValue.length() <= 3 : value >= 0 && value <= 255 && validValue.indexOf("00") != 0 && validValue.length() <= 3;
            }
            catch (Exception ex) {
                flag = false;
            }
            return flag;
        }

        private boolean isLastField(String oldStr, int offset) {
            int pos = oldStr.indexOf(46, offset);
            return pos == offset;
        }
    }
}

