/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.component.table;

import com.huawei.core.util.TEIPValue;
import com.huawei.u2000.umcommon.component.table.UMIPTextField;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class UMIPTextCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 5840417233115085545L;
    protected UMIPTextField ipText = new UMIPTextField();
    protected int clickCountToStart = 2;

    public UMIPTextCellEditor() {
    }

    public UMIPTextCellEditor(UMIPTextField ipText) {
        this.ipText = ipText;
    }

    @Override
    public Object getCellEditorValue() {
        return new TEIPValue(this.ipText.getValue());
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof TEIPValue) {
            TEIPValue ip = (TEIPValue)value;
            this.ipText.setValue(ip.getValue());
        } else {
            this.ipText.setValue(0L);
        }
        return this.ipText;
    }

    public void setClickCountToStart(int count) {
        this.clickCountToStart = count;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= this.clickCountToStart;
        }
        return true;
    }
}

