/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.component.selecttree.tree;

import com.huawei.core.util.TEResourceUtil;
import com.huawei.u2000.umcommon.component.selecttree.UMSelectTreeAgent;
import com.huawei.u2000.umcommon.component.selecttree.UMSelectTreeData;
import com.huawei.u2000.umcommon.component.selecttree.common.UMSelectTreeUtil;
import com.huawei.u2000.umcommon.component.selecttree.tree.UMMutableSelectTreeNode;
import com.huawei.u2000.umcommon.component.selecttree.tree.UMSelectTree;
import com.huawei.u2000.util.UMLogger;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class UMSingleSelectTree
extends UMSelectTree {
    private static final long serialVersionUID = 200163562658680162L;
    private static final String ICON_FILE = "u2000" + File.separator + "base" + File.separator + "profile" + File.separator + "icon_resource.ini";
    private static long startTime = 0L;
    protected UMMutableSelectTreeNode root = null;
    private boolean bSelectAll = false;

    public UMSingleSelectTree() {
        this((UMSelectTreeData)null);
    }

    public UMSingleSelectTree(UMSelectTreeData data) {
        this(data, null);
    }

    public UMSingleSelectTree(UMSelectTreeData data, UMSelectTreeAgent adapter) {
        this(data, adapter, false);
    }

    public UMSingleSelectTree(UMSelectTreeData data, UMSelectTreeAgent adapter, boolean bselectAll) {
        super(UMSingleSelectTree.createTreeModel(data));
        this.dataAdapter = adapter;
        this.bSelectAll = bselectAll;
        this.root = this.getRoot();
        this.isNullTree = this.root.getChildCount() <= 0;
        DefaultTreeCellRenderer cellRenderer = new DefaultTreeCellRenderer();
        this.setCellRenderer(cellRenderer);
        cellRenderer.setClosedIcon(TEResourceUtil.getInstance((String)ICON_FILE).getIcon("Directory.gif"));
        cellRenderer.setOpenIcon(TEResourceUtil.getInstance((String)ICON_FILE).getIcon("TreeOpen.gif"));
        cellRenderer.setLeafIcon(TEResourceUtil.getInstance((String)ICON_FILE).getIcon("open.gif"));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (null == UMSingleSelectTree.this.dataAdapter) {
                    return;
                }
                if (e.getModifiers() == 4) {
                    Point p = e.getPoint();
                    TreePath tp = UMSingleSelectTree.this.getPathForRow(UMSingleSelectTree.this.getRowForLocation(p.x, p.y));
                    if (tp != null) {
                        UMSingleSelectTree.this.setSelectionPath(tp);
                        UMMutableSelectTreeNode node = (UMMutableSelectTreeNode)tp.getLastPathComponent();
                        JPopupMenu menu = UMSingleSelectTree.this.dataAdapter.getPopupMenu((UMSelectTreeData)node.getUserObject());
                        if (menu != null) {
                            menu.show(UMSingleSelectTree.this, p.x, p.y);
                        }
                    }
                }
            }
        });
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                UMMutableSelectTreeNode node = (UMMutableSelectTreeNode)event.getPath().getLastPathComponent();
                if (!node.isLeaf() && node.getChildCount() == 0) {
                    ArrayList<UMMutableSelectTreeNode> nodes = new ArrayList<UMMutableSelectTreeNode>();
                    nodes.add(node);
                    UMSingleSelectTree.this.mountChildren(nodes);
                }
            }
        });
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setRowHeight(25);
        this.getSelectionModel().setSelectionMode(1);
        UMSelectTreeUtil.printLocalTime("build single select tree end ,the time is :");
        UMLogger.debug("the single selected treee build time:" + (System.currentTimeMillis() - startTime) + "(ms)");
    }

    protected static TreeModel createTreeModel(Object value) {
        UMSelectTreeUtil.printLocalTime("start build single selected tree,the time is:");
        startTime = System.currentTimeMillis();
        UMSelectTreeData convertedData = (UMSelectTreeData)value;
        return new DefaultTreeModel(new UMMutableSelectTreeNode((Object)convertedData, convertedData.getChildren()), false);
    }

    @Override
    public void rebuildTree(List datas) {
        this.mountChildren(this.root, datas);
    }

    @Override
    public void rebuildTree(UMSelectTreeData[] data) {
    }

    private void mountChildren(UMMutableSelectTreeNode node, List childrenData) {
        node.clearChildren();
        node.setAllowsChildren(true);
        node.createChildren(childrenData);
        ((DefaultTreeModel)this.getModel()).nodeStructureChanged(node);
        ((UMSelectTreeData)node.getUserObject()).setChildren(childrenData);
        this.isNullTree = this.root.getChildCount() <= 0;
    }

    public List getSelectedObject() {
        Vector<UMSelectTreeData> result = new Vector<UMSelectTreeData>(1);
        TreePath path = this.getSelectionPath();
        if (path != null) {
            UMMutableSelectTreeNode node = (UMMutableSelectTreeNode)path.getLastPathComponent();
            UMSelectTreeData objData = (UMSelectTreeData)node.getUserObject();
            result.add(objData);
        }
        return result;
    }

    @Override
    public void shrinkAll() {
        Enumeration nodeEnum = this.root.children();
        UMMutableSelectTreeNode tmp = null;
        while (nodeEnum.hasMoreElements()) {
            tmp = (UMMutableSelectTreeNode)nodeEnum.nextElement();
            this.setNodeExpandState(tmp, false);
        }
    }

    private void setNodeExpandState(UMMutableSelectTreeNode node, boolean state, boolean expandAll) {
        UMMutableSelectTreeNode tmp = null;
        TreePath path = null;
        if (expandAll) {
            if (node.isLeaf()) {
                return;
            }
            Enumeration nodeEnum1 = node.children();
            while (nodeEnum1.hasMoreElements()) {
                tmp = (UMMutableSelectTreeNode)nodeEnum1.nextElement();
                this.setNodeExpandState(tmp, state);
            }
            path = new TreePath(node.getPath());
            this.setExpandedState(path, state);
        } else {
            Enumeration<TreeNode> nodeEnum2 = node.breadthFirstEnumeration();
            while (nodeEnum2.hasMoreElements()) {
                tmp = (UMMutableSelectTreeNode)nodeEnum2.nextElement();
                if (tmp.isLeaf() || state && tmp.isNeedloadLater() && tmp.getChildCount() <= 0) continue;
                path = new TreePath(tmp.getPath());
                this.setExpandedState(path, state);
            }
        }
    }

    private void setNodeExpandState(UMMutableSelectTreeNode node, boolean state) {
        this.setNodeExpandState(node, state, true);
    }

    @Override
    public void setFirstChildSelected() {
        if (this.root.getChildCount() <= 0) {
            return;
        }
        UMMutableSelectTreeNode node = (UMMutableSelectTreeNode)this.root.getFirstLeaf();
        Object[] nodepath = node.getPath();
        TreePath path = new TreePath(nodepath);
        this.getSelectionModel().setSelectionPath(path);
    }

    @Override
    public void setNodeSelected(UMMutableSelectTreeNode node) {
        Object[] nodepath = node.getPath();
        TreePath path = new TreePath(nodepath);
        this.getSelectionModel().addSelectionPath(path);
    }

    @Override
    public void setNodesSelected(List<UMMutableSelectTreeNode> nodes) {
        int size = nodes.size();
        TreePath[] paths = new TreePath[size];
        for (int i = 0; i < size; ++i) {
            UMMutableSelectTreeNode node = nodes.get(i);
            paths[i] = new TreePath(node.getPath());
        }
        this.getSelectionModel().addSelectionPaths(paths);
    }
}

