/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.component.selecttree.tree;

import com.huawei.u2000.umcommon.component.selecttree.UMSelectTreeData;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class UMMutableSelectTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = -5973242313519627341L;
    protected boolean hasChildren;
    protected Object childValue;
    protected boolean loadedChildren = false;
    protected boolean needLoadLater;

    public UMMutableSelectTreeNode() {
        this(null, null);
    }

    public UMMutableSelectTreeNode(Object value, Object children) {
        this(value, children, false);
    }

    public UMMutableSelectTreeNode(Object value, Object children, boolean loadLater) {
        super(value);
        this.childValue = children;
        this.needLoadLater = loadLater;
        if (children != null) {
            if (children instanceof Vector) {
                this.setAllowsChildren(true);
            } else if (children instanceof Hashtable) {
                this.setAllowsChildren(true);
            } else if (children instanceof Object[]) {
                this.setAllowsChildren(true);
            } else if (children instanceof List) {
                this.setAllowsChildren(true);
            } else {
                this.setAllowsChildren(false);
            }
        } else {
            this.setAllowsChildren(this.needLoadLater);
        }
    }

    public void createChildren(Object children) {
        UMSelectTreeData tmpData = null;
        Object[] childArray = null;
        if (children instanceof List) {
            childArray = ((List)children).toArray();
        }
        if (children instanceof Object[]) {
            childArray = (Object[])children;
        }
        if (childArray == null) {
            return;
        }
        if (childArray.length <= 0) {
            this.setAllowsChildren(false);
            return;
        }
        if (childArray[0] instanceof UMSelectTreeData) {
            int maxCounter = childArray.length;
            for (int counter = 0; counter < maxCounter; ++counter) {
                tmpData = (UMSelectTreeData)childArray[counter];
                if (tmpData == null) continue;
                this.add(new UMMutableSelectTreeNode(tmpData, tmpData.getChildren(), tmpData.hasChildren()));
            }
        }
    }

    public boolean isNeedloadLater() {
        return this.needLoadLater;
    }

    @Override
    public boolean isLeaf() {
        return !this.getAllowsChildren();
    }

    @Override
    public int getChildCount() {
        if (!this.loadedChildren) {
            this.loadChildren();
        }
        return super.getChildCount();
    }

    protected void loadChildren() {
        this.loadedChildren = true;
        this.createChildren(this.childValue);
    }

    public void clearChildren() {
        this.children = null;
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (!this.loadedChildren) {
            this.loadChildren();
        }
        return super.getChildAt(index);
    }

    public Enumeration children() {
        if (!this.loadedChildren) {
            this.loadChildren();
        }
        return super.children();
    }

    public int getStatus() {
        return 0;
    }
}

