/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.component.selecttree.tree;

import com.huawei.imap12.utility.InmResourceManager;
import com.huawei.u2000.umcommon.component.selecttree.UMSelectTreeAgent;
import com.huawei.u2000.umcommon.component.selecttree.UMSelectTreeData;
import com.huawei.u2000.umcommon.component.selecttree.common.UMSelectTreeResource;
import com.huawei.u2000.umcommon.component.selecttree.common.UMSelectTreeUtil;
import com.huawei.u2000.umcommon.component.selecttree.inf.IUMSelectTreeUserData;
import com.huawei.u2000.umcommon.component.selecttree.tree.UMMultiSelectTreeNode;
import com.huawei.u2000.umcommon.component.selecttree.tree.UMMutableSelectTreeNode;
import com.huawei.u2000.umcommon.component.selecttree.tree.UMSelectTree;
import com.huawei.u2000.util.UMLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class UMCheckBoxSelectTree
extends UMSelectTree {
    private static final long serialVersionUID = -4759902009981628453L;
    private static long startTime = 0L;
    private static long endTime = 0L;
    protected UMMultiSelectTreeNode root = null;
    protected UMMultiSelectTreeNode curNode = null;
    protected UMMultiSelectTreeNode curParentNode = null;
    private boolean bSelectAll = true;
    private DefaultTreeCellRenderer cellRenderer = new DefaultTreeCellRenderer(){
        private static final long serialVersionUID = 3917987937894718109L;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Component com = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            TreePath path = tree.getPathForRow(row);
            if (path == null) {
                return com;
            }
            UMMultiSelectTreeNode node = (UMMultiSelectTreeNode)path.getLastPathComponent();
            Component box = node.getComponent();
            if (node.isSearchedNode()) {
                box.setForeground(Color.blue);
            } else {
                box.setForeground(Color.black);
            }
            return box;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension customDimension = super.getPreferredSize();
            customDimension.width = 750;
            return customDimension;
        }

        @Override
        public Color getBackgroundSelectionColor() {
            return Color.red;
        }
    };

    public UMCheckBoxSelectTree() {
        this((UMSelectTreeData)null);
    }

    public UMCheckBoxSelectTree(UMSelectTreeData data) {
        this(data, null);
    }

    public UMCheckBoxSelectTree(UMSelectTreeData data, UMSelectTreeAgent adapter) {
        this(data, adapter, true);
    }

    public UMCheckBoxSelectTree(UMSelectTreeData data, UMSelectTreeAgent adapter, boolean bselectAll) {
        super(UMCheckBoxSelectTree.createTreeModel(data));
        this.dataAdapter = adapter;
        this.root = (UMMultiSelectTreeNode)this.getRoot();
        this.isNullTree = this.root.getChildCount() <= 0;
        this.bSelectAll = bselectAll;
        this.setCellRenderer(this.cellRenderer);
        this.cellRenderer.setClosedIcon(InmResourceManager.getIcon((String)UMSelectTreeResource.DIRECTORY_ICON_FILE));
        this.cellRenderer.setOpenIcon(InmResourceManager.getIcon((String)UMSelectTreeResource.TREEOPEN_ICON_FILE));
        this.cellRenderer.setLeafIcon(InmResourceManager.getIcon((String)UMSelectTreeResource.OPEN_ICON_FILE));
        if (this.bSelectAll) {
            this.setTreeAllSelected();
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (UMCheckBoxSelectTree.this.isEnabled) {
                    if (e.getModifiers() == 16) {
                        int row = UMCheckBoxSelectTree.this.getRowForLocation(e.getX(), e.getY());
                        UMCheckBoxSelectTree.this.actionSelect(row);
                    } else if (e.getModifiers() == 4) {
                        UMMultiSelectTreeNode node;
                        JPopupMenu menu;
                        Point p = e.getPoint();
                        TreePath tp = UMCheckBoxSelectTree.this.getPathForRow(UMCheckBoxSelectTree.this.getRowForLocation(p.x, p.y));
                        if (tp != null && (menu = UMCheckBoxSelectTree.this.dataAdapter.getPopupMenu((UMSelectTreeData)(node = (UMMultiSelectTreeNode)tp.getLastPathComponent()).getUserObject())) != null) {
                            menu.show(UMCheckBoxSelectTree.this, p.x, p.y);
                        }
                    }
                }
            }
        });
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                UMCheckBoxSelectTree.this.expandRow(0);
            }

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                UMMultiSelectTreeNode node = (UMMultiSelectTreeNode)event.getPath().getLastPathComponent();
                if (!node.isLeaf() && node.getChildCount() == 0) {
                    ArrayList<UMMultiSelectTreeNode> nodes = new ArrayList<UMMultiSelectTreeNode>();
                    nodes.add(node);
                    UMCheckBoxSelectTree.this.mountChildren(nodes);
                }
            }
        });
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setRowHeight(25);
        BasicTreeUI ui = (BasicTreeUI)this.getUI();
        ui.setCollapsedIcon(InmResourceManager.getIcon((String)UMSelectTreeResource.ADD_ICON_FILE));
        ui.setExpandedIcon(InmResourceManager.getIcon((String)UMSelectTreeResource.MINU_ICON_FILE));
        endTime = System.currentTimeMillis();
        UMSelectTreeUtil.printLocalTime("build objectcheckboxtree end,the time is:");
        UMLogger.debug("objectcheckboxtree build spend time: " + (endTime - startTime) + "(ms)");
    }

    protected static TreeModel createTreeModel(Object value) {
        UMSelectTreeUtil.printLocalTime("start build object checkbox tree time:");
        startTime = System.currentTimeMillis();
        UMSelectTreeData convertedData = null;
        try {
            convertedData = (UMSelectTreeData)value;
        }
        catch (Exception e) {
            UMLogger.error("object checkbox tree instance failed!");
            UMLogger.exception(e);
            return null;
        }
        UMMultiSelectTreeNode rootNode = new UMMultiSelectTreeNode(convertedData, convertedData.getChildren());
        return new DefaultTreeModel(rootNode, false);
    }

    @Override
    public void mountChildren(List nodes) {
        if (this.dataAdapter != null) {
            UMMultiSelectTreeNode node;
            int i;
            ArrayList<UMSelectTreeData> selectDatas = new ArrayList<UMSelectTreeData>();
            int size = nodes.size();
            for (i = 0; i < size; ++i) {
                node = (UMMultiSelectTreeNode)nodes.get(i);
                selectDatas.add((UMSelectTreeData)node.getUserObject());
            }
            this.dataAdapter.mountChildren(selectDatas);
            size = nodes.size();
            for (i = 0; i < size; ++i) {
                node = (UMMultiSelectTreeNode)nodes.get(i);
                node.createChildren(((UMSelectTreeData)node.getUserObject()).getChildren());
                ((DefaultTreeModel)this.getModel()).nodeStructureChanged(node);
                if (node.getStatus() == 3) {
                    this.setAllChildrenState(node, true);
                    continue;
                }
                this.setAllChildrenState(node, false);
            }
        } else {
            UMLogger.debug("the adatper is null ,load data failed by delay!");
        }
    }

    private void mountChildren(UMMutableSelectTreeNode node, List childrenData) {
        node.clearChildren();
        node.setAllowsChildren(true);
        node.createChildren(childrenData);
        ((DefaultTreeModel)this.getModel()).nodeStructureChanged(node);
        ((UMSelectTreeData)node.getUserObject()).setChildren(childrenData);
        this.setAllChildrenState((UMMultiSelectTreeNode)node, true);
        this.isNullTree = this.root.getChildCount() <= 0;
    }

    public boolean isTreeAllselected() {
        return this.getNodeState(this.root) == 3;
    }

    @Override
    public void rebuildTree(UMSelectTreeData[] data) {
    }

    @Override
    public void rebuildTree(List datas) {
        this.mountChildren(this.root, datas);
    }

    public int getNodeState(UMMultiSelectTreeNode node) {
        boolean bSet = false;
        int status = 1;
        int size = node.getChildCount();
        for (int i = 0; i < size; ++i) {
            this.curNode = (UMMultiSelectTreeNode)node.getChildAt(i);
            int status1 = this.curNode.getStatus();
            if (!bSet) {
                bSet = true;
                status = status1;
                continue;
            }
            if (status == status1) continue;
            return 2;
        }
        return status;
    }

    private void getSelectedNEData(UMSelectTreeData data, Set set) {
        List<UMSelectTreeData> children = data.getChildren();
        if (children != null && !children.isEmpty()) {
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                this.getSelectedNEData(children.get(i), set);
            }
        } else {
            set.add(data);
        }
    }

    protected void getSelectedChildren(UMMultiSelectTreeNode node, Set set, boolean reCursion) {
        Enumeration enumer = node.children();
        block5: while (enumer.hasMoreElements()) {
            UMMultiSelectTreeNode tmpNode = (UMMultiSelectTreeNode)enumer.nextElement();
            switch (tmpNode.getStatus()) {
                case 1: {
                    continue block5;
                }
                case 3: {
                    UMSelectTreeData tmpData = (UMSelectTreeData)tmpNode.getUserObject();
                    this.getSelectedNEData(tmpData, set);
                    continue block5;
                }
                case 2: {
                    this.getSelectedChildren(tmpNode, set, reCursion);
                    continue block5;
                }
            }
            UMLogger.debug("node type error!");
        }
    }

    public List getSelectedObject() {
        TreeSet set = new TreeSet();
        this.getSelectedChildren(this.root, set, false);
        return new Vector(set);
    }

    public void setTreeAllSelected() {
        this.setAllChildrenState(this.root, true);
        this.repaint();
    }

    public void setTreeAllUnSelected() {
        this.setAllChildrenState(this.root, false);
        this.repaint();
    }

    @Deprecated
    public boolean hasSingleNeAllSelected(int neid) {
        return false;
    }

    public void actionSelect(int row) {
        if (this.isNullTree) {
            return;
        }
        TreePath path = this.getPathForRow(row);
        if (path == null) {
            return;
        }
        this.curNode = (UMMultiSelectTreeNode)path.getLastPathComponent();
        int status = this.curNode.getStatus();
        if (status == 1) {
            this.setNodeSelected(this.curNode);
        } else {
            this.setNodeUnselected(this.curNode);
        }
    }

    protected void setNodeSelected(UMMultiSelectTreeNode node) {
        if (node != null) {
            this.setAllChildrenState(node, true);
            this.curParentNode = (UMMultiSelectTreeNode)node.getParent();
            while (this.curParentNode != null) {
                this.curParentNode.setStatus(this.getNodeState(this.curParentNode));
                this.curParentNode = (UMMultiSelectTreeNode)this.curParentNode.getParent();
            }
            this.repaint();
        }
    }

    protected void setNodeUnselected(UMMultiSelectTreeNode node) {
        if (node != null) {
            this.setAllChildrenState(node, false);
            this.curParentNode = (UMMultiSelectTreeNode)node.getParent();
            while (this.curParentNode != null) {
                this.curParentNode.setStatus(this.getNodeState(this.curParentNode));
                this.curParentNode = (UMMultiSelectTreeNode)this.curParentNode.getParent();
            }
            this.removeSelectionPath(new TreePath(node.getPath()));
            this.repaint();
        }
    }

    public void setNodeSelectedEnabledState(UMMultiSelectTreeNode node) {
        if (this.selectTreeModel.getChildCount(node) > 0 && this.root.equals(node.getParent()) || this.root.equals(node)) {
            node.setSelectedEnable(true);
        } else {
            node.setSelectedEnable(false);
        }
        int size = this.selectTreeModel.getChildCount(node);
        for (int j = 0; j < size; ++j) {
            UMMultiSelectTreeNode tmpNode = (UMMultiSelectTreeNode)this.selectTreeModel.getChild(node, j);
            this.setNodeSelectedEnabledState(tmpNode);
        }
    }

    public void setAllChildrenState(UMMultiSelectTreeNode node, boolean state) {
        node.setStatus(state ? 3 : 1);
        int size = this.selectTreeModel.getChildCount(node);
        for (int i = 0; i < size; ++i) {
            UMMultiSelectTreeNode tmpNode = (UMMultiSelectTreeNode)this.selectTreeModel.getChild(node, i);
            this.setAllChildrenState(tmpNode, state);
        }
    }

    @Override
    public void shrinkAll() {
        Enumeration nodeEnum = this.root.children();
        while (nodeEnum.hasMoreElements()) {
            UMMultiSelectTreeNode tmp = (UMMultiSelectTreeNode)nodeEnum.nextElement();
            this.setNodeExpandState(tmp, false);
        }
    }

    @Override
    public void expandAll() {
        UMMultiSelectTreeNode node;
        Enumeration<TreeNode> emu = this.getRoot().breadthFirstEnumeration();
        ArrayList<UMSelectTreeData> selectDatas = new ArrayList<UMSelectTreeData>();
        ArrayList<UMMultiSelectTreeNode> delayLoadNodes = new ArrayList<UMMultiSelectTreeNode>();
        while (emu.hasMoreElements()) {
            node = (UMMultiSelectTreeNode)emu.nextElement();
            if (!node.isLeaf() && node.getChildCount() == 0) {
                selectDatas.add((UMSelectTreeData)node.getUserObject());
                delayLoadNodes.add(node);
                continue;
            }
            if (node.isLeaf()) continue;
            TreePath path = new TreePath(node.getPath());
            this.expandPath(path);
        }
        if (!selectDatas.isEmpty() && this.dataAdapter != null) {
            this.dataAdapter.mountChildren(selectDatas);
            node = null;
            int size = delayLoadNodes.size();
            for (int i = 0; i < size; ++i) {
                node = (UMMultiSelectTreeNode)delayLoadNodes.get(i);
                node.createChildren(((UMSelectTreeData)node.getUserObject()).getChildren());
                ((DefaultTreeModel)this.getModel()).nodeStructureChanged(node);
                if (node.getStatus() == 3) {
                    this.setAllChildrenState(node, true);
                } else {
                    this.setAllChildrenState(node, false);
                }
                this.expandPath(new TreePath(node.getPath()));
            }
        }
    }

    private void setNodeExpandState(UMMultiSelectTreeNode node, boolean state, boolean expandAll) {
        UMMultiSelectTreeNode tmp = null;
        TreePath path = null;
        if (expandAll) {
            if (node.isLeaf()) {
                return;
            }
            Enumeration nodeEnum1 = node.children();
            while (nodeEnum1.hasMoreElements()) {
                tmp = (UMMultiSelectTreeNode)nodeEnum1.nextElement();
                this.setNodeExpandState(tmp, state);
            }
            path = new TreePath(node.getPath());
            this.setExpandedState(path, state);
        } else {
            Enumeration<TreeNode> nodeEnum2 = node.breadthFirstEnumeration();
            while (nodeEnum2.hasMoreElements()) {
                tmp = (UMMultiSelectTreeNode)nodeEnum2.nextElement();
                if (tmp.isLeaf() || state && tmp.isNeedloadLater() && tmp.getChildCount() <= 0) continue;
                path = new TreePath(tmp.getPath());
                this.setExpandedState(path, state);
            }
        }
    }

    private void setNodeExpandState(UMMultiSelectTreeNode node, boolean state) {
        this.setNodeExpandState(node, state, true);
    }

    public void refreshNodeSelectStatus(List neList) {
        this.setNodeUnselected(this.root);
        Enumeration<TreeNode> e = this.root.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            IUMSelectTreeUserData obj;
            UMMultiSelectTreeNode node = (UMMultiSelectTreeNode)e.nextElement();
            if (node.isRoot() || !neList.contains(obj = ((UMSelectTreeData)node.getUserObject()).getValue())) continue;
            this.setNodeSelected(node);
        }
    }

    @Override
    public void setNodeSelected(UMMutableSelectTreeNode node) {
        this.setNodeSelected((UMMultiSelectTreeNode)node);
    }

    @Override
    public void setNodeUnselected(UMMutableSelectTreeNode node) {
        this.setNodeUnselected((UMMultiSelectTreeNode)node);
    }
}

