/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.component.selecttree.filter;

import com.huawei.core.util.TEAbstractOriginalJDialog;
import com.huawei.imap12.utility.InmButton;
import com.huawei.imap12.utility.InmLengthLimitTextField;
import com.huawei.imap12.utility.help.InmHelpMgr;
import com.huawei.imap12.utility.sortTable.InmSortTable;
import com.huawei.imap12.utility.sortTable.SortableTableModel;
import com.huawei.u2000.inventory.common.util.UMValueNamePair;
import com.huawei.u2000.umcommon.component.selecttree.UMSelectTreeData;
import com.huawei.u2000.umcommon.component.selecttree.common.UMSelectTreeConstant;
import com.huawei.u2000.umcommon.component.selecttree.filter.UMSelectTreeSearTypeStruct;
import com.huawei.u2000.umcommon.component.selecttree.tree.UMMutableSelectTreeNode;
import com.huawei.u2000.umcommon.component.selecttree.tree.UMSelectTree;
import com.swimap.iview.commstyle.resource.ResourceMng;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class UMSelectTreeFilterDlg
extends TEAbstractOriginalJDialog {
    private static final long serialVersionUID = -8929393228075434421L;
    private UMSelectTree selectTree;
    private JPanel btnPanel = new JPanel();
    private JPanel objNameInputPanel = new JPanel();
    private JPanel mainPanel = new JPanel();
    private JPanel modePanel = new JPanel();
    private JPanel directionPanel = new JPanel();
    private JRadioButton[] searchModelRadioButtons = null;
    private ButtonGroup radioButtonGroup = new ButtonGroup();
    private Map<String, UMSelectTreeSearTypeStruct> searchTypeModelMap = null;
    private UMSelectTreeSearTypeStruct[] searchTypeModelNameList = null;
    private String[] searchTypeModelKeyList = null;
    private int checkedIndex = 0;
    private JScrollPane jScrollPane;
    private JCheckBox clearNodeBox;
    private InmSortTable objTable;
    private SortableTableModel objTableModel;
    private InmLengthLimitTextField objNameTextField = new InmLengthLimitTextField(64);
    private InmButton closeBtn;
    private InmButton allSelectBtn;
    private InmButton selectBtn;
    private List<TableDisplayObject> lastFoundNode = new ArrayList<TableDisplayObject>();
    private int searchIndex = 0;
    private int selectedIndex = 0;
    private List tableData = new Vector();
    private List tableDataBackup = new Vector();
    private Map<String, List<TableDisplayObject>> tableDataHM = new HashMap<String, List<TableDisplayObject>>();
    private Map<String, Map<Integer, TableDisplayObject>> groupSearchTypeHM = new HashMap<String, Map<Integer, TableDisplayObject>>();
    private static final byte OBJECT_NAME = 0;
    private static final byte ROWHEIGTH = 22;
    private static boolean flag = true;

    public UMSelectTreeFilterDlg(Frame frame, UMSelectTree selectTree, Map<String, UMSelectTreeSearTypeStruct> searchTypeModelMap) {
        super(frame, "", true);
        this.selectTree = selectTree;
        this.searchTypeModelMap = searchTypeModelMap;
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(2);
        this.setSize(345, 400);
        this.setResizable(false);
        this.setTitle(UMSelectTreeConstant.res.getString("ID_FIND_OBJ"));
        this.iniData();
        this.iniGUI();
    }

    public UMSelectTreeFilterDlg(JDialog parentDlg, UMSelectTree selectTree, Map<String, UMSelectTreeSearTypeStruct> searchTypeModelMap) {
        super((Dialog)parentDlg, "", true);
        this.selectTree = selectTree;
        this.searchTypeModelMap = searchTypeModelMap;
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setDefaultCloseOperation(2);
        this.setSize(345, 400);
        this.setResizable(false);
        this.setTitle(UMSelectTreeConstant.res.getString("ID_FIND_OBJ"));
        this.iniData();
        this.iniGUI();
    }

    private void setSearchModelCheckboxs() {
        Collection<UMSelectTreeSearTypeStruct> searchTypeModelCollection = this.searchTypeModelMap.values();
        Set<String> searchTypeModelKeySet = this.searchTypeModelMap.keySet();
        int searchModelSize = searchTypeModelCollection.size();
        this.searchTypeModelNameList = new UMSelectTreeSearTypeStruct[searchModelSize];
        this.searchTypeModelKeyList = new String[searchModelSize];
        this.searchModelRadioButtons = new JRadioButton[searchModelSize];
        int i = 0;
        for (String searchTypeKey : searchTypeModelKeySet) {
            UMSelectTreeSearTypeStruct searchType = this.searchTypeModelMap.get(searchTypeKey);
            this.searchModelRadioButtons[i] = new JRadioButton(searchType.getSearchName());
            this.radioButtonGroup.add(this.searchModelRadioButtons[i]);
            this.searchTypeModelNameList[i] = searchType;
            this.searchTypeModelKeyList[i] = searchTypeKey;
            this.groupSearchTypeHM.put(searchTypeKey, new HashMap());
            ++i;
        }
    }

    private void iniGUI() {
        InmHelpMgr.instance().helpComponent((Component)((Object)this), InmHelpMgr.instance().getHelpID("conciselysearch"));
        Vector<String> columnNames = new Vector<String>();
        String tableTitle = "";
        if (this.searchTypeModelMap.size() == 1) {
            UMSelectTreeSearTypeStruct searchTypeStruct = this.searchTypeModelMap.get(this.searchTypeModelKeyList[0]);
            tableTitle = searchTypeStruct.getSearchName();
            this.modePanel.setVisible(false);
        } else {
            tableTitle = UMSelectTreeConstant.res.getString("ID_OBJ_NAME");
        }
        columnNames.add(tableTitle);
        this.objTableModel = new SortableTableModel((Vector)this.tableData, columnNames){
            private static final long serialVersionUID = -8947227096423414008L;

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.objTable = new InmSortTable((DefaultTableModel)this.objTableModel);
        this.objTable.setCustomizable(false);
        this.objTable.getTableHeader().setReorderingAllowed(false);
        this.objTable.setRowHeight(22);
        this.objTable.getSelectionModel().setSelectionMode(2);
        this.closeBtn = new InmButton(UMSelectTreeConstant.res.getString("ID_CLOSE"));
        this.allSelectBtn = new InmButton(UMSelectTreeConstant.res.getString("ID_SELECT_ALL"));
        this.selectBtn = new InmButton(UMSelectTreeConstant.res.getString("ID_SELECT"));
        this.clearNodeBox = new JCheckBox(UMSelectTreeConstant.res.getString("ID_CLEAR_NODE"));
        this.selectBtn.setToolTipText(UMSelectTreeConstant.res.getString("TIPS_SELECT"));
        this.allSelectBtn.setToolTipText(UMSelectTreeConstant.res.getString("TIPS_SELECT_ALL"));
        this.closeBtn.setToolTipText(UMSelectTreeConstant.res.getString("ID_CLOSE"));
        this.addListener();
        this.jScrollPane = new JScrollPane((Component)this.objTable);
        this.modePanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), UMSelectTreeConstant.res.getString("ID_SEARCH_MODE")));
        this.directionPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), UMSelectTreeConstant.res.getString("ID_DIRECTION")));
        this.getContentPane().setLayout(new GridBagLayout());
        this.btnPanel.setLayout(new FlowLayout(1));
        this.objNameInputPanel.setLayout(new GridBagLayout());
        this.modePanel.setLayout(new GridBagLayout());
        this.directionPanel.setLayout(new GridBagLayout());
        this.mainPanel.setLayout(new GridBagLayout());
        this.objNameInputPanel.add((Component)new JLabel(UMSelectTreeConstant.res.getString("ID_SEARCH_CONTENT")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 2, 5), 1, 1));
        this.objNameInputPanel.add((Component)this.objNameTextField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 2, 5), 1, 1));
        this.btnPanel.add(this.clearNodeBox);
        if (this.selectTree.getSelectionModel().getSelectionMode() == 1) {
            this.clearNodeBox.setSelected(true);
            this.clearNodeBox.setEnabled(false);
            this.clearNodeBox.setVisible(false);
            this.allSelectBtn.setVisible(false);
            this.objTable.getSelectionModel().setSelectionMode(0);
        } else {
            this.clearNodeBox.setSelected(flag);
            this.allSelectBtn.setVisible(true);
            this.objTable.getSelectionModel().setSelectionMode(2);
        }
        this.clearNodeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                flag = !flag;
            }
        });
        this.btnPanel.add((Component)this.allSelectBtn);
        this.btnPanel.add((Component)this.selectBtn);
        this.btnPanel.add((Component)this.closeBtn);
        for (int i = 0; i < this.searchModelRadioButtons.length; ++i) {
            this.modePanel.add((Component)this.searchModelRadioButtons[i], new GridBagConstraints(i % 3, i / 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(2, 2, 2, 2), 1, 1));
        }
        this.initLayout();
        this.initComponents();
        this.initControlName();
    }

    private void initComponents() {
        this.initTxtListener();
        this.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UMSelectTreeFilterDlg.this.dispose();
            }
        });
        this.allSelectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UMSelectTreeFilterDlg.this.objTable.setRowSelectionInterval(0, UMSelectTreeFilterDlg.this.objTable.getRowCount() - 1);
                UMSelectTreeFilterDlg.this.doSelect();
            }
        });
        this.selectBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UMSelectTreeFilterDlg.this.doSelect();
            }
        });
        int selectedIndex = 0;
        for (int i = 0; i < this.searchModelRadioButtons.length; ++i) {
            if (!UMSelectTreeConstant.res.getString("ID_BY_NE").equals(this.searchModelRadioButtons[i].getText())) continue;
            selectedIndex = i;
        }
        this.searchModelRadioButtons[selectedIndex].doClick();
    }

    private void initTxtListener() {
        this.objNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                UMSelectTreeFilterDlg.this.doSearch(UMSelectTreeFilterDlg.this.objNameTextField.getText().trim());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                UMSelectTreeFilterDlg.this.doSearch(UMSelectTreeFilterDlg.this.objNameTextField.getText().trim());
            }
        });
    }

    private void addListener() {
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UMSelectTreeFilterDlg.this.checkedIndex = UMSelectTreeFilterDlg.this.getCheckedIndex();
                UMSelectTreeFilterDlg.this.objNameTextField.setText("");
                UMSelectTreeFilterDlg.this.objTableModel.setRowCount(0);
                UMSelectTreeFilterDlg.this.tableDataBackup.clear();
                UMSelectTreeFilterDlg.this.objTable.clearSortFlag();
                String searchKey = UMSelectTreeFilterDlg.this.searchTypeModelKeyList[UMSelectTreeFilterDlg.this.checkedIndex];
                List tmpData = (List)UMSelectTreeFilterDlg.this.tableDataHM.get(searchKey);
                if (tmpData == null) {
                    UMSelectTreeFilterDlg.this.buildFullTree(UMSelectTreeFilterDlg.this.selectTree.getRoot(), searchKey);
                    tmpData = (List)UMSelectTreeFilterDlg.this.tableDataHM.get(searchKey);
                }
                if (tmpData == null) {
                    return;
                }
                int index = tmpData.size();
                for (int j = 0; j < index; ++j) {
                    Vector rowData = new Vector(2);
                    rowData.add(tmpData.get(j));
                    UMSelectTreeFilterDlg.this.tableData.add(rowData);
                    UMSelectTreeFilterDlg.this.tableDataBackup.add(rowData);
                }
                UMSelectTreeFilterDlg.this.objTableModel.fireTableDataChanged();
                UMSelectTreeFilterDlg.this.allSelectBtn.setEnabled(UMSelectTreeFilterDlg.this.objTableModel.getRowCount() > 0);
                UMSelectTreeFilterDlg.this.selectBtn.setEnabled(UMSelectTreeFilterDlg.this.objTableModel.getRowCount() > 0);
                if (UMSelectTreeFilterDlg.this.objTableModel.getRowCount() > 0) {
                    UMSelectTreeFilterDlg.this.objTable.setRowSelectionInterval(0, 0);
                }
            }
        };
        for (int i = 0; i < this.searchModelRadioButtons.length; ++i) {
            this.searchModelRadioButtons[i].addActionListener(action);
        }
    }

    private int getCheckedIndex() {
        for (int i = 0; i < this.searchModelRadioButtons.length; ++i) {
            if (!this.searchModelRadioButtons[i].isSelected()) continue;
            return i;
        }
        return this.checkedIndex;
    }

    private void initLayout() {
        this.getContentPane().add((Component)this.objNameInputPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 1, new Insets(2, 2, 2, 2), 1, 1));
        this.getContentPane().add((Component)this.modePanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 11, 1, new Insets(2, 2, 2, 2), 1, 1));
        this.getContentPane().add((Component)this.jScrollPane, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 1, 1));
        this.getContentPane().add((Component)this.btnPanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 1, new Insets(2, 2, 2, 2), 1, 1));
    }

    private void iniData() {
        this.setSearchModelCheckboxs();
    }

    private void buildFullTree(UMMutableSelectTreeNode node, String searchTypeKey) {
        UMSelectTreeSearTypeStruct searchTypeStruct = this.searchTypeModelMap.get(searchTypeKey);
        int searchLevel = searchTypeStruct.getLevel();
        Enumeration<TreeNode> nodeEnum = node.breadthFirstEnumeration();
        ArrayList<UMMutableSelectTreeNode> mountNodeList = new ArrayList<UMMutableSelectTreeNode>();
        while (nodeEnum.hasMoreElements()) {
            UMMutableSelectTreeNode tmpNode = (UMMutableSelectTreeNode)nodeEnum.nextElement();
            UMSelectTreeData nodeData = (UMSelectTreeData)tmpNode.getUserObject();
            int nodeType = nodeData.getObjType();
            if (nodeType == searchLevel) {
                TableDisplayObject tmpDisplay;
                if (searchTypeStruct.isGroupSearch()) {
                    UMValueNamePair searchNamePair;
                    Map<String, UMValueNamePair> searchMap = nodeData.getValue().getSearchMap();
                    if (null == searchMap || null == (searchNamePair = searchMap.get(searchTypeKey))) continue;
                    int groupValue = searchNamePair.value;
                    String groupName = searchNamePair.name;
                    Map<Integer, TableDisplayObject> currentGroupSearchTypeHM = this.groupSearchTypeHM.get(searchTypeKey);
                    TableDisplayObject dis = currentGroupSearchTypeHM.get(groupValue);
                    if (dis != null) {
                        dis.nodeList.add(tmpNode);
                        continue;
                    }
                    if (-1 == groupValue) continue;
                    List<TableDisplayObject> tmpData = this.tableDataHM.get(searchTypeKey);
                    dis = new TableDisplayObject(groupName);
                    dis.nodeList.add(tmpNode);
                    currentGroupSearchTypeHM.put(groupValue, dis);
                    if (tmpData == null) {
                        tmpData = new ArrayList<TableDisplayObject>();
                        tmpData.add(dis);
                        this.tableDataHM.put(searchTypeKey, tmpData);
                        continue;
                    }
                    tmpData.add(dis);
                    continue;
                }
                List<TableDisplayObject> tmpData = this.tableDataHM.get(searchTypeKey);
                if (tmpData == null) {
                    tmpData = new ArrayList<TableDisplayObject>();
                    tmpDisplay = new TableDisplayObject(tmpNode);
                    tmpDisplay.nodeList.add(tmpNode);
                    tmpData.add(tmpDisplay);
                    this.tableDataHM.put(searchTypeKey, tmpData);
                    continue;
                }
                tmpDisplay = new TableDisplayObject(tmpNode);
                tmpDisplay.nodeList.add(tmpNode);
                tmpData.add(tmpDisplay);
                continue;
            }
            if (nodeType >= searchLevel || tmpNode.isLeaf() || tmpNode.getChildCount() > 0 || !nodeData.hasChildren()) continue;
            mountNodeList.add(tmpNode);
        }
        if (!mountNodeList.isEmpty()) {
            this.selectTree.mountChildren(mountNodeList);
            int size = mountNodeList.size();
            for (int i = 0; i < size; ++i) {
                UMMutableSelectTreeNode currentNode = (UMMutableSelectTreeNode)mountNodeList.get(i);
                Enumeration children = currentNode.children();
                if (null == children || !children.hasMoreElements()) {
                    UMSelectTreeData selectData = (UMSelectTreeData)currentNode.getUserObject();
                    selectData.setHasChildren(false);
                }
                this.buildFullTree((UMMutableSelectTreeNode)mountNodeList.get(i), searchTypeKey);
            }
        }
    }

    private void doSearch(String objName) {
        if (this.objTable != null) {
            this.objTable.clearSortFlag();
        }
        this.searchIndex = 0;
        Vector list = this.objTableModel.getDataVector();
        list.clear();
        int rowCount = this.tableDataBackup.size();
        while (this.searchIndex < rowCount) {
            TableDisplayObject foundNode = (TableDisplayObject)((Vector)this.tableDataBackup.get(this.searchIndex)).elementAt(0);
            Locale locale = ResourceMng.getInstance().getLocale();
            if (foundNode.toString().toUpperCase(locale).indexOf(objName.toUpperCase(locale)) != -1) {
                list.add(this.tableDataBackup.get(this.searchIndex));
                this.lastFoundNode.add(foundNode);
            }
            ++this.searchIndex;
        }
        this.objTableModel.fireTableDataChanged();
        if (list.isEmpty()) {
            this.allSelectBtn.setEnabled(false);
            this.selectBtn.setEnabled(false);
        } else {
            this.allSelectBtn.setEnabled(true);
            this.selectBtn.setEnabled(true);
            this.objTable.setRowSelectionInterval(0, 0);
        }
    }

    protected UMMutableSelectTreeNode doSearch() {
        int rowCount = this.objTable.getRowCount();
        if (0 >= rowCount) {
            return null;
        }
        int[] selectedRows = this.objTable.getSelectedRows();
        this.selectedIndex = null == selectedRows || selectedRows.length == 0 ? -1 : selectedRows[selectedRows.length - 1];
        int toSelectedIndex = this.selectedIndex;
        if (toSelectedIndex >= this.objTable.getRowCount()) {
            toSelectedIndex = 0;
        } else if (toSelectedIndex < 0) {
            toSelectedIndex = this.objTable.getRowCount() - 1;
        }
        Object foundNodeObj = this.objTable.getValueAt(toSelectedIndex, 0);
        if (null == foundNodeObj) {
            return null;
        }
        UMMutableSelectTreeNode foundNode = ((TableDisplayObject)foundNodeObj).getNode();
        if (foundNode != null) {
            this.objTable.setRowSelectionInterval(toSelectedIndex, toSelectedIndex);
            this.scrollToSelection();
            this.selectTree.clearSelection();
            this.selectTree.setNodeUnselected(this.selectTree.getRoot());
            this.selectTree.setNodeSelected(foundNode);
            TreePath treePath = this.getPath(foundNode);
            this.selectTree.setSelectionPath(treePath);
            Rectangle bounds = this.selectTree.getPathBounds(treePath);
            bounds.x = 0;
            this.selectTree.scrollRectToVisible(bounds);
        }
        return foundNode;
    }

    private void doSelect() {
        int[] rows = this.objTable.getSelectedRows();
        if (this.clearNodeBox.isSelected()) {
            this.clearSelection();
        }
        UMMutableSelectTreeNode node = null;
        ArrayList<TreePath> treePathList = new ArrayList<TreePath>();
        ArrayList<UMMutableSelectTreeNode> selectedNodes = new ArrayList<UMMutableSelectTreeNode>();
        this.searchIndex = 0;
        while (this.searchIndex < rows.length) {
            TableDisplayObject foundNode = (TableDisplayObject)this.objTable.getValueAt(rows[this.searchIndex], 0);
            if (foundNode.neType != null) {
                int size = foundNode.nodeList.size();
                for (int j = 0; j < size; ++j) {
                    TreePath treePath;
                    node = (UMMutableSelectTreeNode)foundNode.nodeList.get(j);
                    if (node.getStatus() != 3) {
                        selectedNodes.add(node);
                    }
                    if (treePathList.contains(treePath = this.getPath(node).getParentPath())) continue;
                    treePathList.add(treePath);
                }
            } else {
                TreePath treePath;
                node = foundNode.getNode();
                if (node.getStatus() != 3) {
                    selectedNodes.add(node);
                }
                if (!treePathList.contains(treePath = this.getPath(node).getParentPath())) {
                    treePathList.add(treePath);
                }
            }
            ++this.searchIndex;
        }
        int size = treePathList.size();
        for (int i = 0; i < size; ++i) {
            this.selectTree.expandPath((TreePath)treePathList.get(i));
        }
        if (!selectedNodes.isEmpty()) {
            this.selectTree.setNodesSelected(selectedNodes);
        }
        TreePath treePath = this.getPath(node);
        Rectangle bounds = this.selectTree.getPathBounds(treePath);
        bounds.x = 0;
        this.selectTree.scrollRectToVisible(bounds);
        this.scrollToSelection();
    }

    public TreePath getPath(UMMutableSelectTreeNode node) {
        if (null == node) {
            return null;
        }
        return new TreePath(node.getPath());
    }

    private void scrollToSelection() {
        int[] rows = this.objTable.getSelectedRows();
        if (rows.length <= 0) {
            return;
        }
        int row = rows[0];
        int count = this.objTable.getRowCount();
        int height = this.objTable.getRowHeight();
        int visHeight = this.objTable.getVisibleRect().height;
        int pos = row * height;
        int viewHeight = (int)this.jScrollPane.getViewport().getViewPosition().getY();
        if (pos > viewHeight && pos < viewHeight + visHeight) {
            return;
        }
        if ((count - 1) * height < pos) {
            pos = (count - 1) * height;
        }
        if (pos < height) {
            pos = height;
        }
        this.jScrollPane.getViewport().setViewPosition(new Point(0, pos - height));
    }

    public void dispose() {
        this.lastFoundNode.clear();
        this.tableData.clear();
        this.btnPanel = null;
        this.objNameInputPanel = null;
        this.mainPanel = null;
        this.modePanel = null;
        this.directionPanel = null;
        this.selectTree = null;
        super.dispose();
    }

    protected String getCancel_String() {
        return UMSelectTreeConstant.res.getString("ID_CLOSE");
    }

    private void initControlName() {
        for (int i = 0; i < this.searchModelRadioButtons.length; ++i) {
            this.searchModelRadioButtons[i].setName("_CheckBox_SelectTreeDlg_" + this.searchTypeModelKeyList[i]);
        }
        this.jScrollPane.setName("_JavaScrollPane_SelectTreeDlg_Obj");
        this.objTable.setName("_JavaTable_SelectTreeDlg_Obj");
        this.objNameTextField.setName("_EditBox_SelectTreeDlg_SearchElement");
        this.closeBtn.setName("_PushButton_SelectTreeDlg_Close");
        this.allSelectBtn.setName("_PushButton_SelectTreeDlg_AllSelect");
        this.selectBtn.setName("_PushButton_SelectTreeDlg_Select");
    }

    private int clearSelection() {
        this.lastFoundNode.clear();
        this.selectTree.clearSelection();
        this.selectTree.setNodeUnselected(this.selectTree.getRoot());
        int[] selectRows = this.objTable.getSelectedRows();
        int i = 0;
        if (selectRows.length > 0) {
            i = selectRows[0];
        }
        return i;
    }

    public void isDefaultFilterModel() {
        this.modePanel.setVisible(false);
        for (int i = 0; i < this.searchModelRadioButtons.length; ++i) {
            if (!UMSelectTreeConstant.res.getString("ID_NE").equals(this.searchModelRadioButtons[i].getText())) continue;
            this.searchModelRadioButtons[i].doClick();
        }
    }

    private static class TableDisplayObject {
        private Object value = null;
        private UMMutableSelectTreeNode node = null;
        private String nodeName = "";
        private List<UMMutableSelectTreeNode> nodeList = new ArrayList<UMMutableSelectTreeNode>();
        private String neType = "";

        public TableDisplayObject(UMMutableSelectTreeNode node) {
            this.node = node;
            this.value = ((UMSelectTreeData)node.getUserObject()).getValue();
            this.nodeName = this.setFullName((UMSelectTreeData)node.getUserObject());
        }

        private String setFullName(UMSelectTreeData selectData) {
            String name = selectData.getName();
            for (UMSelectTreeData parent = selectData.getParent(); null != parent; parent = parent.getParent()) {
                name = parent.getName() + "/" + name;
            }
            return name;
        }

        public TableDisplayObject(String neType) {
            this.neType = neType;
        }

        public UMMutableSelectTreeNode getNode() {
            return this.node;
        }

        public String toString() {
            if (this.neType != null && !this.neType.trim().equals("")) {
                return this.neType;
            }
            return this.nodeName;
        }
    }
}

