/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.component.selecttree;

import com.huawei.beans.util.ScreenToolkit;
import com.huawei.imap12.common.InmMainInterface;
import com.huawei.imap12.utility.InmButton;
import com.huawei.imap12.utility.InmResourceManager;
import com.huawei.u2000.inventory.common.util.UMValueNamePair;
import com.huawei.u2000.umcommon.component.selecttree.UMSelectTreeAgent;
import com.huawei.u2000.umcommon.component.selecttree.UMSelectTreeData;
import com.huawei.u2000.umcommon.component.selecttree.UMSelectTreeFactory;
import com.huawei.u2000.umcommon.component.selecttree.common.UMSelectTreeConstant;
import com.huawei.u2000.umcommon.component.selecttree.common.UMSelectTreeResource;
import com.huawei.u2000.umcommon.component.selecttree.filter.UMSelectTreeFilterDlg;
import com.huawei.u2000.umcommon.component.selecttree.filter.UMSelectTreeSearTypeStruct;
import com.huawei.u2000.umcommon.component.selecttree.inf.IUMSelectTreeUserData;
import com.huawei.u2000.umcommon.component.selecttree.tree.UMMutableSelectTreeNode;
import com.huawei.u2000.umcommon.component.selecttree.tree.UMSelectTree;
import com.huawei.u2000.umcommon.component.selecttree.tree.UMSelectTreeOutsideEvent;
import com.huawei.u2000.umcommon.component.selecttree.tree.UMSelectTreeOutsideNoticer;
import com.huawei.u2000.util.U2kUnitedUtilities;
import com.huawei.u2000.util.UMLogger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class UMSelectTreePanel
extends JPanel {
    private static final long serialVersionUID = -324203829845297672L;
    private boolean isEnable = true;
    private UMSelectTreeAgent agent;
    private byte treeType = 0;
    private boolean selectAll = true;
    private JButton applyButton = new JButton(">>");
    private JButton refreshBtn = new JButton(InmResourceManager.getIcon((String)UMSelectTreeResource.REFRESH_ICON_FILE));
    private boolean isNeedToRefresh = false;
    private JButton shrinkAllBtn = new InmButton();
    private JButton expandAllBtn = new InmButton();
    private JButton searchNEBtn = new InmButton();
    protected JPanel bottomPanel = new JPanel();
    private UMSelectTree selectObjTree;
    private List<UMSelectTreeData> datas;
    private JPanel btnPanel = new JPanel();
    private String rootName = null;
    private boolean isDefaultFilterMode = false;
    private JToolBar tb = null;
    private JPanel parentPanel = null;

    public UMSelectTreePanel(byte treeType) {
        this(null, treeType);
    }

    public UMSelectTreePanel(UMSelectTreeAgent agent, byte treeType) {
        this(agent, treeType, null);
    }

    public UMSelectTreePanel(UMSelectTreeAgent agent, byte treeType, List datas) {
        this(agent, treeType, datas, true);
    }

    public UMSelectTreePanel(UMSelectTreeAgent agent, byte treeType, List<UMSelectTreeData> datas, boolean selectAll) {
        this.agent = agent;
        this.treeType = treeType;
        this.datas = datas;
        this.selectAll = selectAll;
        this.builTree();
        this.addTreeListeners();
        this.initUI();
        this.addPanelControlListeners();
        this.intiNoticers();
        this.initControlName();
        UMLogger.debug("[object tree log]Build tree init data End!");
    }

    public void updateSelectedObject() {
        this.clearApplyButtonState();
        this.agent.updateSelectedObject(this.getSelectedObject());
    }

    public List<?> getSelectedObjList() {
        return this.agent.getCustomSelectedData(this.getSelectedObject());
    }

    public List<UMSelectTreeData> getSelectedObject() {
        return this.selectObjTree.getSelectedObject();
    }

    public void refreshTree() {
        if (this.datas != null && !this.datas.isEmpty()) {
            this.selectObjTree.rebuildTree(this.datas);
        } else if (this.agent != null) {
            this.selectObjTree.rebuildTree(this.agent.getTreeDataList());
        }
        this.clearRefreshButtonState();
    }

    public void refreshEmptyTree() {
        this.datas.clear();
        this.selectObjTree.rebuildTree(this.datas);
        this.clearRefreshButtonState();
    }

    private JDialog windowForComponent(Component aComponent) {
        for (Container p = aComponent.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof JDialog)) continue;
            return (JDialog)p;
        }
        return null;
    }

    public void clearRefreshButtonState() {
        this.refreshBtn.setBackground(null);
        this.isNeedToRefresh = false;
        this.refreshBtn.setToolTipText(null);
        if (this.agent != null) {
            this.agent.doRefreshTree();
        }
    }

    public void setApplyButtonState() {
        this.applyButton.setBackground(Color.RED);
        this.applyButton.setToolTipText(UMSelectTreeConstant.res.getString("ID_SELCHANGEREAPPLY"));
    }

    public void clearApplyButtonState() {
        this.applyButton.setBackground(null);
        this.applyButton.setToolTipText(null);
    }

    public void clearData() {
        if (null != this.selectObjTree) {
            this.selectObjTree.removeAll();
            UMMutableSelectTreeNode root = this.selectObjTree.getRoot();
            if (null != root) {
                root.clearChildren();
            }
        }
        if (null != this.datas) {
            this.datas.clear();
            this.datas = null;
        }
        this.agent = null;
    }

    private void builTree() {
        this.setRootName();
        UMSelectTreeData root = this.makeNodes();
        UMSelectTreeFactory treeFactory = new UMSelectTreeFactory(root, this.agent, this.selectAll);
        this.selectObjTree = treeFactory.makeTree(this.treeType);
        UMLogger.debug("[object tree log]Build tree End!");
    }

    private void addTreeListeners() {
        if (this.selectObjTree == null) {
            return;
        }
        this.selectObjTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getNewLeadSelectionPath();
                if (path != null) {
                    UMMutableSelectTreeNode node = (UMMutableSelectTreeNode)path.getLastPathComponent();
                    int treeModel = UMSelectTreePanel.this.selectObjTree.getSelectionModel().getSelectionMode();
                    if (1 != treeModel || node.isLeaf()) {
                        UMSelectTreePanel.this.setApplyButtonEnabled(true);
                        UMSelectTreePanel.this.setApplyButtonState();
                    }
                } else {
                    path = e.getOldLeadSelectionPath();
                    if (path != null) {
                        UMSelectTreePanel.this.setApplyButtonEnabled(true);
                        UMSelectTreePanel.this.setApplyButtonState();
                    }
                }
            }
        });
    }

    private UMSelectTreeData makeNodes() {
        UMSelectTreeData root = null;
        IUMSelectTreeUserData rootUserData = new IUMSelectTreeUserData(){

            @Override
            public Map<String, UMValueNamePair> getSearchMap() {
                return null;
            }

            @Override
            public Object getUserValue() {
                return UMSelectTreePanel.this.rootName;
            }

            public String toString() {
                return UMSelectTreePanel.this.rootName;
            }
        };
        root = null == this.datas && null != this.agent ? new UMSelectTreeData(rootUserData, this.agent.getTreeDataList()) : (null != this.datas ? new UMSelectTreeData(rootUserData, this.datas) : new UMSelectTreeData(rootUserData, null));
        return root;
    }

    private void setRootName() {
        this.rootName = this.agent.getRootNodeName();
        if (U2kUnitedUtilities.isNull(this.rootName)) {
            this.rootName = "root";
        }
    }

    private void initUI() {
        this.setLayout(new GridBagLayout());
        this.refreshBtn.setToolTipText(InmButton.REFRESH_TEXT_PROPERTY);
        this.applyButton.setBorder(BorderFactory.createEtchedBorder());
        JScrollPane selectedObjScrlPane = new JScrollPane();
        this.btnPanel.setLayout(new GridBagLayout());
        this.tb = new JToolBar();
        this.tb.add(this.refreshBtn);
        this.tb.addSeparator();
        this.tb.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.tb.setFloatable(false);
        this.bottomPanel = new JPanel(new FlowLayout(1, 10, 10));
        this.expandAllBtn.setText(UMSelectTreeConstant.res.getString("ID_EXPAND"));
        this.shrinkAllBtn.setText(UMSelectTreeConstant.res.getString("ID_SHRINK"));
        this.searchNEBtn.setText(UMSelectTreeConstant.res.getString("SEARCH"));
        this.bottomPanel.add(this.expandAllBtn);
        this.bottomPanel.add(this.shrinkAllBtn);
        this.bottomPanel.add(this.searchNEBtn);
        Dimension refreshBtnSize = new Dimension(28, 29);
        this.refreshBtn.setSize(refreshBtnSize);
        Dimension applyBtnSize = new Dimension(18, 22);
        this.applyButton.setSize(applyBtnSize);
        this.add((Component)this.btnPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.applyButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 2, new Insets(10, 10, 3, 8), 30, 0));
        this.add((Component)selectedObjScrlPane, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.bottomPanel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
        selectedObjScrlPane.getViewport().add(this.selectObjTree);
        this.btnPanel.add((Component)this.tb, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(6, 10, 6, 0), 1, 0));
        ScreenToolkit.registerKeyAction((Container)this, (AbstractButton)this.searchNEBtn, (int)2, (KeyStroke)KeyStroke.getKeyStroke(70, 2));
        this.setMinimumSize(new Dimension(this.tb.getPreferredSize().width + this.applyButton.getPreferredSize().width, this.tb.getPreferredSize().height));
        LinkedHashMap<String, UMSelectTreeSearTypeStruct> searchMap = this.agent.getDataSource().getSearchTypeModelMap();
        if (null == searchMap) {
            this.searchNEBtn.setVisible(false);
        }
        if (null != searchMap && searchMap.size() < 1) {
            this.searchNEBtn.setEnabled(false);
        }
    }

    private void intiNoticers() {
        List<UMSelectTreeOutsideNoticer> noticerList = this.agent.getDataSource().getOutsideNoticerList();
        if (null == noticerList) {
            return;
        }
        int size = noticerList.size();
        for (int i = 0; i < size; ++i) {
            noticerList.get(i).setTreePanel(this);
        }
    }

    private void addPanelControlListeners() {
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UMSelectTreePanel.this.updateSelectedObject();
            }
        });
        this.expandAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UMSelectTreePanel.this.expandAll();
            }
        });
        this.shrinkAllBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UMSelectTreePanel.this.selectObjTree != null) {
                    UMSelectTreePanel.this.selectObjTree.shrinkAll();
                }
            }
        });
        this.refreshBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UMSelectTreePanel.this.refreshTree();
            }
        });
        this.searchNEBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (UMSelectTreePanel.this.selectObjTree != null) {
                    UMSelectTreeFilterDlg filterDlg = null;
                    filterDlg = null == UMSelectTreePanel.this.parentPanel ? new UMSelectTreeFilterDlg(InmMainInterface.instance().getMainFrame(), UMSelectTreePanel.this.selectObjTree, UMSelectTreePanel.this.agent.getDataSource().getSearchTypeModelMap()) : new UMSelectTreeFilterDlg(UMSelectTreePanel.this.windowForComponent(UMSelectTreePanel.this.parentPanel), UMSelectTreePanel.this.selectObjTree, UMSelectTreePanel.this.agent.getDataSource().getSearchTypeModelMap());
                    ScreenToolkit.centerLocateToScreen((Component)((Object)filterDlg));
                    if (UMSelectTreePanel.this.isDefaultFilterMode) {
                        filterDlg.isDefaultFilterModel();
                    }
                    filterDlg.setVisible(true);
                }
            }
        });
    }

    public void shrinkAll() {
        if (this.selectObjTree != null) {
            this.selectObjTree.shrinkAll();
        }
    }

    public void responseOutsideEvent(UMSelectTreeOutsideEvent outsideEvent) {
        if (UMSelectTreeOutsideEvent.EventType.NODE_CHANGE.equals((Object)outsideEvent.getEventType())) {
            this.setRefreshButtonState();
        }
    }

    public void expandAll() {
        if (this.selectObjTree != null) {
            this.selectObjTree.expandAll();
        }
    }

    public void setDatas(List<UMSelectTreeData> datas) {
        this.datas = datas;
    }

    public List<UMSelectTreeData> getDatas() {
        return this.datas;
    }

    public void setApplyButtonEnabled(boolean enable) {
        this.applyButton.setEnabled(enable);
    }

    public void setApplyButtonVisible(boolean visible) {
        this.applyButton.setVisible(visible);
    }

    public void setShrinkAllBtnVisible(boolean visible) {
        this.shrinkAllBtn.setVisible(visible);
    }

    public void setExpandAllBtnVisible(boolean visible) {
        this.expandAllBtn.setVisible(visible);
    }

    public void setRefreshBtnVisible(boolean visible) {
        this.refreshBtn.setVisible(visible);
    }

    public void setRefreshButtonState() {
        this.refreshBtn.setBackground(Color.RED);
        this.isNeedToRefresh = true;
        this.refreshBtn.setToolTipText(UMSelectTreeConstant.res.getString("ID_SELCHANGEREREFRESH"));
    }

    public void setSearchBtnVisible(boolean visible) {
        this.searchNEBtn.setVisible(visible);
    }

    public UMSelectTree getObjectSelectTree() {
        return this.selectObjTree;
    }

    public void setObjectSelectTree(UMSelectTree selectObjTree) {
        this.selectObjTree = selectObjTree;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    public void hidenButtonPanel() {
        this.btnPanel.setVisible(false);
    }

    public void setObjectTreeEnable(boolean isEnable) {
        this.isEnable = isEnable;
        this.refreshBtn.setEnabled(isEnable);
        this.applyButton.setEnabled(isEnable);
        this.shrinkAllBtn.setEnabled(isEnable);
        this.expandAllBtn.setEnabled(isEnable);
        this.searchNEBtn.setEnabled(isEnable);
        this.bottomPanel.setEnabled(isEnable);
        this.btnPanel.setEnabled(isEnable);
        this.selectObjTree.setEnabled(isEnable);
    }

    public boolean getEnabled() {
        return this.isEnable;
    }

    public void addButton(JButton button) {
        this.bottomPanel.add(button);
    }

    private void initControlName() {
        this.applyButton.setName("_PushButton_SelectTree_Apply");
        this.refreshBtn.setName("_PushButton_SelectTree_Refresh");
        this.shrinkAllBtn.setName("_PushButton_SelectTree_Shrink");
        this.expandAllBtn.setName("_PushButton_SelectTree_Expand");
        this.searchNEBtn.setName("_PushButton_SelectTreev_Search");
        this.selectObjTree.setName("_JavaTree_SelectTree_SelectObj");
    }

    public UMSelectTreeAgent getAgent() {
        return this.agent;
    }

    public void setAgent(UMSelectTreeAgent agent) {
        this.agent = agent;
    }

    public boolean isSelectAll() {
        return this.selectAll;
    }

    public void setToolBarVisible(boolean visible) {
        this.tb.setVisible(visible);
    }

    public void setBottomPanelVisible(boolean visible) {
        this.bottomPanel.setVisible(visible);
    }

    public void setSelectAll(boolean selectAll) {
        this.selectAll = selectAll;
    }

    public byte getTreeType() {
        return this.treeType;
    }

    public void setTreeType(byte treeType) {
        this.treeType = treeType;
    }

    public void setApplyBtnName(String btnName) {
        this.applyButton.setText(btnName);
    }

    public void setParentPanel(JPanel parentPanel) {
        this.parentPanel = parentPanel;
    }

    public boolean isNeedToRefresh() {
        return this.isNeedToRefresh;
    }

    public void setNeedToRefresh(boolean isNeedToRefresh) {
        this.isNeedToRefresh = isNeedToRefresh;
    }
}

