/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.component.selecttree;

import com.huawei.u2000.umcommon.component.selecttree.UMSelectTreeAgent;
import com.huawei.u2000.umcommon.component.selecttree.UMSelectTreeData;
import com.huawei.u2000.umcommon.component.selecttree.tree.UMCheckBoxSelectTree;
import com.huawei.u2000.umcommon.component.selecttree.tree.UMSelectTree;
import com.huawei.u2000.umcommon.component.selecttree.tree.UMSingleSelectTree;
import com.huawei.u2000.util.UMLogger;

public final class UMSelectTreeFactory {
    private UMSelectTreeData root = null;
    private UMSelectTreeAgent agent = null;
    private boolean isSelectAll = true;

    public UMSelectTreeFactory() {
    }

    public UMSelectTreeFactory(UMSelectTreeData root, UMSelectTreeAgent agent, boolean isSelectAll) {
        this.root = root;
        this.agent = agent;
        this.isSelectAll = isSelectAll;
    }

    public UMSelectTreeFactory(UMSelectTreeData root, UMSelectTreeAgent agent) {
        this.root = root;
        this.agent = agent;
    }

    public UMSelectTree makeTree(int treeType) {
        UMSelectTree selectTree = null;
        switch (treeType) {
            case 1: {
                selectTree = new UMSingleSelectTree(this.root, this.agent, this.isSelectAll);
                break;
            }
            case 0: {
                selectTree = new UMCheckBoxSelectTree(this.root, this.agent, this.isSelectAll);
                break;
            }
            default: {
                UMLogger.debug("!!!the type of tree haven't been defined!");
            }
        }
        return selectTree;
    }

    public void setRoot(UMSelectTreeData root) {
        this.root = root;
    }

    public void setAgent(UMSelectTreeAgent agent) {
        this.agent = agent;
    }

    public void setSelectAll(boolean isSelectAll) {
        this.isSelectAll = isSelectAll;
    }
}

