/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.component.selecttree;

import com.huawei.u2000.umcommon.component.selecttree.UMStructNameStrategy;
import com.huawei.u2000.umcommon.component.selecttree.inf.IUMSelectTreeUserData;
import com.huawei.u2000.util.UMLogger;
import java.util.List;

public class UMSelectTreeData
implements Comparable<UMSelectTreeData> {
    private IUMSelectTreeUserData value;
    private UMSelectTreeData parent;
    private boolean hasChildren;
    private List<UMSelectTreeData> children;
    private int selectMode = 1;
    private int objType = -1;
    private String name;

    public UMSelectTreeData(IUMSelectTreeUserData value) {
        this(value, null);
    }

    public UMSelectTreeData(IUMSelectTreeUserData value, List<UMSelectTreeData> children) {
        this(value, null, children);
    }

    public UMSelectTreeData(IUMSelectTreeUserData value, String name, List<UMSelectTreeData> children) {
        this.value = value;
        this.children = children;
        this.name = name;
        if (this.name == null) {
            this.name = this.getName();
        }
        if (children != null && !children.isEmpty()) {
            this.initNode(name, children);
        }
    }

    private void initNode(String name, List<UMSelectTreeData> children) {
        this.hasChildren = true;
        boolean hasAllSelect = false;
        boolean hasNoneSelect = false;
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            if (children.get(i) instanceof UMSelectTreeData) {
                int childSelectMode = children.get(i).getSelectMode();
                if (childSelectMode == 2) {
                    this.selectMode = 2;
                    break;
                }
                if (childSelectMode == 3) {
                    hasAllSelect = true;
                    if (!hasNoneSelect) continue;
                    break;
                }
                hasNoneSelect = true;
                if (!hasAllSelect) continue;
                break;
            }
            UMLogger.debug(name);
        }
        if (hasAllSelect && hasNoneSelect) {
            this.selectMode = 2;
        } else if (hasAllSelect && !hasNoneSelect) {
            this.selectMode = 3;
        }
    }

    public final String getName() {
        Object userData = this.value.getUserValue();
        String result = "";
        if (userData != null) {
            if (userData instanceof UMStructNameStrategy) {
                return ((UMStructNameStrategy)((Object)this.value)).getStrategicalName(1);
            }
            return userData.toString();
        }
        return result;
    }

    public List<UMSelectTreeData> getChildren() {
        return this.children;
    }

    public void setChildren(List<UMSelectTreeData> children) {
        this.children = children;
        if (children != null) {
            this.hasChildren = true;
        }
    }

    public void setObjType(int objType) {
        this.objType = objType;
    }

    public int getObjType() {
        return this.objType;
    }

    public void setHasChildren(boolean hasChildren) {
        this.hasChildren = hasChildren;
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    public IUMSelectTreeUserData getValue() {
        return this.value;
    }

    public void setValue(IUMSelectTreeUserData value) {
        this.value = value;
    }

    public int getSelectMode() {
        return this.selectMode;
    }

    public void setSelectMode(int selectMode) {
        this.selectMode = selectMode;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(UMSelectTreeData o) {
        if (this == o) {
            return 0;
        }
        if (!(o instanceof UMSelectTreeData)) {
            return 1;
        }
        UMSelectTreeData tmp = o;
        String lname = this.toString();
        String rname = tmp.toString();
        if (lname != null && rname != null) {
            int cmp = lname.compareTo(rname);
            if (cmp == 0 && this.value != null && !this.value.equals(tmp.value)) {
                cmp = 1;
            }
            return cmp;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UMSelectTreeData) {
            return this.compareTo((UMSelectTreeData)obj) == 0;
        }
        return false;
    }

    public int hashCode() {
        if (this.name == null || this.value == null) {
            return super.hashCode();
        }
        int result = this.name.hashCode() * 31 + this.value.hashCode();
        return result;
    }

    public UMSelectTreeData getParent() {
        return this.parent;
    }

    public void setParent(UMSelectTreeData parent) {
        this.parent = parent;
    }

    public void setName(String name) {
        this.name = name;
    }
}

