/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.component.objselect;

import com.huawei.imap12.topo.InmTopoSubnet;
import com.huawei.imap12.topo.InmTopoUtil;
import com.huawei.imap12.utility.InmCommonUtil;
import com.huawei.imap12.utility.InmToolkit;
import com.huawei.imap12.utility.log.InmLogging;
import com.huawei.u2000.basetool.UMFrameAppAdapter;
import com.huawei.u2000.basetool.uid.StrUIDFactory;
import com.huawei.u2000.inventory.common.util.UMValueNamePair;
import com.huawei.u2000.umcommon.component.objselect.DeviceTypeStruct;
import com.huawei.u2000.umcommon.component.objselect.UMObjTreeConstants;
import com.huawei.u2000.umcommon.component.objselect.UMObjTreeStruct;
import com.huawei.u2000.umcommon.component.objselect.UMObjTreeUserData;
import com.huawei.u2000.umcommon.component.selecttree.UMSelectTreeData;
import com.huawei.u2000.util.U2kUnitedUtilities;
import com.huawei.u2000.util.UMFDNUtil;
import com.huawei.u2000.util.UMLogger;
import com.swimap.external.resource.client.emf.EmfTopoDeviceType;
import com.swimap.external.topo.adapter.message.EmfTopoContainerInfo;
import com.swimap.external.topo.adapter.message.EmfTopoInterface;
import com.swimap.external.topo.adapter.message.EmfTopoNodeInfo;
import com.swimap.external.topo.adapter.message.EmfTopoObjectInfo;
import com.swimap.external.topo.adapter.message.EmfTopoResource;
import com.swimap.external.topo.adapter.message.EmfTopoSubmapInfo;
import com.swimap.external.topo.adapter.message.EmfTopoTreeModelFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class UMObjTreeUtil {
    private static final int UNINVALAIBLE_FDN_NE_ID = 0;

    private UMObjTreeUtil() {
    }

    public static List<UMSelectTreeData> buildTreeFromTopo(List<UMSelectTreeData> neInfoList, boolean isContainLocalNM, boolean isContainThirdpartyNe, DeviceTypeStruct[] thirdParyNETypes, boolean isContainOS) {
        long buildTreeFromTopoStartTime = System.currentTimeMillis();
        UMLogger.debug("[object tree log]Build tree from topo Start!");
        List<UMSelectTreeData> resultDataList = new ArrayList<UMSelectTreeData>();
        Map<String, UMSelectTreeData> showNEInfoMap = UMObjTreeUtil.adapterNEToNEMap(neInfoList);
        UMSelectTreeData rootData = UMObjTreeUtil.getTreeModelDataFromTopo(null, showNEInfoMap);
        if (rootData != null) {
            UMObjTreeUtil.trimTreeNode(rootData, showNEInfoMap, isContainThirdpartyNe, thirdParyNETypes, isContainOS);
            resultDataList = rootData.getChildren();
        }
        resultDataList = UMObjTreeUtil.sortObjects(resultDataList);
        ArrayList<UMSelectTreeData> resultList = new ArrayList<UMSelectTreeData>();
        if (isContainLocalNM && !InmToolkit.isLCT()) {
            StrUIDFactory fdnFactory = new StrUIDFactory();
            fdnFactory.append("OS", 1L);
            String fdn = fdnFactory.getStr();
            String localNMNmame = "NMS";
            EmfTopoResource toppResource = InmTopoUtil.getTopoInterface().getResourceByID(fdn);
            if (null != toppResource) {
                localNMNmame = toppResource.m_szLabel;
            }
            UMObjTreeUserData localNM = new UMObjTreeUserData(new UMObjTreeStruct(fdn, localNMNmame));
            UMSelectTreeData objData = new UMSelectTreeData(localNM);
            objData.setObjType(5);
            resultList.add(objData);
        }
        resultList.addAll(resultDataList);
        UMLogger.debug("[object tree log]Build tree from topo Cost:" + (System.currentTimeMillis() - buildTreeFromTopoStartTime));
        UMLogger.debug("[object tree log]Build tree from topo End!");
        return resultList;
    }

    private static List<UMSelectTreeData> sortObjects(List<UMSelectTreeData> dataList) {
        ArrayList<UMSelectTreeData> resultList = new ArrayList<UMSelectTreeData>();
        if (null == dataList) {
            return resultList;
        }
        ArrayList<UMSelectTreeData> subnetList = new ArrayList<UMSelectTreeData>();
        ArrayList<UMSelectTreeData> neList = new ArrayList<UMSelectTreeData>();
        int size = dataList.size();
        for (int i = 0; i < size; ++i) {
            UMSelectTreeData tmpdata = dataList.get(i);
            if (tmpdata.toString().equals("1600G")) {
                UMLogger.debug("");
            }
            if (0 == tmpdata.getObjType()) {
                subnetList.add(tmpdata);
                continue;
            }
            if (1 == tmpdata.getObjType()) {
                neList.add(tmpdata);
                Collections.sort(tmpdata.getChildren());
                continue;
            }
            neList.add(tmpdata);
        }
        UMObjTreeUtil.sortSubnetList(subnetList);
        Collections.sort(neList);
        resultList.addAll(subnetList);
        resultList.addAll(neList);
        return resultList;
    }

    private static void sortSubnetList(List<UMSelectTreeData> dataList) {
        int n = dataList.size();
        for (int ii = 0; ii < n; ++ii) {
            UMSelectTreeData tmpsub = dataList.get(ii);
            UMObjTreeUtil.sortSubnet(tmpsub);
        }
        Collections.sort(dataList);
    }

    private static void sortSubnet(UMSelectTreeData dataList) {
        List<UMSelectTreeData> tmpList = dataList.getChildren();
        ArrayList<UMSelectTreeData> subnetList = new ArrayList<UMSelectTreeData>();
        ArrayList<UMSelectTreeData> neList = new ArrayList<UMSelectTreeData>();
        int size = tmpList.size();
        for (int i = 0; i < size; ++i) {
            UMSelectTreeData tmpdata = tmpList.get(i);
            if (0 == tmpdata.getObjType()) {
                subnetList.add(tmpdata);
                continue;
            }
            if (1 == tmpdata.getObjType()) {
                neList.add(tmpdata);
                Collections.sort(tmpdata.getChildren());
                continue;
            }
            neList.add(tmpdata);
        }
        if (!subnetList.isEmpty()) {
            UMObjTreeUtil.sortSubnetList(subnetList);
        }
        dataList.getChildren().clear();
        dataList.getChildren().addAll(subnetList);
        Collections.sort(neList);
        dataList.getChildren().addAll(neList);
    }

    public static void sortTree(List<UMSelectTreeData> objList) {
        if (objList != null) {
            Collections.sort(objList);
            for (UMSelectTreeData data : objList) {
                UMObjTreeUtil.sort(data);
            }
        }
    }

    private static void sort(UMSelectTreeData data) {
        List<UMSelectTreeData> children = data.getChildren();
        if (children != null && !children.isEmpty() && 5 < data.getObjType()) {
            Collections.sort(children);
            for (UMSelectTreeData tmpData : children) {
                UMObjTreeUtil.sort(tmpData);
            }
        }
    }

    public static EmfTopoSubmapInfo getTopoSubmapInfo(String submapID) {
        return (EmfTopoSubmapInfo)UMObjTreeUtil.getTopoObjectInfo(submapID);
    }

    public static EmfTopoObjectInfo getTopoObjectInfo(String nodeID) {
        String fdnNeID = InmCommonUtil.getObjFDNFromResID((String)nodeID);
        LinkedList topoObjectList = UMObjTreeUtil.getEmfTopoInterface().getTopoNode(new String[]{fdnNeID});
        if (null == topoObjectList || topoObjectList.size() <= 0) {
            return null;
        }
        return (EmfTopoObjectInfo)topoObjectList.get(0);
    }

    private static EmfTopoInterface getEmfTopoInterface() {
        return (EmfTopoInterface)UMFrameAppAdapter.getInstance().getLocalModule("com.swimap.adapter.message.tm", false);
    }

    private static void trimTreeNode(UMSelectTreeData rootData, Map<String, UMSelectTreeData> showNEInfoMap, boolean isContainThirdPartyNe, DeviceTypeStruct[] thirdParyNETypes, boolean isContainOS) {
        UMObjTreeUtil.isAvailableNode(rootData, showNEInfoMap, isContainThirdPartyNe, thirdParyNETypes, isContainOS);
    }

    private static boolean isAvailableNode(UMSelectTreeData nodeData, Map<String, UMSelectTreeData> showNEInfoMap, boolean isContainThirdPartyNe, DeviceTypeStruct[] thirdParyNETypes, boolean isContainOS) {
        if (nodeData == null) {
            return true;
        }
        if ((nodeData.getObjType() > 5 || nodeData.getValue().getUserValue() instanceof InmTopoSubnet) && !nodeData.hasChildren()) {
            return false;
        }
        List<UMSelectTreeData> childrenList = nodeData.getChildren();
        if (UMObjTreeUtil.isNeedCheckChildren(nodeData)) {
            boolean isAvailableFlag = false;
            for (int i = childrenList.size() - 1; i >= 0; --i) {
                UMObjTreeStruct userObjData;
                String tempFDN;
                UMSelectTreeData obj;
                UMSelectTreeData nodeDataTmp = childrenList.get(i);
                if (!UMObjTreeUtil.isAvailableNode(nodeDataTmp, showNEInfoMap, isContainThirdPartyNe, thirdParyNETypes, isContainOS)) {
                    childrenList.remove(i);
                    continue;
                }
                Object userData = childrenList.get(i).getValue().getUserValue();
                if (userData instanceof UMObjTreeStruct && null != (obj = showNEInfoMap.get(tempFDN = (userObjData = (UMObjTreeStruct)userData).getFdn()))) {
                    childrenList.set(i, obj);
                }
                isAvailableFlag = true;
            }
            if (isAvailableFlag && nodeData.getObjType() != 0) {
                nodeData.setChildren(null);
                nodeData.setHasChildren(false);
            }
            return isAvailableFlag;
        }
        String fdn = "";
        Object userData = nodeData.getValue().getUserValue();
        if (userData instanceof UMObjTreeStruct) {
            String moc;
            UMObjTreeStruct userObjData = (UMObjTreeStruct)userData;
            fdn = userObjData.getFdn();
            if (isContainThirdPartyNe) {
                try {
                    Map<String, String> extendMap = userObjData.getExtendMap();
                    if (null != extendMap) {
                        String netype = extendMap.get("netype");
                        String subNetype = extendMap.get("nesubtype");
                        String string = subNetype = null == subNetype ? "-1" : subNetype;
                        if (netype != null) {
                            int intSubNetype;
                            int n = intSubNetype = subNetype != null ? Integer.parseInt(subNetype) : -1;
                            if (UMObjTreeUtil.isThirdPartyNe(Integer.parseInt(netype), intSubNetype, thirdParyNETypes)) {
                                return 1 == Integer.parseInt(subNetype);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    UMLogger.exception(ex);
                }
            }
            if (isContainOS && "OS".equals(moc = UMFDNUtil.getMOC(userObjData.getFdn()))) {
                return true;
            }
        }
        if (nodeData.getObjType() > 5 && nodeData.hasChildren()) {
            return true;
        }
        if (showNEInfoMap.containsKey(fdn)) {
            nodeData = showNEInfoMap.get(fdn);
            return true;
        }
        return false;
    }

    private static boolean isNeedCheckChildren(UMSelectTreeData node) {
        List<UMSelectTreeData> childrenList = node.getChildren();
        return childrenList != null && !childrenList.isEmpty() && node.getObjType() == 0;
    }

    private static UMSelectTreeData getTreeModelDataFromTopo(EmfTopoTreeModelFilter filter, Map<String, UMSelectTreeData> showNEInfoMap) {
        EmfTopoInterface topoInterface = InmTopoUtil.getTopoInterface();
        if (null == topoInterface) {
            UMLogger.debug(UMObjTreeUtil.class, " getTreeModelDataFromTopo ", " topoInterface is null.");
            return null;
        }
        int[] phyViewID = new int[]{101};
        DefaultTreeModel[] treeModel = topoInterface.getTopoTreeModel(phyViewID, filter);
        if (null == treeModel || treeModel.length == 0) {
            return null;
        }
        return UMObjTreeUtil.adapterTreeModel(treeModel[0], showNEInfoMap);
    }

    private static UMSelectTreeData adapterTreeModel(TreeModel emfTreeModel, Map<String, UMSelectTreeData> showNEInfoMap) {
        DefaultMutableTreeNode oldRootNode = (DefaultMutableTreeNode)emfTreeModel.getRoot();
        return UMObjTreeUtil.copyNode(oldRootNode, showNEInfoMap);
    }

    private static UMSelectTreeData copyNode(DefaultMutableTreeNode oldNode, Map<String, UMSelectTreeData> showNEInfoMap) {
        if (oldNode == null) {
            return null;
        }
        Object obj = oldNode.getUserObject();
        UMSelectTreeData rsData = null;
        HashMap<String, String> extendMap = new HashMap<String, String>();
        if (obj instanceof EmfTopoNodeInfo) {
            EmfTopoNodeInfo nodeInfo = (EmfTopoNodeInfo)obj;
            String neName = nodeInfo.m_szLabel;
            UMObjTreeStruct neStruct = new UMObjTreeStruct();
            neStruct.setName(neName);
            UMObjTreeUserData userData = new UMObjTreeUserData(neStruct);
            String fdn = nodeInfo.m_szID;
            if (0 == UMFDNUtil.getNeIDFromFDN(fdn)) {
                fdn = "NE=" + nodeInfo.m_iDevID;
            }
            rsData = new UMSelectTreeData(userData);
            UMSelectTreeData objectData = showNEInfoMap.get(nodeInfo.m_szID);
            rsData.setObjType(1);
            rsData.setHasChildren(true);
            UMObjTreeUtil.setNodeData(objectData, rsData);
            if (nodeInfo.m_iDevID >= 0x3E0000 && nodeInfo.m_iDevID <= 0x3F7FFF) {
                rsData.setObjType(1);
                rsData.setHasChildren(true);
            } else {
                rsData.setObjType(5);
            }
            extendMap.put("neIP", nodeInfo.m_szIP);
            extendMap.put("netype", nodeInfo.m_szDevType);
            extendMap.put("nesubtype", nodeInfo.m_szDevVer);
            neStruct.setExtendMap(extendMap);
            neStruct.setFdn(fdn);
        } else if (obj instanceof EmfTopoContainerInfo) {
            EmfTopoContainerInfo containerInfo = (EmfTopoContainerInfo)obj;
            int neID = containerInfo.m_iDevID;
            String fdn = "NE=" + neID;
            String neName = containerInfo.m_szLabel;
            UMObjTreeStruct oneStruct = new UMObjTreeStruct(fdn, neName);
            UMObjTreeUserData userData = new UMObjTreeUserData(oneStruct);
            rsData = new UMSelectTreeData(userData);
            rsData.setObjType(5);
            UMSelectTreeData objectData = showNEInfoMap.get(fdn);
            extendMap.put("neIP", containerInfo.m_szIP);
            extendMap.put("netype", containerInfo.m_szDevType);
            extendMap.put("nesubtype", containerInfo.m_szDevVer);
            oneStruct.setExtendMap(extendMap);
            UMObjTreeUtil.setNodeData(objectData, rsData);
        } else if (obj instanceof EmfTopoSubmapInfo) {
            EmfTopoSubmapInfo submapInfo = (EmfTopoSubmapInfo)obj;
            InmTopoSubnet subNetData = new InmTopoSubnet(submapInfo.m_szLabel);
            HashMap<String, UMValueNamePair> searchConditionMap = new HashMap<String, UMValueNamePair>();
            UMValueNamePair valueNamePair = new UMValueNamePair(0, subNetData.toString());
            searchConditionMap.put("subnet", valueNamePair);
            UMObjTreeUserData userData = new UMObjTreeUserData(subNetData, searchConditionMap);
            rsData = new UMSelectTreeData(userData);
            rsData.setObjType(0);
        } else {
            InmLogging.info((String)"Unknown tree node data type");
        }
        ArrayList<UMSelectTreeData> newChildrenList = new ArrayList<UMSelectTreeData>();
        Enumeration<TreeNode> enume = oldNode.children();
        if (enume != null) {
            while (enume.hasMoreElements()) {
                DefaultMutableTreeNode oldNodeTmp = (DefaultMutableTreeNode)enume.nextElement();
                UMSelectTreeData newNodeDataTmp = UMObjTreeUtil.copyNode(oldNodeTmp, showNEInfoMap);
                newChildrenList.add(newNodeDataTmp);
            }
        }
        if (!newChildrenList.isEmpty()) {
            rsData.setHasChildren(true);
            rsData.setChildren(newChildrenList);
        }
        return rsData;
    }

    private static void setNodeData(UMSelectTreeData oldNodeData, UMSelectTreeData newNodeData) {
        if (oldNodeData == null) {
            return;
        }
        newNodeData.setHasChildren(oldNodeData.hasChildren());
        newNodeData.setValue(oldNodeData.getValue());
        if (oldNodeData.hasChildren()) {
            newNodeData.setChildren(oldNodeData.getChildren());
        }
    }

    private static Map<String, UMSelectTreeData> adapterNEToNEMap(List<UMSelectTreeData> neList) {
        if (neList == null) {
            return null;
        }
        HashMap<String, UMSelectTreeData> neIDToNEMap = new HashMap<String, UMSelectTreeData>(neList.size());
        int size = neList.size();
        for (int i = 0; i < size; ++i) {
            UMSelectTreeData neData = neList.get(i);
            String fdn = ((UMObjTreeStruct)neData.getValue().getUserValue()).getFdn();
            neIDToNEMap.put(fdn, neData);
        }
        return neIDToNEMap;
    }

    public static String getDevTypeNameFromID(String devTypeID) {
        List<EmfTopoDeviceType> allDevType = U2kUnitedUtilities.getAllDecType();
        int j = allDevType.size();
        for (int i = 0; i < j; ++i) {
            EmfTopoDeviceType devTypeObj = allDevType.get(i);
            if (!String.valueOf(devTypeObj.m_iDevTypeID).equals(devTypeID)) continue;
            return devTypeObj.m_szDevTypeName;
        }
        return "";
    }

    public static boolean isAccessVirtualNEType(int neTypeID) {
        HashSet<Integer> accessVirtualNeTypeSet = new HashSet<Integer>();
        accessVirtualNeTypeSet.add(2305);
        accessVirtualNeTypeSet.add(2306);
        accessVirtualNeTypeSet.add(2307);
        accessVirtualNeTypeSet.add(2308);
        accessVirtualNeTypeSet.add(2309);
        accessVirtualNeTypeSet.add(56);
        accessVirtualNeTypeSet.add(58);
        accessVirtualNeTypeSet.add(59);
        return accessVirtualNeTypeSet.contains(neTypeID);
    }

    public static boolean isThirdPartyNe(int neType, int subType, DeviceTypeStruct[] thirdParyNETypes) {
        DeviceTypeStruct[] currentTyepStructs = null;
        currentTyepStructs = null != thirdParyNETypes ? thirdParyNETypes : UMObjTreeConstants.THIRDPARTY_NE_LIST;
        for (int i = 0; i < currentTyepStructs.length; ++i) {
            if (currentTyepStructs[i].mainTypeID != neType || -1 != currentTyepStructs[i].subTypeID && subType != currentTyepStructs[i].subTypeID) continue;
            return true;
        }
        return false;
    }
}

