/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.component.objselect;

import com.huawei.core.util.asn.AsnIntList;
import com.huawei.imap12.topo.InmTopoSubnet;
import com.huawei.imap12.topo.InmTopoUtil;
import com.huawei.te.common.communication.TECommHandle;
import com.huawei.te.common.communication.TEResponseReceiver;
import com.huawei.u2000.inf.inventory.common.UMNeInfo;
import com.huawei.u2000.inf.inventory.common.UMOneInf;
import com.huawei.u2000.inventory.UMInventoryModule;
import com.huawei.u2000.inventory.common.util.UMValueNamePair;
import com.huawei.u2000.umcommon.component.objselect.UMObjRpcSeverPushHandler;
import com.huawei.u2000.umcommon.component.objselect.UMObjTreeConstants;
import com.huawei.u2000.umcommon.component.objselect.UMObjTreeStruct;
import com.huawei.u2000.umcommon.component.objselect.UMObjTreeUserData;
import com.huawei.u2000.umcommon.component.objselect.UMObjTreeUtil;
import com.huawei.u2000.umcommon.component.selecttree.UMSelectTreeData;
import com.huawei.u2000.umcommon.component.selecttree.filter.UMSelectTreeSearTypeStruct;
import com.huawei.u2000.umcommon.component.selecttree.inf.IUMSelectTreeDataSource;
import com.huawei.u2000.umcommon.component.selecttree.tree.UMSelectTreeOutsideNoticer;
import com.huawei.u2000.umcommon.security.U2kCommonSecurityUtil;
import com.huawei.u2000.util.U2kModuleManagerFactory;
import com.huawei.u2000.util.U2kUnitedUtilities;
import com.huawei.u2000.util.UMFDNUtil;
import com.huawei.u2000.util.UMLogger;
import com.huawei.u2000.util.UMUnitedNEMgrCommUtil;
import com.huawei.u2000.util.datasource.AsnDelayLoadObjStruct;
import com.huawei.u2000.util.datasource.AsnDelayLoadObjStructList;
import com.huawei.u2000.util.datasource.AsnDelayLoadReq;
import com.huawei.u2000.util.datasource.AsnDelayLoadRsp;
import com.huawei.u2000.util.datasource.AsnDelayLoadStruct;
import com.huawei.u2000.util.datasource.AsnDelayLoadStructList;
import com.huawei.u2000.util.datasource.AsnGetObjTreeDataSourceReq;
import com.huawei.u2000.util.datasource.AsnNameAndValueStr;
import com.huawei.u2000.util.datasource.AsnObjTreeDataStruct;
import com.huawei.u2000.util.datasource.AsnObjTreeDataStructList;
import com.swimap.external.topo.adapter.message.EmfTopoContainerInfo;
import com.swimap.external.topo.adapter.message.EmfTopoInterface;
import com.swimap.external.topo.adapter.message.EmfTopoNodeInfo;
import com.swimap.external.topo.adapter.message.EmfTopoSubmapInfo;
import com.swimap.external.topo.adapter.message.EmfTopoTreeModelFilter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import net.commustru.fstru.FStruct;

public class UMObjTreeTopoDataSource
implements IUMSelectTreeDataSource {
    public static final int LOADMODEL_NE_CONTAIN_SHELF = 0;
    public static final int LOADMODEL_NE_EXCEPT_SHELF = 1;
    public static final int LOADMODEL_BELOW_NE = 2;
    private int funID = -1;
    private AsnObjTreeDataStructList tempObjDataList = null;
    private AsnDelayLoadObjStructList tempDelayLoadList = null;
    private boolean isDelayLload = true;
    private LinkedHashMap<String, UMSelectTreeSearTypeStruct> searchTypeModelMap = null;
    List<UMSelectTreeOutsideNoticer> noticerList = null;
    private Map<Integer, UMSelectTreeData> oneList = new HashMap<Integer, UMSelectTreeData>();
    private int loadModel = 0;
    UMObjRpcSeverPushHandler rpcHandler = new UMObjRpcSeverPushHandler();
    private boolean isContainEmptySubmap = false;

    public UMObjTreeTopoDataSource(int funID, boolean isDelayLload) {
        this.funID = funID;
        this.isDelayLload = isDelayLload;
        this.initSearchTypeModelMap();
        this.initNoticers();
    }

    private void initNoticers() {
        this.noticerList = new ArrayList<UMSelectTreeOutsideNoticer>();
        UMSelectTreeOutsideNoticer noticer = new UMSelectTreeOutsideNoticer();
        this.noticerList.add(noticer);
        this.rpcHandler.registerNoticer(noticer);
    }

    @Override
    public List<UMSelectTreeData> getTreeDataList() {
        UMLogger.debug("[object tree log]TopoDatasource query start!");
        UMSelectTreeData rootData = this.getTreeModelDataFromTopo(null);
        return rootData.getChildren();
    }

    private UMSelectTreeData adapterTreeModel(TreeModel emfTreeModel) {
        DefaultMutableTreeNode oldRootNode = (DefaultMutableTreeNode)emfTreeModel.getRoot();
        UMSelectTreeData newRootNodeData = this.copyNode(oldRootNode);
        UMLogger.debug("[object tree log]TopoDatasource convert to obj tree nodes end!");
        return newRootNodeData;
    }

    private UMSelectTreeData copyNode(DefaultMutableTreeNode oldNode) {
        if (oldNode == null) {
            return null;
        }
        Object obj = oldNode.getUserObject();
        UMSelectTreeData rsData = null;
        if (obj instanceof EmfTopoNodeInfo) {
            EmfTopoNodeInfo nodeInfo = (EmfTopoNodeInfo)obj;
            String neName = nodeInfo.m_szLabel;
            int intNeType = Integer.parseInt(nodeInfo.m_szDevType);
            if (UMObjTreeUtil.isAccessVirtualNEType(intNeType)) {
                return null;
            }
            UMObjTreeStruct neStruct = new UMObjTreeStruct();
            HashMap<String, String> extendMap = new HashMap<String, String>();
            extendMap.put("netype", nodeInfo.m_szDevType);
            extendMap.put("netypename", UMObjTreeUtil.getDevTypeNameFromID(nodeInfo.m_szDevType));
            String strIP = nodeInfo.m_szIP;
            if (U2kUnitedUtilities.isAvailableIP(strIP)) {
                extendMap.put("neIP", strIP);
            }
            neStruct.setExtendMap(extendMap);
            neStruct.setName(neName);
            UMObjTreeUserData userData = new UMObjTreeUserData(neStruct);
            String fdn = nodeInfo.m_szID;
            rsData = new UMSelectTreeData(userData);
            rsData.setHasChildren(true);
            if (nodeInfo.m_iDevID >= 0x3E0000 && nodeInfo.m_iDevID <= 0x3F7FFF) {
                rsData.setObjType(1);
                rsData.setHasChildren(true);
                if (1 == this.loadModel) {
                    rsData.setHasChildren(false);
                } else {
                    rsData.setHasChildren(true);
                }
            } else {
                if (UMFDNUtil.getNeIDFromFDN(fdn) != nodeInfo.m_iDevID && !"OS".equals(UMFDNUtil.getMOC(fdn))) {
                    fdn = "NE=" + nodeInfo.m_iDevID;
                }
                rsData.setObjType(5);
                if (0 == this.loadModel || 1 == this.loadModel) {
                    rsData.setHasChildren(false);
                } else {
                    rsData.setHasChildren(true);
                }
            }
            HashMap<String, UMValueNamePair> searchMap = new HashMap<String, UMValueNamePair>();
            UMValueNamePair neType = new UMValueNamePair(intNeType, UMObjTreeUtil.getDevTypeNameFromID(nodeInfo.m_szDevType));
            searchMap.put("netype", neType);
            userData.setSearchMap(searchMap);
            neStruct.setFdn(fdn);
        } else if (obj instanceof EmfTopoContainerInfo) {
            EmfTopoContainerInfo containerInfo = (EmfTopoContainerInfo)obj;
            int neID = containerInfo.m_iDevID;
            String fdn = "NE=" + neID;
            String neName = containerInfo.m_szLabel;
            UMObjTreeStruct oneStruct = new UMObjTreeStruct(fdn, neName);
            HashMap<String, String> extendMap = new HashMap<String, String>();
            String devTypeID = containerInfo.m_szDevType;
            String devTypeName = UMObjTreeUtil.getDevTypeNameFromID(devTypeID);
            extendMap.put("netype", devTypeID);
            extendMap.put("netypename", devTypeName);
            extendMap.put("neIP", containerInfo.m_szIP);
            oneStruct.setExtendMap(extendMap);
            UMObjTreeUserData userData = new UMObjTreeUserData(oneStruct);
            HashMap<String, UMValueNamePair> searchMap = new HashMap<String, UMValueNamePair>();
            UMValueNamePair neType = new UMValueNamePair(Integer.parseInt(devTypeID), devTypeName);
            searchMap.put("netype", neType);
            userData.setSearchMap(searchMap);
            rsData = new UMSelectTreeData(userData);
            if (0 == this.loadModel) {
                rsData.setHasChildren(false);
            } else {
                rsData.setHasChildren(true);
            }
            rsData.setObjType(5);
        } else if (obj instanceof EmfTopoSubmapInfo) {
            if (this.isEmptySubnet(oldNode) && !this.isContainEmptySubmap) {
                return null;
            }
            EmfTopoSubmapInfo submapInfo = (EmfTopoSubmapInfo)obj;
            InmTopoSubnet subNetData = new InmTopoSubnet(submapInfo.m_szLabel);
            subNetData.setComment(submapInfo.m_szID);
            HashMap<String, UMValueNamePair> searchConditionMap = new HashMap<String, UMValueNamePair>();
            UMValueNamePair valueNamePair = new UMValueNamePair(0, subNetData.toString());
            searchConditionMap.put("subnet", valueNamePair);
            UMObjTreeUserData userData = new UMObjTreeUserData(subNetData, searchConditionMap);
            rsData = new UMSelectTreeData(userData);
            rsData.setObjType(0);
            rsData.setHasChildren(true);
        } else {
            UMLogger.debug(this.getClass(), " copyNode ", "Unknown tree node data type");
        }
        ArrayList<UMSelectTreeData> newChildrenList = new ArrayList<UMSelectTreeData>();
        Enumeration<TreeNode> enume = oldNode.children();
        if (enume != null) {
            while (enume.hasMoreElements()) {
                DefaultMutableTreeNode oldNodeTmp = (DefaultMutableTreeNode)enume.nextElement();
                UMSelectTreeData newNodeDataTmp = this.copyNode(oldNodeTmp);
                if (newNodeDataTmp == null) continue;
                newChildrenList.add(newNodeDataTmp);
            }
        }
        if (!newChildrenList.isEmpty()) {
            rsData.setHasChildren(true);
            rsData.setChildren(newChildrenList);
        }
        return rsData;
    }

    private boolean isEmptySubnet(DefaultMutableTreeNode submapInfo) {
        Enumeration<TreeNode> enume = submapInfo.children();
        if (enume != null) {
            while (enume.hasMoreElements()) {
                DefaultMutableTreeNode oldNodeTmp = (DefaultMutableTreeNode)enume.nextElement();
                Object obj = oldNodeTmp.getUserObject();
                if (obj instanceof EmfTopoSubmapInfo || obj instanceof EmfTopoContainerInfo) {
                    return false;
                }
                if (!(obj instanceof EmfTopoNodeInfo)) continue;
                EmfTopoNodeInfo nodeInfo = (EmfTopoNodeInfo)obj;
                if (UMObjTreeUtil.isAccessVirtualNEType(Integer.parseInt(nodeInfo.m_szDevType))) continue;
                return false;
            }
        }
        return true;
    }

    private UMSelectTreeData getTreeModelDataFromTopo(EmfTopoTreeModelFilter filter) {
        EmfTopoInterface topoInterface = null;
        try {
            topoInterface = InmTopoUtil.getTopoInterface();
        }
        catch (Exception ex) {
            UMLogger.exception(ex);
        }
        if (null == topoInterface) {
            UMLogger.debug(this.getClass(), " getTreeModelDataFromTopo ", " topoInterface is null. ");
            return null;
        }
        int[] phyViewID = new int[]{101};
        DefaultTreeModel[] treeModel = topoInterface.getTopoTreeModel(phyViewID, filter);
        UMLogger.debug("[object tree log]TopoDatasource get topo tree model end!");
        if (null == treeModel || treeModel.length == 0) {
            return null;
        }
        return this.adapterTreeModel(treeModel[0]);
    }

    @Override
    public List<UMSelectTreeData> mountChildren(List<UMSelectTreeData> selectDataList) {
        int i;
        ArrayList<UMSelectTreeData> resultList = new ArrayList<UMSelectTreeData>();
        this.tempDelayLoadList = new AsnDelayLoadObjStructList();
        ArrayList<UMSelectTreeData> oneList = new ArrayList<UMSelectTreeData>();
        ArrayList<Integer> tempOneIDList = new ArrayList<Integer>();
        int size = selectDataList.size();
        for (int i2 = 0; i2 < size; ++i2) {
            UMSelectTreeData treeData = selectDataList.get(i2);
            if (1 != treeData.getObjType()) continue;
            String fdn = ((UMObjTreeStruct)treeData.getValue().getUserValue()).getFdn();
            tempOneIDList.add(UMFDNUtil.getOneIDFromFDN(fdn));
            oneList.add(treeData);
            selectDataList.remove(treeData);
            --size;
        }
        int oneCount = tempOneIDList.size();
        int[] oneIDList = new int[oneCount];
        for (int i3 = 0; i3 < oneCount; ++i3) {
            oneIDList[i3] = (Integer)tempOneIDList.get(i3);
        }
        UMLogger.debug(this.getClass(), " mountChildren ", " oneIDList : " + Arrays.toString(oneIDList));
        List oneInfList = ((UMInventoryModule)U2kModuleManagerFactory.getInventoryInterface()).getOneInfList();
        ArrayList<Map<Integer, List<UMNeInfo>>> neInfoList = new ArrayList<Map<Integer, List<UMNeInfo>>>();
        int size2 = oneInfList.size();
        for (i = 0; i < size2; ++i) {
            neInfoList.add(((UMOneInf)oneInfList.get(i)).getOneChildren(oneIDList));
        }
        int oneSize = oneList.size();
        block3: for (i = 0; i < oneSize; ++i) {
            UMSelectTreeData one = (UMSelectTreeData)oneList.get(i);
            String fdn = ((UMObjTreeStruct)one.getValue().getUserValue()).getFdn();
            int oneID = UMFDNUtil.getOneIDFromFDN(fdn);
            List shelfList = null;
            int shelfMapSize = neInfoList.size();
            for (int j = 0; j < shelfMapSize; ++j) {
                shelfList = (List)((Map)neInfoList.get(j)).get(oneID);
                if (null == shelfList) continue;
                one.setChildren(this.convertShelfList(shelfList));
                continue block3;
            }
        }
        AsnDelayLoadReq objTreeDelayReq = this.setDelayLoadReq(this.funID, selectDataList);
        this.delayLoadQuery(objTreeDelayReq);
        int mountSize = selectDataList.size();
        for (int i4 = 0; i4 < mountSize; ++i4) {
            int m = this.tempDelayLoadList.size();
            for (int delayLoadIndex = 0; delayLoadIndex < m; ++delayLoadIndex) {
                AsnDelayLoadStruct tempDelayLoadStruct = (AsnDelayLoadStruct)this.tempDelayLoadList.elementAt(delayLoadIndex);
                if (tempDelayLoadStruct.delayLoadSerial.intValue() != i4) continue;
                List<UMSelectTreeData> tempResult = this.convertObjListToObjTreeList(tempDelayLoadStruct.delayLoadDataList);
                resultList.addAll(tempResult);
                selectDataList.get(i4).setChildren(tempResult);
                int n = tempResult.size();
                for (int index = 0; index < n; ++index) {
                    if (null != tempResult.get(index).getParent()) continue;
                    tempResult.get(index).setParent(selectDataList.get(i4));
                }
            }
        }
        this.clearData();
        return resultList;
    }

    private List<UMSelectTreeData> convertShelfList(List<UMNeInfo> shelfList) {
        int size = shelfList.size();
        ArrayList<UMSelectTreeData> treeDataList = new ArrayList<UMSelectTreeData>(size);
        for (int i = 0; i < size; ++i) {
            UMNeInfo shelf = shelfList.get(i);
            UMObjTreeUserData userData = new UMObjTreeUserData();
            UMObjTreeStruct treeStruct = new UMObjTreeStruct();
            treeStruct.setFdn("NE=" + shelf.getDevID());
            treeStruct.setName(shelf.getName());
            HashMap<String, String> extendMap = new HashMap<String, String>();
            extendMap.put("netype", String.valueOf(shelf.getTypeID()));
            extendMap.put("netypename", String.valueOf(shelf.getTypeName()));
            treeStruct.setExtendMap(extendMap);
            userData.setUserData(treeStruct);
            UMSelectTreeData treeData = new UMSelectTreeData(userData);
            treeData.setObjType(5);
            treeDataList.add(treeData);
            HashMap<String, UMValueNamePair> searchMap = new HashMap<String, UMValueNamePair>();
            UMValueNamePair neValuePair = new UMValueNamePair(shelf.getDevID(), shelf.getName());
            searchMap.put("ne", neValuePair);
            String strNeTypeID = String.valueOf(shelf.getTypeID());
            int neTypeID = U2kUnitedUtilities.isNull(strNeTypeID) ? -1 : Integer.valueOf(strNeTypeID);
            String neTypeName = String.valueOf(shelf.getTypeName());
            UMValueNamePair neTypeValuePair = new UMValueNamePair(neTypeID, neTypeName);
            searchMap.put("netype", neTypeValuePair);
            userData.setSearchMap(searchMap);
        }
        return treeDataList;
    }

    private AsnObjTreeDataStructList getDelayLoadGroup(int delayLoadIndex, AsnObjTreeDataStructList delayLoadResultList) {
        AsnObjTreeDataStructList delayList = new AsnObjTreeDataStructList();
        int size = delayLoadResultList.size();
        for (int i = 0; i < size; ++i) {
            if (((AsnDelayLoadStruct)delayLoadResultList.get((int)i)).delayLoadSerial.intValue() != delayLoadIndex) continue;
            delayList.add(delayLoadResultList.get(i));
        }
        return delayList;
    }

    private AsnDelayLoadReq setDelayLoadReq(int funID, List<UMSelectTreeData> selectDataList) {
        AsnDelayLoadReq objTreeDelayReq = new AsnDelayLoadReq();
        AsnDelayLoadObjStructList ojbList = new AsnDelayLoadObjStructList();
        int size = selectDataList.size();
        for (int i = 0; i < size; ++i) {
            int type = 1;
            AsnDelayLoadObjStruct delayLoadPathStruct = new AsnDelayLoadObjStruct();
            Object obj = selectDataList.get(i).getValue().getUserValue();
            UMObjTreeStruct objTreeStruct = null;
            if (!(obj instanceof UMObjTreeStruct)) continue;
            objTreeStruct = (UMObjTreeStruct)obj;
            String fdn = objTreeStruct.getFdn();
            int neID = UMFDNUtil.getNeIDFromFDN(fdn);
            delayLoadPathStruct.neID = BigInteger.valueOf(neID);
            delayLoadPathStruct.delayLoadSerial = BigInteger.valueOf(i);
            delayLoadPathStruct.type = BigInteger.valueOf(type);
            AsnIntList ojbIDList = new AsnIntList();
            ojbIDList.addAll(this.getResourceIDList(selectDataList.get(i)));
            delayLoadPathStruct.objIDList = ojbIDList;
            ojbList.add((Object)delayLoadPathStruct);
        }
        objTreeDelayReq.funcId = BigInteger.valueOf(funID);
        objTreeDelayReq.objList = ojbList;
        return objTreeDelayReq;
    }

    private List<BigInteger> getResourceIDList(UMSelectTreeData inputResourceStruct) {
        ArrayList<BigInteger> tempResourceList = new ArrayList<BigInteger>();
        ArrayList<BigInteger> resourceList = new ArrayList<BigInteger>();
        UMSelectTreeData tempSelectData = inputResourceStruct;
        while (tempSelectData != null && 5 != tempSelectData.getObjType()) {
            UMObjTreeStruct objStruct = (UMObjTreeStruct)tempSelectData.getValue().getUserValue();
            String strFDN = objStruct.getFdn();
            String strMOC = UMFDNUtil.getMOC(strFDN);
            if ("CP".equals(strMOC)) {
                strMOC = "S";
            }
            tempResourceList.add(BigInteger.valueOf(UMFDNUtil.getIntValue(strFDN, strMOC)));
            tempSelectData = inputResourceStruct.getParent();
        }
        String fdn = ((UMObjTreeStruct)inputResourceStruct.getValue().getUserValue()).getFdn();
        int neID = UMFDNUtil.getNeIDFromFDN(fdn);
        resourceList.add(BigInteger.valueOf(neID));
        for (int i = tempResourceList.size() - 1; i >= 0; --i) {
            resourceList.add((BigInteger)tempResourceList.get(i));
        }
        return resourceList;
    }

    private void delayLoadQuery(AsnDelayLoadReq objTreeDelayReq) {
        int timeOut = 190;
        TECommHandle commHandle = UMUnitedNEMgrCommUtil.getNECommCommand((FStruct)objTreeDelayReq, new DelayLoadResponseReceiver(), 11534868);
        commHandle.send(new int[]{timeOut});
    }

    private UMSelectTreeData convertObjDataToObjTreeData(AsnObjTreeDataStruct objData) {
        UMSelectTreeData objTreeData;
        ArrayList<UMSelectTreeData> objTreeChildren = null;
        if (objData.children != null) {
            objTreeChildren = new ArrayList<UMSelectTreeData>();
            int size = objData.children.size();
            for (int childIndex = 0; childIndex < size; ++childIndex) {
                objTreeChildren.add(this.convertObjDataToObjTreeData((AsnObjTreeDataStruct)objData.children.get(childIndex)));
            }
        }
        if (null == (objTreeData = this.getExistedOne(objData))) {
            UMObjTreeUserData selectData = new UMObjTreeUserData();
            UMObjTreeStruct generalObjData = this.setObjStruct(objData);
            selectData.setUserData(generalObjData);
            selectData.setSearchMap(this.setObjSearchMap(generalObjData, objData));
            objTreeData = new UMSelectTreeData(selectData, new String(objData.node.name), objTreeChildren);
            int type = objData.type.intValue();
            objTreeData.setObjType(type == 0 ? 1 : type);
            objTreeData.setHasChildren(objData.hasChildren.intValue() == 1);
            if (0 == type) {
                this.oneList.put(objData.node.value.intValue(), objTreeData);
            }
        } else {
            objTreeData.getChildren().addAll(objTreeChildren);
        }
        return objTreeData;
    }

    private UMSelectTreeData getExistedOne(AsnObjTreeDataStruct objData) {
        int type = objData.type.intValue();
        if (0 == type) {
            return this.oneList.get(objData.node.value.intValue());
        }
        return null;
    }

    private UMObjTreeStruct setObjStruct(AsnObjTreeDataStruct objData) {
        UMObjTreeStruct generalObjData = new UMObjTreeStruct();
        generalObjData.setName(new String(objData.node.name));
        byte[] byteFDN = objData.node.fdn;
        generalObjData.setFdn(byteFDN != null ? new String(byteFDN) : "");
        HashMap<String, String> extendMap = new HashMap<String, String>();
        if (objData.node.extend != null) {
            int size = objData.node.extend.size();
            for (int extendsIndex = 0; extendsIndex < size; ++extendsIndex) {
                String extendsName = new String(((AsnNameAndValueStr)objData.node.extend.get((int)extendsIndex)).name);
                String extendsValue = new String(((AsnNameAndValueStr)objData.node.extend.get((int)extendsIndex)).value);
                extendMap.put(extendsName, extendsValue);
            }
        }
        generalObjData.setExtendMap(extendMap);
        return generalObjData;
    }

    private Map<String, UMValueNamePair> setObjSearchMap(UMObjTreeStruct generalObjData, AsnObjTreeDataStruct objData) {
        HashMap<String, UMValueNamePair> searchMap = new HashMap<String, UMValueNamePair>();
        switch (objData.type.intValue()) {
            case 5: {
                UMValueNamePair neValuePair = new UMValueNamePair(objData.node.value.intValue(), generalObjData.getName());
                searchMap.put("ne", neValuePair);
                String strNeTypeID = generalObjData.getExtendMap().get("netype");
                int neTypeID = U2kUnitedUtilities.isNull(strNeTypeID) ? -1 : Integer.valueOf(strNeTypeID);
                String neTypeName = generalObjData.getExtendMap().get("netypename");
                UMValueNamePair neTypeValuePair = new UMValueNamePair(neTypeID, neTypeName);
                searchMap.put("netype", neTypeValuePair);
                break;
            }
            case 10: {
                UMValueNamePair boardValuePair = new UMValueNamePair(objData.node.value.intValue(), generalObjData.getName());
                searchMap.put("borad", boardValuePair);
                break;
            }
        }
        return searchMap;
    }

    public void setSpecificSearchMap(LinkedHashMap<String, UMSelectTreeSearTypeStruct> searchTypeModelMap) {
        this.searchTypeModelMap = searchTypeModelMap;
    }

    private List<UMSelectTreeData> convertObjListToObjTreeList(AsnObjTreeDataStructList objDataList) {
        ArrayList<UMSelectTreeData> objTreeDataList = new ArrayList<UMSelectTreeData>();
        if (objDataList != null) {
            int size = objDataList.size();
            for (int i = 0; i < size; ++i) {
                UMSelectTreeData selectData = this.convertObjDataToObjTreeData((AsnObjTreeDataStruct)objDataList.get(i));
                if (objTreeDataList.contains(selectData)) continue;
                objTreeDataList.add(selectData);
            }
        }
        return objTreeDataList;
    }

    private AsnGetObjTreeDataSourceReq setObjTreeReq(int funID, List<Integer> neIDList, boolean isDelayLload) {
        AsnGetObjTreeDataSourceReq objTreeReqAsn = new AsnGetObjTreeDataSourceReq();
        if (neIDList != null) {
            int neNum = neIDList.size();
            objTreeReqAsn.funcId = BigInteger.valueOf(funID);
            for (int i = 0; i < neNum; ++i) {
                int neid = neIDList.get(i);
                objTreeReqAsn.objList.add((Object)BigInteger.valueOf(neid));
            }
            objTreeReqAsn.userId = BigInteger.valueOf(U2kCommonSecurityUtil.getUserID());
            objTreeReqAsn.delayLoad = isDelayLload ? BigInteger.valueOf(1L) : BigInteger.valueOf(0L);
        }
        return objTreeReqAsn;
    }

    private void clearData() {
        if (null != this.tempObjDataList) {
            this.tempObjDataList.clear();
            this.tempObjDataList = null;
        }
        if (null != this.tempDelayLoadList) {
            this.tempDelayLoadList.clear();
            this.tempDelayLoadList = null;
        }
        this.oneList.clear();
    }

    @Override
    public String getRootNodeName() {
        String rootMapID = InmTopoUtil.getTopoInterface().getBaseViewRootSubmapID();
        return UMObjTreeUtil.getTopoSubmapInfo((String)rootMapID).m_szLabel;
    }

    @Override
    public LinkedHashMap<String, UMSelectTreeSearTypeStruct> getSearchTypeModelMap() {
        return this.searchTypeModelMap;
    }

    private void initSearchTypeModelMap() {
        this.searchTypeModelMap = new LinkedHashMap();
        String subNetSearchKey = "subnet";
        UMSelectTreeSearTypeStruct subNetSearchStruct = new UMSelectTreeSearTypeStruct();
        subNetSearchStruct.setLevel(0);
        subNetSearchStruct.setSearchName(UMObjTreeConstants.res.getString("ID_BY_SUBNET"));
        this.searchTypeModelMap.put(subNetSearchKey, subNetSearchStruct);
        String neTypeSearchKey = "netype";
        UMSelectTreeSearTypeStruct neTypeSearchStruct = new UMSelectTreeSearTypeStruct();
        neTypeSearchStruct.setLevel(5);
        neTypeSearchStruct.setSearchName(UMObjTreeConstants.res.getString("ID_BY_NETYPE"));
        neTypeSearchStruct.setIsGroupSearch(true);
        this.searchTypeModelMap.put(neTypeSearchKey, neTypeSearchStruct);
        String neSearchKey = "ne";
        UMSelectTreeSearTypeStruct neSearchStruct = new UMSelectTreeSearTypeStruct();
        neSearchStruct.setLevel(5);
        neSearchStruct.setSearchName(UMObjTreeConstants.res.getString("ID_BY_NE"));
        this.searchTypeModelMap.put(neSearchKey, neSearchStruct);
        String boardSearchKey = "borad";
        UMSelectTreeSearTypeStruct boardSearchStruct = new UMSelectTreeSearTypeStruct();
        boardSearchStruct.setLevel(10);
        boardSearchStruct.setSearchName(UMObjTreeConstants.res.getString("ID_BY_BOARD"));
        this.searchTypeModelMap.put(boardSearchKey, boardSearchStruct);
    }

    public void setDelayLload(boolean isDelayLload) {
        this.isDelayLload = isDelayLload;
    }

    @Override
    public List<UMSelectTreeOutsideNoticer> getOutsideNoticerList() {
        return this.noticerList;
    }

    @Override
    public void destroy() {
        int size = this.noticerList.size();
        for (int i = 0; i < size; ++i) {
            this.rpcHandler.unRegisterNoticer(this.noticerList.get(i));
        }
    }

    public void setLoadModel(int loadModel) {
        this.loadModel = loadModel;
    }

    public void setIsContainEmptySubnet(boolean isContainEmptySubmap) {
        this.isContainEmptySubmap = isContainEmptySubmap;
    }

    public class DelayLoadResponseReceiver
    extends TEResponseReceiver {
        public synchronized void messageReceived() {
        }

        public synchronized boolean checkDataIntegrity() {
            AsnDelayLoadRsp response = new AsnDelayLoadRsp();
            int result = this.commIt.getCurrRsp((FStruct)response);
            if (result != 0) {
                UMLogger.debug("datasource query failed,The error ProcID:" + this.commIt.getCurrProcID());
                return true;
            }
            AsnDelayLoadStructList rspList = response.delayLoadDataList;
            UMObjTreeTopoDataSource.this.tempDelayLoadList.addAll((Collection)rspList);
            return true;
        }
    }
}

