/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.component.objselect;

import com.huawei.core.util.TEOperationShowMgr;
import com.huawei.core.util.asn.AsnIntList;
import com.huawei.dfw.communicate.DFWCommHandle;
import com.huawei.dfw.communicate.DFWResponseReceiver;
import com.huawei.dfw.data.iface.IDFWDataMgr;
import com.huawei.dfw.proxy.ProxyFactory;
import com.huawei.dfw.proxy.iface.MSGInfo;
import com.huawei.dfw.proxy.impl.DefaultNEProxy;
import com.huawei.imap12.topo.InmTopoUtil;
import com.huawei.te.common.communication.TECommHandle;
import com.huawei.te.common.communication.TEResponseReceiver;
import com.huawei.u2000.inventory.common.util.UMValueNamePair;
import com.huawei.u2000.umcommon.component.objselect.DeviceTypeStruct;
import com.huawei.u2000.umcommon.component.objselect.UMObjRpcSeverPushHandler;
import com.huawei.u2000.umcommon.component.objselect.UMObjTreeAbstractDataSource;
import com.huawei.u2000.umcommon.component.objselect.UMObjTreeConstants;
import com.huawei.u2000.umcommon.component.objselect.UMObjTreeStruct;
import com.huawei.u2000.umcommon.component.objselect.UMObjTreeUserData;
import com.huawei.u2000.umcommon.component.objselect.UMObjTreeUtil;
import com.huawei.u2000.umcommon.component.selecttree.UMSelectTreeData;
import com.huawei.u2000.umcommon.component.selecttree.filter.UMSelectTreeSearTypeStruct;
import com.huawei.u2000.umcommon.component.selecttree.tree.UMSelectTreeOutsideNoticer;
import com.huawei.u2000.umcommon.security.U2kCommonSecurityUtil;
import com.huawei.u2000.util.U2kUnitedUtilities;
import com.huawei.u2000.util.UMFDNUtil;
import com.huawei.u2000.util.UMLogger;
import com.huawei.u2000.util.UMUnitedNEMgrCommUtil;
import com.huawei.u2000.util.datasource.AsnDelayLoadObjStruct;
import com.huawei.u2000.util.datasource.AsnDelayLoadObjStructList;
import com.huawei.u2000.util.datasource.AsnDelayLoadReq;
import com.huawei.u2000.util.datasource.AsnDelayLoadRsp;
import com.huawei.u2000.util.datasource.AsnDelayLoadStruct;
import com.huawei.u2000.util.datasource.AsnDelayLoadStructList;
import com.huawei.u2000.util.datasource.AsnGetObjTreeDataSourceReq;
import com.huawei.u2000.util.datasource.AsnGetObjTreeDataSourceRsp;
import com.huawei.u2000.util.datasource.AsnNameAndValueStr;
import com.huawei.u2000.util.datasource.AsnObjTreeDataStruct;
import com.huawei.u2000.util.datasource.AsnObjTreeDataStructList;
import com.swimap.external.topo.adapter.message.EmfTopoSubmapInfo;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.commustru.fstru.FStruct;

public class UMObjTreeDataSource
extends UMObjTreeAbstractDataSource {
    private int funID = -1;
    private AsnObjTreeDataStructList tempObjDataList = null;
    private AsnDelayLoadObjStructList tempDelayLoadList = null;
    private boolean isDelayLload = true;
    private boolean isFromTopoBuild = true;
    private LinkedHashMap<String, UMSelectTreeSearTypeStruct> searchTypeModelMap = null;
    List<UMSelectTreeOutsideNoticer> noticerList = null;
    private Map<Integer, UMSelectTreeData> oneList = new HashMap<Integer, UMSelectTreeData>();
    private boolean isContainLocalNM = false;
    private long dataSourceQueryStartTime = System.currentTimeMillis();
    private boolean isContainThirdParyNe = false;
    private boolean isContainOS = false;
    private DeviceTypeStruct[] thirdPartyNeTyepStructs = null;
    UMObjRpcSeverPushHandler rpcHandler = new UMObjRpcSeverPushHandler();

    public UMObjTreeDataSource(int funID, boolean isDelayLload) {
        this.funID = funID;
        this.isDelayLload = isDelayLload;
        this.initSearchTypeModelMap();
        this.initNoticers();
    }

    private void initNoticers() {
        this.noticerList = new ArrayList<UMSelectTreeOutsideNoticer>();
        UMSelectTreeOutsideNoticer noticer = new UMSelectTreeOutsideNoticer();
        this.noticerList.add(noticer);
        this.rpcHandler.registerNoticer(noticer);
    }

    @Override
    public List<UMSelectTreeData> getObjTreeDataList() {
        List<Integer> neIDList = this.getAllNeList();
        UMLogger.debug("[object tree log]Datasource query start!");
        UMLogger.debug("[object tree log]All NE Count:" + (null == neIDList ? "" : Integer.valueOf(neIDList.size())));
        AsnGetObjTreeDataSourceReq objTreeReq = this.setObjTreeReq(this.funID, this.isDelayLload);
        this.queryObjData(objTreeReq);
        ArrayList<UMSelectTreeData> resultList = new ArrayList<UMSelectTreeData>();
        List<UMSelectTreeData> objList = this.convertObjListToObjTreeList(this.tempObjDataList);
        UMObjTreeUtil.sortTree(objList);
        resultList.addAll(objList);
        this.clearData();
        return resultList;
    }

    @Override
    public List<UMSelectTreeData> getTreeDataList() {
        List<UMSelectTreeData> resultObjTreeList = null;
        if (this.isBuildTreeFromTopo()) {
            resultObjTreeList = UMObjTreeUtil.buildTreeFromTopo(this.getObjTreeDataList(), this.isContainLocalNM, this.isContainThirdParyNe, this.thirdPartyNeTyepStructs, this.isContainOS);
        }
        return resultObjTreeList;
    }

    private List<Integer> getAllNeList() {
        ProxyFactory proxyFactory = ProxyFactory.getInstance();
        IDFWDataMgr dataMgr = proxyFactory.getDFWDataMgr();
        List neIDList = dataMgr.getAllNeID();
        return neIDList;
    }

    @Override
    public List<UMSelectTreeData> mountChildren(List<UMSelectTreeData> selectDataList) {
        ArrayList<UMSelectTreeData> resultList = new ArrayList<UMSelectTreeData>();
        this.tempDelayLoadList = new AsnDelayLoadObjStructList();
        AsnDelayLoadReq objTreeDelayReq = this.setDelayLoadReq(this.funID, selectDataList);
        this.delayLoadQuery(objTreeDelayReq);
        int size = selectDataList.size();
        for (int i = 0; i < size; ++i) {
            int m = this.tempDelayLoadList.size();
            for (int delayLoadIndex = 0; delayLoadIndex < m; ++delayLoadIndex) {
                AsnDelayLoadStruct tempDelayLoadStruct = (AsnDelayLoadStruct)this.tempDelayLoadList.elementAt(delayLoadIndex);
                if (tempDelayLoadStruct.delayLoadSerial.intValue() != i) continue;
                List<UMSelectTreeData> tempResult = this.convertObjListToObjTreeList(tempDelayLoadStruct.delayLoadDataList);
                resultList.addAll(tempResult);
                selectDataList.get(i).setChildren(tempResult);
                int n = tempResult.size();
                for (int index = 0; index < n; ++index) {
                    if (null != tempResult.get(index).getParent()) continue;
                    tempResult.get(index).setParent(selectDataList.get(i));
                }
            }
        }
        this.clearData();
        return resultList;
    }

    private AsnObjTreeDataStructList getDelayLoadGroup(int delayLoadIndex, AsnObjTreeDataStructList delayLoadResultList) {
        AsnObjTreeDataStructList delayList = new AsnObjTreeDataStructList();
        int size = delayLoadResultList.size();
        for (int i = 0; i < size; ++i) {
            if (((AsnDelayLoadStruct)delayLoadResultList.get((int)i)).delayLoadSerial.intValue() != delayLoadIndex) continue;
            delayList.add(delayLoadResultList.get(i));
        }
        return delayList;
    }

    private AsnDelayLoadReq setDelayLoadReq(int funID, List<UMSelectTreeData> selectDataList) {
        AsnDelayLoadReq objTreeDelayReq = new AsnDelayLoadReq();
        AsnDelayLoadObjStructList ojbList = new AsnDelayLoadObjStructList();
        int size = selectDataList.size();
        for (int i = 0; i < size; ++i) {
            int type = selectDataList.get(i).getObjType();
            AsnDelayLoadObjStruct delayLoadPathStruct = new AsnDelayLoadObjStruct();
            String fdn = ((UMObjTreeStruct)selectDataList.get(i).getValue().getUserValue()).getFdn();
            int neID = UMFDNUtil.getNeIDFromFDN(fdn);
            delayLoadPathStruct.neID = BigInteger.valueOf(neID);
            delayLoadPathStruct.delayLoadSerial = BigInteger.valueOf(i);
            delayLoadPathStruct.type = BigInteger.valueOf(type);
            AsnIntList ojbIDList = new AsnIntList();
            ojbIDList.addAll(this.getResourceIDList(selectDataList.get(i)));
            delayLoadPathStruct.objIDList = ojbIDList;
            ojbList.add((Object)delayLoadPathStruct);
        }
        objTreeDelayReq.funcId = BigInteger.valueOf(funID);
        objTreeDelayReq.objList = ojbList;
        return objTreeDelayReq;
    }

    private List<BigInteger> getResourceIDList(UMSelectTreeData inputResourceStruct) {
        ArrayList<BigInteger> tempResourceList = new ArrayList<BigInteger>();
        ArrayList<BigInteger> resourceList = new ArrayList<BigInteger>();
        for (UMSelectTreeData tempSelectData = inputResourceStruct; tempSelectData != null && 5 != tempSelectData.getObjType(); tempSelectData = tempSelectData.getParent()) {
            UMObjTreeStruct objStruct = (UMObjTreeStruct)tempSelectData.getValue().getUserValue();
            String strFDN = objStruct.getFdn();
            String strMOC = UMFDNUtil.getMOC(strFDN);
            if ("CP".equals(strMOC)) {
                strMOC = "S";
            }
            tempResourceList.add(BigInteger.valueOf(UMFDNUtil.getIntValue(strFDN, strMOC)));
        }
        String fdn = ((UMObjTreeStruct)inputResourceStruct.getValue().getUserValue()).getFdn();
        int oneID = UMFDNUtil.getOneIDFromFDN(fdn);
        if (-1 != oneID && 0 != oneID) {
            resourceList.add(BigInteger.valueOf(oneID));
        }
        int neID = UMFDNUtil.getNeIDFromFDN(fdn);
        resourceList.add(BigInteger.valueOf(neID));
        for (int i = tempResourceList.size() - 1; i >= 0; --i) {
            resourceList.add((BigInteger)tempResourceList.get(i));
        }
        return resourceList;
    }

    private void delayLoadQuery(AsnDelayLoadReq objTreeDelayReq) {
        int timeOut = 190;
        TECommHandle commHandle = UMUnitedNEMgrCommUtil.getNECommCommand((FStruct)objTreeDelayReq, new DelayLoadResponseReceiver(), 11534868);
        commHandle.send(new int[]{timeOut});
    }

    private UMSelectTreeData convertObjDataToObjTreeData(AsnObjTreeDataStruct objData) {
        UMSelectTreeData objTreeData;
        ArrayList<UMSelectTreeData> objTreeChildren = null;
        if (objData.children != null) {
            objTreeChildren = new ArrayList<UMSelectTreeData>();
            int size = objData.children.size();
            for (int childIndex = 0; childIndex < size; ++childIndex) {
                objTreeChildren.add(this.convertObjDataToObjTreeData((AsnObjTreeDataStruct)objData.children.get(childIndex)));
            }
        }
        if (null == (objTreeData = this.getExistedOne(objData))) {
            UMObjTreeUserData selectData = new UMObjTreeUserData();
            UMObjTreeStruct generalObjData = this.setObjStruct(objData);
            selectData.setUserData(generalObjData);
            selectData.setSearchMap(this.setObjSearchMap(generalObjData, objData));
            objTreeData = new UMSelectTreeData(selectData, new String(objData.node.name), objTreeChildren);
            int type = objData.type.intValue();
            objTreeData.setObjType(type == 0 ? 1 : type);
            objTreeData.setHasChildren(objData.hasChildren.intValue() == 1);
            if (0 == type) {
                this.oneList.put(objData.node.value.intValue(), objTreeData);
            }
        } else {
            objTreeData.getChildren().addAll(objTreeChildren);
        }
        if (null != objTreeChildren) {
            for (UMSelectTreeData child : objTreeChildren) {
                child.setParent(objTreeData);
            }
        }
        return objTreeData;
    }

    private UMSelectTreeData getExistedOne(AsnObjTreeDataStruct objData) {
        int type = objData.type.intValue();
        if (0 == type) {
            return this.oneList.get(objData.node.value.intValue());
        }
        return null;
    }

    private UMObjTreeStruct setObjStruct(AsnObjTreeDataStruct objData) {
        UMObjTreeStruct generalObjData = new UMObjTreeStruct();
        generalObjData.setName(new String(objData.node.name));
        byte[] byteFDN = objData.node.fdn;
        generalObjData.setFdn(byteFDN != null ? new String(byteFDN) : "");
        HashMap<String, String> extendMap = new HashMap<String, String>();
        if (objData.node.extend != null) {
            int size = objData.node.extend.size();
            for (int extendsIndex = 0; extendsIndex < size; ++extendsIndex) {
                String extendsName = new String(((AsnNameAndValueStr)objData.node.extend.get((int)extendsIndex)).name);
                String extendsValue = new String(((AsnNameAndValueStr)objData.node.extend.get((int)extendsIndex)).value);
                extendMap.put(extendsName, extendsValue);
            }
        }
        generalObjData.setExtendMap(extendMap);
        return generalObjData;
    }

    private Map<String, UMValueNamePair> setObjSearchMap(UMObjTreeStruct generalObjData, AsnObjTreeDataStruct objData) {
        HashMap<String, UMValueNamePair> searchMap = new HashMap<String, UMValueNamePair>();
        switch (objData.type.intValue()) {
            case 5: {
                UMValueNamePair neValuePair = new UMValueNamePair(objData.node.value.intValue(), generalObjData.getName());
                searchMap.put("ne", neValuePair);
                String strNeTypeID = generalObjData.getExtendMap().get("netype");
                int neTypeID = U2kUnitedUtilities.isNull(strNeTypeID) ? -1 : Integer.valueOf(strNeTypeID);
                String neTypeName = generalObjData.getExtendMap().get("netypename");
                UMValueNamePair neTypeValuePair = new UMValueNamePair(neTypeID, neTypeName);
                searchMap.put("netype", neTypeValuePair);
                break;
            }
            case 10: {
                UMValueNamePair boardValuePair = new UMValueNamePair(objData.node.value.intValue(), generalObjData.getName());
                searchMap.put("borad", boardValuePair);
                break;
            }
        }
        return searchMap;
    }

    public void setSpecificSearchMap(LinkedHashMap<String, UMSelectTreeSearTypeStruct> searchTypeModelMap) {
        this.searchTypeModelMap = searchTypeModelMap;
    }

    private List<UMSelectTreeData> convertObjListToObjTreeList(AsnObjTreeDataStructList objDataList) {
        HashSet<UMSelectTreeData> objTreeDataSet = new HashSet<UMSelectTreeData>();
        if (objDataList != null) {
            int size = objDataList.size();
            for (int i = 0; i < size; ++i) {
                AsnObjTreeDataStruct dataStruct = (AsnObjTreeDataStruct)objDataList.get(i);
                UMSelectTreeData selectData = this.convertObjDataToObjTreeData(dataStruct);
                objTreeDataSet.add(selectData);
            }
        }
        ArrayList<UMSelectTreeData> objTreeDataList = new ArrayList<UMSelectTreeData>();
        for (UMSelectTreeData data : objTreeDataSet) {
            objTreeDataList.add(data);
        }
        return objTreeDataList;
    }

    private AsnGetObjTreeDataSourceReq setObjTreeReq(int funID, boolean isDelayLload) {
        AsnGetObjTreeDataSourceReq objTreeReqAsn = new AsnGetObjTreeDataSourceReq();
        objTreeReqAsn.funcId = BigInteger.valueOf(funID);
        objTreeReqAsn.userId = BigInteger.valueOf(U2kCommonSecurityUtil.getUserID());
        objTreeReqAsn.delayLoad = isDelayLload ? BigInteger.valueOf(1L) : BigInteger.valueOf(0L);
        return objTreeReqAsn;
    }

    private void queryObjData(AsnGetObjTreeDataSourceReq objTreeReq) {
        this.tempObjDataList = new AsnObjTreeDataStructList();
        this.dataSourceQueryStartTime = System.currentTimeMillis();
        MSGInfo msginfo = new MSGInfo();
        msginfo.cmdCode = 11534867;
        DefaultNEProxy proxy = (DefaultNEProxy)ProxyFactory.getInstance().getNEProxy();
        DFWCommHandle commHandle = proxy.getCommHandle(msginfo, (FStruct)objTreeReq, (DFWResponseReceiver)new ObjTreeResponseReceiver(), 0);
        commHandle.send(new int[]{60});
    }

    private void clearData() {
        if (null != this.tempObjDataList) {
            this.tempObjDataList.clear();
            this.tempObjDataList = null;
        }
        if (null != this.tempDelayLoadList) {
            this.tempDelayLoadList.clear();
            this.tempDelayLoadList = null;
        }
        this.oneList.clear();
    }

    @Override
    public String getRootNodeName() {
        try {
            EmfTopoSubmapInfo info = UMObjTreeUtil.getTopoSubmapInfo(InmTopoUtil.getTopoInterface().getBaseViewRootSubmapID());
            if (null == info) {
                return "";
            }
            return info.m_szLabel;
        }
        catch (Exception ex) {
            UMLogger.exception(ex);
            return "";
        }
    }

    @Override
    public LinkedHashMap<String, UMSelectTreeSearTypeStruct> getSearchTypeModelMap() {
        return this.searchTypeModelMap;
    }

    private void initSearchTypeModelMap() {
        this.searchTypeModelMap = new LinkedHashMap();
        String subNetSearchKey = "subnet";
        UMSelectTreeSearTypeStruct subNetSearchStruct = new UMSelectTreeSearTypeStruct();
        subNetSearchStruct.setLevel(0);
        subNetSearchStruct.setSearchName(UMObjTreeConstants.res.getString("ID_BY_SUBNET"));
        this.searchTypeModelMap.put(subNetSearchKey, subNetSearchStruct);
        String neTypeSearchKey = "netype";
        UMSelectTreeSearTypeStruct neTypeSearchStruct = new UMSelectTreeSearTypeStruct();
        neTypeSearchStruct.setLevel(5);
        neTypeSearchStruct.setSearchName(UMObjTreeConstants.res.getString("ID_BY_NETYPE"));
        neTypeSearchStruct.setIsGroupSearch(true);
        this.searchTypeModelMap.put(neTypeSearchKey, neTypeSearchStruct);
        String neSearchKey = "ne";
        UMSelectTreeSearTypeStruct neSearchStruct = new UMSelectTreeSearTypeStruct();
        neSearchStruct.setLevel(5);
        neSearchStruct.setSearchName(UMObjTreeConstants.res.getString("ID_BY_NE"));
        this.searchTypeModelMap.put(neSearchKey, neSearchStruct);
        String boardSearchKey = "borad";
        UMSelectTreeSearTypeStruct boardSearchStruct = new UMSelectTreeSearTypeStruct();
        boardSearchStruct.setLevel(10);
        boardSearchStruct.setSearchName(UMObjTreeConstants.res.getString("ID_BY_BOARD"));
        this.searchTypeModelMap.put(boardSearchKey, boardSearchStruct);
    }

    @Override
    public boolean isBuildTreeFromTopo() {
        return this.isFromTopoBuild;
    }

    public void setDelayLload(boolean isDelayLload) {
        this.isDelayLload = isDelayLload;
    }

    @Override
    public List<UMSelectTreeOutsideNoticer> getOutsideNoticerList() {
        return this.noticerList;
    }

    @Override
    public void destroy() {
        this.rpcHandler.clearNoticer();
    }

    public void setContainLocalNM(boolean isContainLocalNM) {
        this.isContainLocalNM = isContainLocalNM;
    }

    public boolean isContainLocalNM() {
        return this.isContainLocalNM;
    }

    public boolean isContainThirdParyNe() {
        return this.isContainThirdParyNe;
    }

    public void setContainThirdParyNe(boolean isContainThirdParyNe) {
        this.isContainThirdParyNe = isContainThirdParyNe;
    }

    public boolean isContainOS() {
        return this.isContainOS;
    }

    public void setContainOS(boolean isContainOS) {
        this.isContainOS = isContainOS;
    }

    public void setThirdPartyNeTyepStructs(DeviceTypeStruct[] thirdPartyNeTyepStructs) {
        this.thirdPartyNeTyepStructs = new DeviceTypeStruct[thirdPartyNeTyepStructs.length];
        System.arraycopy(thirdPartyNeTyepStructs, 0, this.thirdPartyNeTyepStructs, 0, thirdPartyNeTyepStructs.length);
    }

    public class DelayLoadResponseReceiver
    extends TEResponseReceiver {
        public synchronized void messageReceived() {
        }

        public synchronized boolean checkDataIntegrity() {
            AsnDelayLoadRsp response = new AsnDelayLoadRsp();
            int result = this.commIt.getCurrRsp((FStruct)response);
            if (result != 0) {
                UMLogger.debug("datasource query failed,The error ProcID:" + this.commIt.getCurrProcID());
                return true;
            }
            AsnDelayLoadStructList rspList = response.delayLoadDataList;
            UMObjTreeDataSource.this.tempDelayLoadList.addAll((Collection)rspList);
            return true;
        }
    }

    public class ObjTreeResponseReceiver
    extends DFWResponseReceiver {
        public void messageReceived() {
            UMLogger.debug("[object tree log]Datasource query cost:" + (System.currentTimeMillis() - UMObjTreeDataSource.this.dataSourceQueryStartTime) + "ms");
        }

        public boolean checkDataIntegrity() {
            AsnGetObjTreeDataSourceRsp response = new AsnGetObjTreeDataSourceRsp();
            int result = this.commIt.getCurrRsp((FStruct)response);
            if (result != 0) {
                UMLogger.debug("[object tree log]Datasource query failed,The error ProcID:" + this.commIt.getCurrProcID());
                UMLogger.debug("[object tree log]Err:" + TEOperationShowMgr.errcodeToErrString((int)result));
                return true;
            }
            UMLogger.debug("[object tree log]Single domain datasource cost:" + (System.currentTimeMillis() - UMObjTreeDataSource.this.dataSourceQueryStartTime) + ",The ProcID:" + this.commIt.getCurrProcID());
            AsnObjTreeDataStructList rspList = response.objTreeData;
            UMObjTreeDataSource.this.tempObjDataList.addAll((Collection)rspList);
            return response.currNum == null || response.totalNum == null || response.currNum == response.totalNum;
        }
    }
}

