/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.component.objselect;

import com.huawei.u2000.umcommon.component.selecttree.tree.UMSelectTreeOutsideEvent;
import com.huawei.u2000.umcommon.component.selecttree.tree.UMSelectTreeOutsideNoticer;
import com.huawei.u2000.util.UMLogger;
import com.swimap.external.dsf.base.rpc.RpcEvent;
import com.swimap.external.dsf.base.rpc.RpcMessage;
import com.swimap.external.dsf.base.rpc.RpcServerPush;
import com.swimap.external.dsf.base.rpc.RpcServerPushHandler;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class UMObjRpcSeverPushHandler
implements RpcServerPushHandler {
    private List<UMSelectTreeOutsideNoticer> noticerList = new ArrayList<UMSelectTreeOutsideNoticer>();
    private boolean hasOpen = false;

    public void registerNoticer(UMSelectTreeOutsideNoticer noticer) {
        if (!this.hasOpen) {
            this.open();
        }
        this.noticerList.add(noticer);
    }

    public void unRegisterNoticer(UMSelectTreeOutsideNoticer noticer) {
        this.noticerList.remove(noticer);
        if (this.noticerList.isEmpty()) {
            this.close();
        }
    }

    public void clearNoticer() {
        this.noticerList.clear();
    }

    public void open() {
        if (!this.hasOpen) {
            UMLogger.debug("(UMObjRpcSeverPushHandler)opened.");
            RpcServerPush.addHandler((String)"eam.ds.event", (RpcServerPushHandler)this);
            this.hasOpen = true;
        }
    }

    public void close() {
        if (this.hasOpen) {
            UMLogger.debug("(UMObjRpcSeverPushHandler)closed.");
            RpcServerPush.removeHandler((RpcServerPushHandler)this);
            this.hasOpen = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleServerPush(final RpcEvent event) {
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                RpcMessage msg = event.getMessage();
                String eventType = msg.getString("eventtype");
                UMLogger.debug("UMObjRpcSeverPushHandler receive event type : " + eventType);
                if (!this.isDeviceChangeEvent(eventType)) return;
                int size = this.noticerList.size();
                for (int i = 0; i < size; ++i) {
                    this.noticerList.get(i).notice(new UMSelectTreeOutsideEvent(UMSelectTreeOutsideEvent.EventType.NODE_CHANGE));
                }
                return;
            }
            catch (Exception e) {
                UMLogger.debug("process modify attribute error");
                return;
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UMObjRpcSeverPushHandler.this.handleServerPush(event);
                }
            });
        }
    }

    private boolean isDeviceChangeEvent(String eventType) {
        return eventType.equals("eam.ds.create_ne") || eventType.equals("eam.ds.delete_ne");
    }
}

