/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.component.lineset.base;

import com.huawei.u2000.umcommon.component.lineset.base.UMTopoDirectLine2D;
import com.huawei.u2000.umcommon.component.lineset.base.UMTopoStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class UMTopoComboBoxRender
extends JComponent
implements ListCellRenderer {
    private UMTopoStroke stroke;
    private Dimension preferredSize;
    private boolean isSelected;

    public UMTopoComboBoxRender(UMTopoStroke stroke) {
        this.stroke = stroke;
        this.preferredSize = new Dimension(80, 18);
    }

    public UMTopoStroke getStroke() {
        return this.stroke;
    }

    public void setStroke(UMTopoStroke stroke) {
        this.stroke = stroke;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        double xx = insets.left;
        double yy = insets.top;
        double ww = size.getWidth() - (double)insets.left - (double)insets.right;
        double hh = size.getHeight() - (double)insets.top - (double)insets.bottom;
        if (this.isSelected) {
            g2.setPaint(Color.gray);
            g2.fillRect((int)xx, (int)yy, (int)ww, (int)hh);
        } else {
            g2.setPaint(Color.white);
            g2.fillRect((int)xx, (int)yy, (int)ww, (int)hh);
        }
        g2.setPaint(Color.black);
        Point2D.Double one = new Point2D.Double(xx, yy + hh / 2.0);
        Point2D.Double two = new Point2D.Double(xx + ww, yy + hh / 2.0);
        UMTopoDirectLine2D line = new UMTopoDirectLine2D(one, two);
        g2.setStroke(this.stroke);
        line.draw(g2, this.stroke.getSelectDirectionType());
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof UMTopoComboBoxRender) {
            UMTopoComboBoxRender in = (UMTopoComboBoxRender)value;
            this.setStroke(in.getStroke());
        } else if (value instanceof UMTopoStroke) {
            this.setStroke((UMTopoStroke)value);
        }
        this.isSelected = isSelected;
        return this;
    }
}

