/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.u2000.umcommon.component.lineset;

import com.huawei.imap12.utility.InmButton;
import com.huawei.u2000.component.dialog.BaseInternalDialog;
import com.huawei.u2000.umcommon.component.lineset.UMLineSetResourceUtil;
import com.huawei.u2000.umcommon.component.lineset.base.UMLineTypeBox;
import com.huawei.u2000.umcommon.component.lineset.base.UMLineWidthBox;
import com.huawei.u2000.umcommon.component.lineset.datastruct.UMLineSetStruct;
import com.huawei.u2000.util.UMLogger;
import com.swimap.iview.framework.util.FrameworkUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public abstract class UMLineSetDialog
extends BaseInternalDialog {
    private static final long serialVersionUID = 123321456654789978L;
    private JLabel labLineType = null;
    private UMLineTypeBox lineType = new UMLineTypeBox(250);
    private JLabel labLineWidth = null;
    private UMLineWidthBox lineWidth = new UMLineWidthBox(250);
    private InmButton okButton = new InmButton(InmButton.OK_TEXT_PROPERTY);
    private InmButton cancelButton = new InmButton(InmButton.CANCEL_TEXT_PROPERTY);
    private UMLineSetStruct lineSetStruct = new UMLineSetStruct();

    public UMLineSetDialog() {
        super(true, true);
        try {
            this.initUI();
            this.setResizable(false);
        }
        catch (Exception ex) {
            UMLogger.exception(ex);
        }
    }

    private void initUI() {
        this.initComponent();
        this.setSize(400, 180);
        this.setLocationRelativeTo(FrameworkUtilities.getMainFrame());
        this.setResizable(false);
        JPanel pnlTopPnl = new JPanel();
        JPanel pnlBottomPnl = new JPanel();
        pnlTopPnl.setLayout(new GridBagLayout());
        Insets insets = new Insets(5, 0, 5, 5);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets = insets;
        pnlTopPnl.add((Component)this.labLineType, gbc);
        ++gbc.gridx;
        pnlTopPnl.add((Component)this.lineType, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        pnlTopPnl.add((Component)this.labLineWidth, gbc);
        ++gbc.gridx;
        pnlTopPnl.add((Component)this.lineWidth, gbc);
        gbc.gridx = 0;
        gbc.gridy = 0;
        pnlBottomPnl.add((Component)this.okButton, gbc);
        ++gbc.gridx;
        pnlBottomPnl.add((Component)this.cancelButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.insets = insets;
        this.setLayout(new GridBagLayout());
        this.add(pnlTopPnl, gbc);
        ++gbc.gridy;
        gbc.insets = new Insets(5, 0, 0, 5);
        this.add(pnlBottomPnl, gbc);
        this.setDefaultCloseOperation(2);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent event) {
                UMLineSetDialog.this.cancelButton.requestFocus();
            }
        });
    }

    private void initComponent() {
        this.setTitle(UMLineSetResourceUtil.getResource("LINE_SET_TITLE"));
        this.labLineType = this.getJLabel(UMLineSetResourceUtil.getResource("LINE_TYPE"));
        this.labLineWidth = this.getJLabel(UMLineSetResourceUtil.getResource("LINE_WIDTH"));
        LinkLineSetAction action = new LinkLineSetAction();
        this.okButton.addActionListener((ActionListener)action);
        this.okButton.setNextFocusableComponent((Component)this.cancelButton);
        this.cancelButton.addActionListener((ActionListener)action);
    }

    private JLabel getJLabel(String textLabel) {
        JLabel labTemp = new JLabel(textLabel + ":");
        labTemp.setPreferredSize(new Dimension(80, 20));
        labTemp.setFocusable(false);
        return labTemp;
    }

    private void onOk() {
        try {
            this.lineSetStruct.setLineType(this.lineType.getSelectedLineType());
            this.lineSetStruct.setLineWidth(this.lineWidth.getSelectedLineWidth());
            if (this.setLineAttribute(this.lineSetStruct)) {
                this.dispose();
            }
        }
        catch (Exception ex) {
            UMLogger.exception(ex);
        }
    }

    public abstract boolean setLineAttribute(UMLineSetStruct var1);

    private void onCancel() {
        this.lineSetStruct = null;
        this.dispose();
    }

    public UMLineTypeBox getLineTypeBox() {
        return this.lineType;
    }

    public UMLineWidthBox getLineWidthBox() {
        return this.lineWidth;
    }

    private class LinkLineSetAction
    implements ActionListener {
        private LinkLineSetAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == UMLineSetDialog.this.okButton) {
                UMLineSetDialog.this.onOk();
            } else if (actionEvent.getSource() == UMLineSetDialog.this.cancelButton) {
                UMLineSetDialog.this.onCancel();
            } else {
                UMLogger.debug(" LinkLineSetAction, actionPerformed others. ");
            }
        }
    }
}

